/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.pgpainless.util.ArmorUtils;

public final class ArmoredOutputStreamFactory {
    public static final String PGPAINLESS = "PGPainless";
    private static String version = "PGPainless";
    private static String[] comment = new String[0];

    private ArmoredOutputStreamFactory() {
    }

    public static ArmoredOutputStream get(OutputStream outputStream) {
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(outputStream);
        armoredOutputStream.setHeader("Version", version);
        for (String comment : ArmoredOutputStreamFactory.comment) {
            ArmorUtils.addCommentHeader(armoredOutputStream, comment);
        }
        return armoredOutputStream;
    }

    public static void setVersionInfo(String versionString) {
        if (versionString == null || versionString.trim().isEmpty()) {
            throw new IllegalArgumentException("Version Info MUST NOT be null NOR empty.");
        }
        version = versionString;
    }

    public static void resetVersionInfo() {
        version = PGPAINLESS;
    }

    public static void setComment(String commentString) {
        if (commentString == null) {
            throw new IllegalArgumentException("Comment cannot be null.");
        }
        String trimmed = commentString.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("Comment cannot be empty.");
        }
        String[] lines = commentString.split("\n");
        comment = lines;
    }

    public static void resetComment() {
        comment = new String[0];
    }
}

