/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.openpgp.PGPPublicKey;

public final class BCUtil {
    private BCUtil() {
    }

    public static int getBitStrength(PGPPublicKey key) throws NoSuchAlgorithmException {
        int bitStrength = key.getBitStrength();
        if (bitStrength == -1) {
            ASN1ObjectIdentifier oid = ((ECPublicBCPGKey)key.getPublicKeyPacket().getKey()).getCurveOID();
            if (oid.getId().equals("1.3.6.1.4.1.11591.15.1")) {
                bitStrength = 256;
            } else if (oid.getId().equals("1.3.6.1.4.1.3029.1.5.1")) {
                bitStrength = 256;
            } else {
                throw new NoSuchAlgorithmException("Unknown curve: " + oid.getId());
            }
        }
        return bitStrength;
    }
}

