/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.exception.KeyValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.selection.key.impl.SignatureKeySelectionStrategy;

public class SigningTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void testEncryptionAndSignatureVerification(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPPublicKeyRing julietKeys = TestKeys.getJulietPublicKeyRing();
        PGPPublicKeyRing romeoKeys = TestKeys.getRomeoPublicKeyRing();
        PGPSecretKeyRing cryptieKeys = TestKeys.getCryptieSecretKeyRing();
        PGPSecretKey cryptieSigningKey = (PGPSecretKey)new SignatureKeySelectionStrategy().selectKeysFromKeyRing(cryptieKeys).iterator().next();
        PGPPublicKeyRingCollection keys = new PGPPublicKeyRingCollection(Arrays.asList(julietKeys, romeoKeys));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign((EncryptionPurpose)EncryptionPurpose.STORAGE).onOutputStream((OutputStream)out).toRecipients(keys).and().toRecipient(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys)).and().signInlineWith(SecretKeyRingProtector.unlockSingleKeyWith((Passphrase)TestKeys.CRYPTIE_PASSPHRASE, (PGPSecretKey)cryptieSigningKey), cryptieKeys, "cryptie@encrypted.key", DocumentSignatureType.CANONICAL_TEXT_DOCUMENT).asciiArmor();
        byte[] messageBytes = "This message is signed and encrypted to Romeo and Juliet.".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream message = new ByteArrayInputStream(messageBytes);
        Streams.pipeAll((InputStream)message, (OutputStream)encryptionStream);
        encryptionStream.close();
        byte[] encrypted = out.toByteArray();
        ByteArrayInputStream cryptIn = new ByteArrayInputStream(encrypted);
        PGPSecretKeyRing romeoSecret = TestKeys.getRomeoSecretKeyRing();
        PGPSecretKeyRing julietSecret = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRingCollection secretKeys = new PGPSecretKeyRingCollection(Arrays.asList(romeoSecret, julietSecret));
        HashSet<OpenPgpV4Fingerprint> trustedFingerprints = new HashSet<OpenPgpV4Fingerprint>();
        trustedFingerprints.add(new OpenPgpV4Fingerprint(cryptieKeys));
        trustedFingerprints.add(new OpenPgpV4Fingerprint(julietKeys));
        PGPPublicKeyRingCollection verificationKeys = new PGPPublicKeyRingCollection(Arrays.asList(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys), romeoKeys));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)cryptIn).decryptWith(secretKeys).verifyWith(trustedFingerprints, verificationKeys).ignoreMissingPublicKeys().build();
        ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plaintextOut);
        decryptionStream.close();
        OpenPgpMetadata metadata = decryptionStream.getResult();
        Assertions.assertTrue((boolean)metadata.isEncrypted());
        Assertions.assertTrue((boolean)metadata.isSigned());
        Assertions.assertTrue((boolean)metadata.isVerified());
        Assertions.assertTrue((boolean)metadata.containsVerifiedSignatureFrom(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys)));
        Assertions.assertFalse((boolean)metadata.containsVerifiedSignatureFrom(julietKeys));
    }

    @Test
    public void testSignWithInvalidUserIdFails() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("alice", "password123");
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockAllKeysWith((Passphrase)Passphrase.fromPassword((String)"password123"), (PGPSecretKeyRing)secretKeys);
        SigningOptions opts = new SigningOptions();
        Assertions.assertThrows(KeyValidationException.class, () -> opts.addInlineSignature(protector, secretKeys, "bob", DocumentSignatureType.CANONICAL_TEXT_DOCUMENT));
    }

    @Test
    public void testSignWithRevokedUserIdFails() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("alice", "password123");
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockAllKeysWith((Passphrase)Passphrase.fromPassword((String)"password123"), (PGPSecretKeyRing)secretKeys);
        PGPSecretKeyRing fSecretKeys = secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId("alice", protector).done();
        SigningOptions opts = new SigningOptions();
        Assertions.assertThrows(KeyValidationException.class, () -> opts.addInlineSignature(protector, fSecretKeys, "alice", DocumentSignatureType.CANONICAL_TEXT_DOCUMENT));
    }
}

