/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.ArmorUtils;

public class GenerateEllipticCurveKeyTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void test(ImplementationFactory implementationFactory) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing keyRing = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}).withDefaultAlgorithms()).withPrimaryUserId(UserId.onlyEmail((String)"alice@wonderland.lit").toString()).withoutPassphrase().build();
        System.out.println(ArmorUtils.toAsciiArmoredString((PGPSecretKeyRing)keyRing));
    }
}

