/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;

public class IllegalKeyFlagsTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void testKeyCannotCarryFlagsTest(ImplementationFactory implementationFactory) {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.generateKeyRing().withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519)).withKeyFlags(new KeyFlag[]{KeyFlag.SIGN_DATA}).withDefaultAlgorithms()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.generateKeyRing().withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER}).withDefaultAlgorithms()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.generateKeyRing().withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519)).withKeyFlags(new KeyFlag[]{KeyFlag.AUTHENTICATION}).withDefaultAlgorithms()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.generateKeyRing().withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.generateKeyRing().withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}).withDefaultAlgorithms()));
    }
}

