/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.info.KeyInfo;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.Passphrase;

public class KeyRingInfoTest {
    @Test
    public void testWithEmilsKeys() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPublicKeyRing publicKeys = TestKeys.getEmilPublicKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        KeyRingInfo pInfo = PGPainless.inspectKeyRing((PGPKeyRing)publicKeys);
        Assertions.assertEquals((long)6284463849526474508L, (long)sInfo.getKeyId());
        Assertions.assertEquals((long)6284463849526474508L, (long)pInfo.getKeyId());
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)sInfo.getFingerprint());
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)pInfo.getFingerprint());
        Assertions.assertEquals((Object)PublicKeyAlgorithm.ECDSA, (Object)sInfo.getAlgorithm());
        Assertions.assertEquals((Object)PublicKeyAlgorithm.ECDSA, (Object)pInfo.getAlgorithm());
        Assertions.assertEquals((int)2, (int)sInfo.getPublicKeys().size());
        Assertions.assertEquals((int)2, (int)pInfo.getPublicKeys().size());
        Assertions.assertEquals(Collections.singletonList("<emil@email.user>"), (Object)sInfo.getUserIds());
        Assertions.assertEquals(Collections.singletonList("<emil@email.user>"), (Object)pInfo.getUserIds());
        Assertions.assertEquals(Collections.singletonList("emil@email.user"), (Object)sInfo.getEmailAddresses());
        Assertions.assertEquals(Collections.singletonList("emil@email.user"), (Object)pInfo.getEmailAddresses());
        Assertions.assertTrue((boolean)sInfo.isSecretKey());
        Assertions.assertFalse((boolean)pInfo.isSecretKey());
        Assertions.assertTrue((boolean)sInfo.isFullyDecrypted());
        Assertions.assertTrue((boolean)pInfo.isFullyDecrypted());
        Assertions.assertEquals((Object)TestKeys.EMIL_CREATION_DATE, (Object)sInfo.getCreationDate());
        Assertions.assertEquals((Object)TestKeys.EMIL_CREATION_DATE, (Object)pInfo.getCreationDate());
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Assertions.assertNull((Object)pInfo.getPrimaryKeyExpirationDate());
        Assertions.assertEquals((float)TestKeys.EMIL_CREATION_DATE.getTime(), (float)sInfo.getLastModified().getTime(), (float)50.0f);
        Assertions.assertEquals((float)TestKeys.EMIL_CREATION_DATE.getTime(), (float)pInfo.getLastModified().getTime(), (float)50.0f);
        Assertions.assertNull((Object)sInfo.getRevocationDate());
        Assertions.assertNull((Object)pInfo.getRevocationDate());
        Date revocationDate = new Date();
        PGPSecretKeyRing revoked = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revoke((SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        System.out.println(ArmorUtils.toAsciiArmoredString((PGPSecretKeyRing)revoked));
        KeyRingInfo rInfo = PGPainless.inspectKeyRing((PGPKeyRing)revoked);
        Assertions.assertNotNull((Object)rInfo.getRevocationDate());
        Assertions.assertEquals((float)revocationDate.getTime(), (float)rInfo.getRevocationDate().getTime(), (float)1000.0f);
        Assertions.assertEquals((float)revocationDate.getTime(), (float)rInfo.getLastModified().getTime(), (float)1000.0f);
    }

    @Test
    public void testIsFullyDecrypted() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isFullyDecrypted());
        secretKeys = KeyRingInfoTest.encryptSecretKeys(secretKeys);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertFalse((boolean)info.isFullyDecrypted());
    }

    @Test
    public void testIsFullyEncrypted() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertFalse((boolean)info.isFullyEncrypted());
        secretKeys = KeyRingInfoTest.encryptSecretKeys(secretKeys);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isFullyEncrypted());
    }

    private static PGPSecretKeyRing encryptSecretKeys(PGPSecretKeyRing secretKeys) throws PGPException {
        return PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).changePassphraseFromOldPassphrase(null).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((String)"sw0rdf1sh")).done();
    }

    @Test
    public void testGetSecretKey() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals((Object)KeyRingUtils.requirePrimarySecretKeyFrom((PGPSecretKeyRing)secretKeys), (Object)info.getSecretKey());
        info = PGPainless.inspectKeyRing((PGPKeyRing)publicKeys);
        Assertions.assertNull((Object)info.getSecretKey());
    }

    @Test
    public void testGetPublicKey() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals((Object)KeyRingUtils.requirePrimaryPublicKeyFrom((PGPKeyRing)secretKeys), (Object)info.getPublicKey());
        Assertions.assertEquals((Object)KeyRingUtils.requirePrimarySecretKeyFrom((PGPSecretKeyRing)secretKeys), (Object)KeyRingUtils.requireSecretKeyFrom((PGPSecretKeyRing)secretKeys, (long)secretKeys.getPublicKey().getKeyID()));
    }

    @Test
    public void dummyS2KTest() throws PGPException, IOException {
        String withDummyS2K = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n\nlQCVBFZuSwwBBAC04VdUUq2REb7+IF/x21yOV3kIn798XRl7A7RiGcE9VpBjT5xM\nxtghWhH1mxyT+nrS36OJxdvtgJb3NB6hhh3qBQC6DmCGbWe61tT6TfyFbN6OvzZK\nMEa6RMunyd+2ErX4RLOcO+9X7a0weVASH5wRYjjqQtvPvt1/k25sloPnZQARAQAB\n/gNlAkdOVQG0EyA8dGVzdEBleGFtcGxlLmNvbT6IuAQTAQIAIgUCVm5LDAIbLwYL\nCQgHAwIGFQgCCQoLBBYCAwECHgECF4AACgkQwaXYFkPfLEVROQP/RF4GXi/yGm6y\nQoDNXFkFiwNhJndayfZxf5Qa+JWz1ltLyal7Dm1c+U6/R/7D25gmEslI+5YrHpbE\nxWXyfG8DbX/5Ef9Be04e9IvjoZboeRpxmyb8IflEw90tJGL8YAK2xWohvayigPnj\njhycZQPMuMK9X35o89oJs+p1MxcC9EOwAgAAnQH9BFZuSwwBBADBDfq8oUK8Jr8I\nVkQEEEZzQ7AWh03oTVodROebMz4vAk34HkrebZuxT4U/8yFIP+kJ3Yie3T8V6F8j\nF3a3ZUHNj2ghgxMbPH+kRKwBphvX8Fb5GtoFVbJq1tNMDaLhVRIkDLBTqQp/20sp\ncuU5+OMzQRUt+Z6GxMaUwt5zLHPUgwARAQAB/gMDAvozhXZdexxPYMKrp7yC2FNN\npVAC61hD0VQKvFeeeXZIGOBx57F1wVBNjuPyglji0kaX0m9yYI+I1V546END4aV/\nhXlZve3r6qYVE9W+T1imwx1NXPSb0j/nMmdiFYFXuyz70yEO+cDwHONzmRLdBZlP\n1DKYBcjF7rwF0gWuIoWgDYdfECo/aANSRQtKw5Q6UowQLzpHTV+X6iL/CbjIL5f8\n1KXPMO1AubxzAW+iatzI7jfL0MvA1FxRpMjpHc1uyT8oIfic17PklbjcnLe5GH78\n2AEGhXwn4bY1H+ss0bxmkJV9HkcMokJUVMQxKw+a6+/IuLXdFtcA5z4CDeIbt9rv\n+b8s0bfq9aW4kDxG3PDcyoMTrTuJLBd6/XwJgdtrmLSCtlU4fLzZEoAd2FVyWbS6\nNys3eXgIBkRRokzKANknne78LpvIiamzinb0iJk2X+AYnRKoy1pUsC+unqaXm9YH\nfdpxv/OXLe13zhSJAT0EGAECAAkFAlZuSwwCGy4AqAkQwaXYFkPfLEWdIAQZAQIA\nBgUCVm5LDAAKCRBv1XiTGF5T/qsmA/9LOUNetM1QtsJ71OVdXE3dutUZULE/27DT\nrA/vvSfhzSFj3U3FnyI7AVsiiiwmnJnthf0zaa2HYBL844Bm7drtzGBNVvddgIJZ\nKBE0x2vUlTVc661e2FBhtLh6xX2nhEy9owc+C7PR9OXvGiET8tTRnUDUO3PgPkyA\nLkHfQMWMR11sA/0YQl4wf3knjk83DVVhFK5fT2lW4hmSO74tuCAA4V71C8B5rJzV\nq2vy1L2bGHAroe+LtX30LtZM5qWKzZzK7jjo1/eaXimOkJcnnpg6jmUP7TMkWpU7\nhlOQ3ZHjS2K5xJYJqBwP86TWPtDLxYD3mTlYtp2dDT8ogV/sEPPd44yWlrACAAA=\n=gU+0\n-----END PGP PRIVATE KEY BLOCK-----\n";
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(withDummyS2K);
        Assertions.assertTrue((boolean)new KeyInfo(secretKeys.getSecretKey()).hasDummyS2K());
    }

    @Test
    public void testGetKeysWithFlagsAndExpiry() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)EllipticCurve._BRAINPOOLP384R1)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}).withDefaultAlgorithms()).withSubKey(KeySpec.getBuilder((KeyType)KeyType.ECDSA((EllipticCurve)EllipticCurve._BRAINPOOLP384R1)).withKeyFlags(new KeyFlag[]{KeyFlag.SIGN_DATA}).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER}).withDefaultAlgorithms()).withPrimaryUserId(UserId.newBuilder().withName("Alice").withEmail("alice@pgpainless.org").build()).withoutPassphrase().build();
        Iterator keys = secretKeys.iterator();
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, 5);
        Date primaryKeyExpiration = calendar.getTime();
        PGPSecretKey primaryKey = (PGPSecretKey)keys.next();
        calendar.setTime(now);
        calendar.add(5, 10);
        Date encryptionKeyExpiration = calendar.getTime();
        PGPSecretKey encryptionKey = (PGPSecretKey)keys.next();
        calendar.setTime(now);
        calendar.add(5, 3);
        Date signingKeyExpiration = calendar.getTime();
        PGPSecretKey signingKey = (PGPSecretKey)keys.next();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(new OpenPgpV4Fingerprint(primaryKey), primaryKeyExpiration, protector).setExpirationDate(new OpenPgpV4Fingerprint(encryptionKey), encryptionKeyExpiration, protector).setExpirationDate(new OpenPgpV4Fingerprint(signingKey), signingKeyExpiration, protector).done();
        KeyRingInfo info = new KeyRingInfo((PGPKeyRing)secretKeys);
        List encryptionKeys = info.getKeysWithKeyFlag(KeyFlag.ENCRYPT_STORAGE);
        Assertions.assertEquals((int)1, (int)encryptionKeys.size());
        Assertions.assertEquals((long)encryptionKey.getKeyID(), (long)((PGPPublicKey)encryptionKeys.get(0)).getKeyID());
        List signingKeys = info.getKeysWithKeyFlag(KeyFlag.SIGN_DATA);
        Assertions.assertEquals((int)1, (int)signingKeys.size());
        Assertions.assertEquals((long)signingKey.getKeyID(), (long)((PGPPublicKey)signingKeys.get(0)).getKeyID());
        List certKeys = info.getKeysWithKeyFlag(KeyFlag.CERTIFY_OTHER);
        Assertions.assertEquals((int)1, (int)certKeys.size());
        Assertions.assertEquals((long)primaryKey.getKeyID(), (long)((PGPPublicKey)certKeys.get(0)).getKeyID());
        Assertions.assertEquals((float)primaryKeyExpiration.getTime(), (float)info.getPrimaryKeyExpirationDate().getTime(), (float)5.0f);
        Assertions.assertEquals((float)signingKeyExpiration.getTime(), (float)info.getExpirationDateForUse(KeyFlag.SIGN_DATA).getTime(), (float)5.0f);
        Assertions.assertEquals((float)primaryKeyExpiration.getTime(), (float)info.getExpirationDateForUse(KeyFlag.ENCRYPT_STORAGE).getTime(), (float)5.0f);
    }
}

