/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.util.ArmorUtils;

public class ArmorUtilsTest {
    @Test
    public void testParseArmorHeader() throws IOException {
        String armoredKey = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: BCPG v1.68\nHash: SHA512\nComment: This is a comment\nComment: This is another comment\n\nmDMEYJ/OsRYJKwYBBAHaRw8BAQdAaOs6IF1fWhN/dqwfSrxD/MNnBXVEx8WlecCa\ncAiSCv60DnRlc3RAdGVzdC50ZXN0iHgEExYKACAFAmCfzrECGwMFFgIDAQAECwkI\nBwUVCgkICwIeAQIZAQAKCRD2lyhrcqSwzDWIAP9i6LfaUp3gEhGQR3FojyhfPVB1\nY3bBU7osj/XOpEN6RAD/YzL9VO45yYp1IUvU1NQWJy42ZHHZy4ZrjULLQ/HbpQW4\nOARgn86xEgorBgEEAZdVAQUBAQdASAPiuOakmDdL0HaSemeNB5Hl7lniD8vCeFgz\nOcgWjSYDAQgHiHUEGBYKAB0FAmCfzrECGwwFFgIDAQAECwkIBwUVCgkICwIeAQAK\nCRD2lyhrcqSwzJ4HAQD7uDYyEsqEGHI4LULfphxPSC5nG9pbBA3mL4ze46uDmAD/\naea172D0TfBwQXZxujLECTce5/1jyTaM+ee8gfw1BQ8=\n=RQHd\n-----END PGP PUBLIC KEY BLOCK-----";
        ByteArrayInputStream in = new ByteArrayInputStream(armoredKey.getBytes(StandardCharsets.UTF_8));
        ArmoredInputStream armorIn = new ArmoredInputStream((InputStream)in);
        Assertions.assertEquals((int)0, (int)ArmorUtils.getCharsetHeaderValues((ArmoredInputStream)armorIn).size());
        List versionHeader = ArmorUtils.getVersionHeaderValues((ArmoredInputStream)armorIn);
        Assertions.assertEquals((int)1, (int)versionHeader.size());
        Assertions.assertEquals((Object)"BCPG v1.68", versionHeader.get(0));
        List hashHeader = ArmorUtils.getHashHeaderValues((ArmoredInputStream)armorIn);
        Assertions.assertEquals((int)1, (int)hashHeader.size());
        Assertions.assertEquals((Object)"SHA512", hashHeader.get(0));
        List hashes = ArmorUtils.getHashAlgorithms((ArmoredInputStream)armorIn);
        Assertions.assertEquals((Object)HashAlgorithm.SHA512, hashes.get(0));
        List commentHeader = ArmorUtils.getCommendHeaderValues((ArmoredInputStream)armorIn);
        Assertions.assertEquals((int)2, (int)commentHeader.size());
        Assertions.assertEquals((Object)"This is a comment", commentHeader.get(0));
        Assertions.assertEquals((Object)"This is another comment", commentHeader.get(1));
        Assertions.assertEquals((int)0, (int)ArmorUtils.getMessageIdHeaderValues((ArmoredInputStream)armorIn).size());
    }

    @Test
    public void testSetMessageId() {
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)new ByteArrayOutputStream());
        ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"abcdefghi01234567890123456789012");
        Assertions.assertThrows(NullPointerException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"tooShort"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"toLooooooooooooooooooooooooooooooooooong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"contains spaces 7890123456789012"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"contains\nnewlines\n12345678901234"));
    }
}

