/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.util.NonEmptyList;

public class NonEmptyListTest {
    @Test
    public void testEmptyListThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new NonEmptyList(Collections.emptyList()));
    }

    @Test
    public void testSingleElementList() {
        List<String> singleElement = Collections.singletonList("Hello");
        NonEmptyList nonEmpty = new NonEmptyList(singleElement);
        Assertions.assertEquals((Object)"Hello", (Object)nonEmpty.get());
        Assertions.assertTrue((boolean)nonEmpty.getOthers().isEmpty());
        Assertions.assertEquals((int)1, (int)nonEmpty.getAll().size());
        Assertions.assertTrue((boolean)nonEmpty.getAll().contains("Hello"));
    }

    @Test
    public void testSingletonElement() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new NonEmptyList((Object)null));
        NonEmptyList nonEmpty = new NonEmptyList((Object)"Foo");
        Assertions.assertEquals((Object)"Foo", (Object)nonEmpty.get());
        Assertions.assertTrue((boolean)nonEmpty.getOthers().isEmpty());
        Assertions.assertEquals(Collections.singletonList("Foo"), (Object)nonEmpty.getAll());
    }

    @Test
    public void testMultipleElements() {
        List<String> multipleElements = Arrays.asList("Foo", "Bar", "Baz");
        NonEmptyList nonEmpty = new NonEmptyList(multipleElements);
        Assertions.assertEquals((Object)"Foo", (Object)nonEmpty.get());
        Assertions.assertEquals(Arrays.asList("Bar", "Baz"), (Object)nonEmpty.getOthers());
        Assertions.assertEquals(multipleElements, (Object)nonEmpty.getAll());
    }
}

