/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.signature.cleartext_signatures.CleartextSignatureProcessor;
import org.pgpainless.signature.cleartext_signatures.InMemoryMultiPassStrategy;
import org.pgpainless.signature.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.util.TestUtils;

public class CleartextSignatureVerificationTest {
    @Test
    public void cleartextSignVerification_InMemoryMultiPassStrategy() throws IOException, PGPException {
        String message = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.\n";
        String signed = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA512\n\nAh, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.\n-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----";
        PGPPublicKeyRing signingKeys = TestKeys.getEmilPublicKeyRing();
        InMemoryMultiPassStrategy multiPassStrategy = MultiPassStrategy.keepMessageInMemory();
        CleartextSignatureProcessor processor = PGPainless.verifyCleartextSignedMessage().onInputStream((InputStream)new ByteArrayInputStream(signed.getBytes(StandardCharsets.UTF_8))).withStrategy((MultiPassStrategy)multiPassStrategy).verifyWith(signingKeys);
        PGPSignature signature = processor.process();
        Assertions.assertEquals((long)signature.getKeyID(), (long)signingKeys.getPublicKey().getKeyID());
        Assertions.assertArrayEquals((byte[])message.getBytes(StandardCharsets.UTF_8), (byte[])multiPassStrategy.getBytes());
    }

    @Test
    public void cleartextSignVerification_FileBasedMultiPassStrategy() throws IOException, PGPException {
        String message = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.\n";
        String signed = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA512\n\nAh, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.\n-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----";
        PGPPublicKeyRing signingKeys = TestKeys.getEmilPublicKeyRing();
        File tempDir = TestUtils.createTempDirectory();
        File file = new File(tempDir, "file");
        MultiPassStrategy multiPassStrategy = MultiPassStrategy.writeMessageToFile((File)file);
        CleartextSignatureProcessor processor = PGPainless.verifyCleartextSignedMessage().onInputStream((InputStream)new ByteArrayInputStream(signed.getBytes(StandardCharsets.UTF_8))).withStrategy(multiPassStrategy).verifyWith(signingKeys);
        PGPSignature signature = processor.process();
        Assertions.assertEquals((long)signature.getKeyID(), (long)signingKeys.getPublicKey().getKeyID());
        FileInputStream fileIn = new FileInputStream(file);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)fileIn, (OutputStream)bytes);
        fileIn.close();
        Assertions.assertArrayEquals((byte[])message.getBytes(StandardCharsets.UTF_8), (byte[])bytes.toByteArray());
    }
}

