/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.elgamal.ElGamal;
import org.pgpainless.key.generation.type.elgamal.ElGamalLength;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.ArmoredOutputStreamFactory;

public class EncryptDecryptTest {
    private static final Logger LOGGER = Logger.getLogger(EncryptDecryptTest.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String testMessage = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.";

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void freshKeysRsaToElGamalTest(ImplementationFactory implementationFactory) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)ElGamal.withLength((ElGamalLength)ElGamalLength._3072)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096)).withKeyFlags(new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}).withDefaultAlgorithms()).withPrimaryUserId("juliet@capulet.lit").withoutPassphrase().build();
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void freshKeysRsaToRsaTest(ImplementationFactory implementationFactory) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleRsaKeyRing("juliet@capulet.lit", RsaLength._3072);
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void freshKeysEcToEcTest(ImplementationFactory implementationFactory) throws IOException, PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleEcKeyRing("romeo@montague.lit");
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleEcKeyRing("juliet@capulet.lit");
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void freshKeysEcToRsaTest(ImplementationFactory implementationFactory) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleEcKeyRing("romeo@montague.lit");
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleRsaKeyRing("juliet@capulet.lit", RsaLength._3072);
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void freshKeysRsaToEcTest(ImplementationFactory implementationFactory) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleEcKeyRing("juliet@capulet.lit");
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void existingRsaKeysTest(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing sender = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRing recipient = TestKeys.getRomeoSecretKeyRing();
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    private void encryptDecryptForSecretKeyRings(PGPSecretKeyRing senderSec, PGPSecretKeyRing recipientSec) throws PGPException, IOException {
        PGPPublicKeyRing recipientPub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)recipientSec);
        PGPPublicKeyRing senderPub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)senderSec);
        UnprotectedKeysProtector keyDecryptor = new UnprotectedKeysProtector();
        byte[] secretMessage = testMessage.getBytes(UTF8);
        ByteArrayOutputStream envelope = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)envelope).toRecipient(recipientPub).and().signInlineWith((SecretKeyRingProtector)keyDecryptor, senderSec, null, DocumentSignatureType.BINARY_DOCUMENT).noArmor();
        Streams.pipeAll((InputStream)new ByteArrayInputStream(secretMessage), (OutputStream)encryptor);
        encryptor.close();
        byte[] encryptedSecretMessage = envelope.toByteArray();
        EncryptionResult encryptionResult = encryptor.getResult();
        Assertions.assertFalse((boolean)encryptionResult.getRecipients().isEmpty());
        for (SubkeyIdentifier encryptionKey : encryptionResult.getRecipients()) {
            Assertions.assertTrue((boolean)KeyRingUtils.keyRingContainsKeyWithId((PGPPublicKeyRing)recipientPub, (long)encryptionKey.getKeyId()));
        }
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)encryptionResult.getEncryptionAlgorithm());
        ByteArrayInputStream envelopeIn = new ByteArrayInputStream(encryptedSecretMessage);
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)envelopeIn).decryptWith((SecretKeyRingProtector)keyDecryptor, KeyRingUtils.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{recipientSec})).verifyWith(KeyRingUtils.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{senderPub})).ignoreMissingPublicKeys().build();
        ByteArrayOutputStream decryptedSecretMessage = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)decryptedSecretMessage);
        decryptor.close();
        Assertions.assertArrayEquals((byte[])secretMessage, (byte[])decryptedSecretMessage.toByteArray());
        OpenPgpMetadata result = decryptor.getResult();
        Assertions.assertTrue((boolean)result.containsVerifiedSignatureFrom(senderPub));
        Assertions.assertTrue((boolean)result.isSigned());
        Assertions.assertTrue((boolean)result.isEncrypted());
        Assertions.assertTrue((boolean)result.isVerified());
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void testDetachedSignatureCreationAndVerification(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing signingKeys = TestKeys.getJulietSecretKeyRing();
        UnprotectedKeysProtector keyRingProtector = new UnprotectedKeysProtector();
        byte[] data = testMessage.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream dummyOut = new ByteArrayOutputStream();
        EncryptionStream signer = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)dummyOut).doNotEncrypt().signDetachedWith((SecretKeyRingProtector)keyRingProtector, signingKeys).noArmor();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)signer);
        signer.close();
        EncryptionResult metadata = signer.getResult();
        Set signatureSet = metadata.getDetachedSignatures().get((Object)((SubkeyIdentifier)metadata.getDetachedSignatures().keySet().iterator().next()));
        ByteArrayOutputStream sigOut = new ByteArrayOutputStream();
        ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.get((OutputStream)sigOut);
        ((PGPSignature)signatureSet.iterator().next()).encode((OutputStream)armorOut);
        armorOut.close();
        String armorSig = sigOut.toString();
        System.out.println(armorSig);
        inputStream = new ByteArrayInputStream(testMessage.getBytes());
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)inputStream).doNotDecrypt().verifyDetachedSignature((InputStream)new ByteArrayInputStream(armorSig.getBytes())).verifyWith(Collections.singleton(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)signingKeys))).ignoreMissingPublicKeys().build();
        dummyOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verifier, (OutputStream)dummyOut);
        verifier.close();
        OpenPgpMetadata decryptionResult = verifier.getResult();
        Assertions.assertFalse((boolean)decryptionResult.getVerifiedSignatures().isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void testOnePassSignatureCreationAndVerification(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing signingKeys = TestKeys.getJulietSecretKeyRing();
        UnprotectedKeysProtector keyRingProtector = new UnprotectedKeysProtector();
        byte[] data = testMessage.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream signOut = new ByteArrayOutputStream();
        EncryptionStream signer = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)signOut).doNotEncrypt().signInlineWith((SecretKeyRingProtector)keyRingProtector, signingKeys).asciiArmor();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)signer);
        signer.close();
        System.out.println(signOut.toString());
        inputStream = new ByteArrayInputStream(signOut.toByteArray());
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)inputStream).doNotDecrypt().verifyWith(Collections.singleton(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)signingKeys))).ignoreMissingPublicKeys().build();
        signOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verifier, (OutputStream)signOut);
        verifier.close();
        OpenPgpMetadata metadata = verifier.getResult();
        Assertions.assertFalse((boolean)metadata.getVerifiedSignatures().isEmpty());
    }

    @Test
    public void expiredSubkeyBacksigTest() throws IOException {
        String key = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nKs2WqI282/DM+Lq/GCSd2nXtS3/KwErTFiF1uHi/N3TwdWA=\n=j1TE\n-----END PGP PUBLIC KEY BLOCK-----\n";
        PGPPublicKeyRing publicKeys = PGPainless.readKeyRing().publicKeyRing(key);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.encryptAndOrSign().onOutputStream((OutputStream)outputStream).toRecipient(publicKeys));
    }
}

