/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class OldSignatureSubpacketsArePreservedOnNewSig {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void verifyOldSignatureSubpacketsArePreservedOnNewExpirationDateSig(ImplementationFactory implementationFactory) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, InterruptedException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("Alice <alice@wonderland.lit>");
        OpenPgpV4Fingerprint subkeyFingerprint = new OpenPgpV4Fingerprint((PGPPublicKey)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getPublicKeys().get(1));
        PGPSignature oldSignature = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getCurrentSubkeyBindingSignature(subkeyFingerprint.getKeyId());
        PGPSignatureSubpacketVector oldPackets = oldSignature.getHashedSubPackets();
        Assertions.assertEquals((long)0L, (long)oldPackets.getKeyExpirationTime());
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(subkeyFingerprint, new Date(), (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        PGPSignature newSignature = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getCurrentSubkeyBindingSignature(subkeyFingerprint.getKeyId());
        PGPSignatureSubpacketVector newPackets = newSignature.getHashedSubPackets();
        Assertions.assertNotEquals((long)0L, (long)newPackets.getKeyExpirationTime());
        Assertions.assertArrayEquals((int[])oldPackets.getPreferredHashAlgorithms(), (int[])newPackets.getPreferredHashAlgorithms());
    }
}

