/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.Passphrase;

public class RevokeSubKeyTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void revokeSukeyTest(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Iterator keysIterator = secretKeys.iterator();
        PGPSecretKey primaryKey = (PGPSecretKey)keysIterator.next();
        PGPSecretKey subKey = (PGPSecretKey)keysIterator.next();
        Assertions.assertFalse((boolean)subKey.getPublicKey().hasRevocation());
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"password123"));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeSubKey(new OpenPgpV4Fingerprint(subKey), (SecretKeyRingProtector)protector).done();
        keysIterator = secretKeys.iterator();
        primaryKey = (PGPSecretKey)keysIterator.next();
        subKey = (PGPSecretKey)keysIterator.next();
        Assertions.assertTrue((boolean)subKey.getPublicKey().hasRevocation());
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void detachedRevokeSubkeyTest(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(secretKeys);
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"password123"));
        PGPSignature revocationCertificate = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).createRevocationCertificate(fingerprint, (SecretKeyRingProtector)protector, RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withDescription("Key no longer used."));
        System.out.println("Revocation Certificate:");
        System.out.println(ArmorUtils.toAsciiArmoredString((byte[])revocationCertificate.getEncoded()));
        PGPPublicKey publicKey = secretKeys.getPublicKey();
        Assertions.assertFalse((boolean)publicKey.hasRevocation());
        publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (PGPSignature)revocationCertificate);
        Assertions.assertTrue((boolean)publicKey.hasRevocation());
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestUtil#provideImplementationFactories"})
    public void testRevocationSignatureTypeCorrect(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Iterator keysIterator = secretKeys.getPublicKeys();
        PGPPublicKey primaryKey = (PGPPublicKey)keysIterator.next();
        PGPPublicKey subKey = (PGPPublicKey)keysIterator.next();
        PasswordBasedSecretKeyRingProtector protector = PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)secretKeys, (Passphrase)Passphrase.fromPassword((String)"password123"));
        SecretKeyRingEditorInterface editor = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys);
        PGPSignature keyRevocation = editor.createRevocationCertificate(primaryKey.getKeyID(), (SecretKeyRingProtector)protector, null);
        PGPSignature subkeyRevocation = editor.createRevocationCertificate(subKey.getKeyID(), (SecretKeyRingProtector)protector, null);
        Assertions.assertEquals((int)SignatureType.KEY_REVOCATION.getCode(), (int)keyRevocation.getSignatureType());
        Assertions.assertEquals((int)SignatureType.SUBKEY_REVOCATION.getCode(), (int)subkeyRevocation.getSignatureType());
    }

    @Test
    public void testThrowsIfRevocationReasonTypeMismatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.USER_ID_NO_LONGER_VALID));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.KEY_SUPERSEDED));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.KEY_COMPROMISED));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RevocationAttributes.createCertificateRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED));
    }

    @Test
    public void testReasonToString() {
        RevocationAttributes.Reason reason = RevocationAttributes.Reason.KEY_COMPROMISED;
        Assertions.assertEquals((Object)"2 - KEY_COMPROMISED", (Object)reason.toString());
    }
}

