/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.collection.PGPKeyRingCollection;
import org.pgpainless.key.util.KeyRingUtils;

class KeyRingReaderTest {
    KeyRingReaderTest() {
    }

    @Test
    public void assertThatPGPUtilsDetectAsciiArmoredData() throws IOException, PGPException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("pub_keys_10_pieces.asc");
        InputStream possiblyArmored = PGPUtil.getDecoderStream((InputStream)PGPUtil.getDecoderStream((InputStream)inputStream));
        PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(possiblyArmored, ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        Assertions.assertEquals((int)10, (int)collection.size());
    }

    @Test
    void publicKeyRingCollectionFromStream() throws IOException, PGPException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("pub_keys_10_pieces.asc");
        PGPPublicKeyRingCollection rings = PGPainless.readKeyRing().publicKeyRingCollection(inputStream);
        Assertions.assertEquals((int)10, (int)rings.size());
    }

    @Test
    void publicKeyRingCollectionFromNotArmoredStream() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        ArrayList<PGPPublicKeyRing> collection = new ArrayList<PGPPublicKeyRing>();
        for (int i = 0; i < 10; ++i) {
            PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("user_" + i + "@encrypted.key");
            collection.add(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys));
        }
        PGPPublicKeyRingCollection originalRings = new PGPPublicKeyRingCollection(collection);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        originalRings.encode((OutputStream)out);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
        PGPPublicKeyRingCollection parsedRings = PGPainless.readKeyRing().publicKeyRingCollection((InputStream)inputStream);
        Assertions.assertEquals((int)10, (int)parsedRings.size());
    }

    @Test
    void publicKeyRingCollectionFromString() throws IOException, PGPException, URISyntaxException {
        URL resource = this.getClass().getClassLoader().getResource("pub_keys_10_pieces.asc");
        String armoredString = new String(Files.readAllBytes(new File(resource.toURI()).toPath()));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(armoredString.getBytes(StandardCharsets.UTF_8));
        PGPPublicKeyRingCollection rings = PGPainless.readKeyRing().publicKeyRingCollection((InputStream)inputStream);
        Assertions.assertEquals((int)10, (int)rings.size());
    }

    @Test
    void publicKeyRingCollectionFromBytes() throws IOException, PGPException, URISyntaxException {
        URL resource = this.getClass().getClassLoader().getResource("pub_keys_10_pieces.asc");
        byte[] bytes = Files.readAllBytes(new File(resource.toURI()).toPath());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        PGPPublicKeyRingCollection rings = PGPainless.readKeyRing().publicKeyRingCollection((InputStream)byteArrayInputStream);
        Assertions.assertEquals((int)10, (int)rings.size());
    }

    @Test
    void parsePublicKeysSingleArmored() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)1, (int)this.getPgpPublicKeyRingsFromResource("single_pub_key_armored.asc").size());
    }

    @Test
    void parsePublicKeysSingleBinary() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)1, (int)this.getPgpPublicKeyRingsFromResource("single_pub_key_binary.key").size());
    }

    @Test
    void parsePublicKeysMultiplyArmoredSingleHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_armored_single_header.asc").size());
    }

    @Test
    void parsePublicKeysMultiplyArmoredOwnHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_armored_own_header.asc").size());
    }

    @Test
    void parsePublicKeysMultiplyArmoredOwnWithSingleHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_armored_own_with_single_header.asc").size());
    }

    @Test
    void parsePublicKeysMultiplyBinary() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpPublicKeyRingsFromResource("10_pub_keys_binary.key").size());
    }

    @Test
    void parseSecretKeysSingleArmored() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)1, (int)this.getPgpSecretKeyRingsFromResource("single_prv_key_armored.asc").size());
    }

    @Test
    void parseSecretKeysSingleBinary() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)1, (int)this.getPgpSecretKeyRingsFromResource("single_prv_key_binary.key").size());
    }

    @Test
    void parseSecretKeysMultiplyArmoredSingleHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_armored_single_header.asc").size());
    }

    @Test
    void parseSecretKeysMultiplyArmoredOwnHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_armored_own_header.asc").size());
    }

    @Test
    void parseSecretKeysMultiplyArmoredOwnWithSingleHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_armored_own_with_single_header.asc").size());
    }

    @Test
    void parseSecretKeysMultiplyBinary() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPgpSecretKeyRingsFromResource("10_prv_keys_binary.key").size());
    }

    @Test
    void parseKeysMultiplyArmoredOwnHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPGPKeyRingsFromResource("10_prv_and_pub_keys_armored_own_header.asc").size());
    }

    @Test
    void parseKeysMultiplyArmoredOwnWithSingleHeader() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPGPKeyRingsFromResource("10_prv_and_pub_keys_armored_own_with_single_header.asc").size());
    }

    @Test
    void parseKeysMultiplyBinary() throws IOException, PGPException, URISyntaxException {
        Assertions.assertEquals((int)10, (int)this.getPGPKeyRingsFromResource("10_prv_and_pub_keys_binary.key").size());
    }

    private InputStream getFileInputStreamFromResource(String fileName) throws IOException, URISyntaxException {
        URL resource = this.getClass().getClassLoader().getResource(fileName);
        assert (resource != null);
        return new FileInputStream(new File(resource.toURI()));
    }

    private PGPKeyRingCollection getPGPKeyRingsFromResource(String fileName) throws IOException, URISyntaxException, PGPException {
        return PGPainless.readKeyRing().keyRingCollection(this.getFileInputStreamFromResource(fileName), true);
    }

    private PGPPublicKeyRingCollection getPgpPublicKeyRingsFromResource(String fileName) throws IOException, URISyntaxException, PGPException {
        return PGPainless.readKeyRing().publicKeyRingCollection(this.getFileInputStreamFromResource(fileName));
    }

    private PGPSecretKeyRingCollection getPgpSecretKeyRingsFromResource(String fileName) throws IOException, URISyntaxException, PGPException {
        return PGPainless.readKeyRing().secretKeyRingCollection(this.getFileInputStreamFromResource(fileName));
    }
}

