/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;

public class UnlockSecretKeyTest {
    @Test
    public void testUnlockSecretKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeyRing = PGPainless.generateKeyRing().simpleEcKeyRing("alice@wonderland.lit", "heureka!");
        PGPSecretKey secretKey = secretKeyRing.getSecretKey();
        SecretKeyRingProtector correctPassphrase = SecretKeyRingProtector.unlockAllKeysWith((Passphrase)Passphrase.fromPassword((String)"heureka!"), (PGPSecretKeyRing)secretKeyRing);
        SecretKeyRingProtector incorrectPassphrase = SecretKeyRingProtector.unlockAllKeysWith((Passphrase)Passphrase.fromPassword((String)"bazinga!"), (PGPSecretKeyRing)secretKeyRing);
        SecretKeyRingProtector emptyPassphrase = SecretKeyRingProtector.unlockAllKeysWith((Passphrase)Passphrase.emptyPassphrase(), (PGPSecretKeyRing)secretKeyRing);
        Passphrase cleared = Passphrase.fromPassword((String)"cleared");
        cleared.clear();
        SecretKeyRingProtector invalidPassphrase = SecretKeyRingProtector.unlockAllKeysWith((Passphrase)cleared, (PGPSecretKeyRing)secretKeyRing);
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)correctPassphrase);
        Assertions.assertNotNull((Object)privateKey);
        Assertions.assertThrows(WrongPassphraseException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)incorrectPassphrase));
        Assertions.assertThrows(WrongPassphraseException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)emptyPassphrase));
        Assertions.assertThrows(WrongPassphraseException.class, () -> UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)invalidPassphrase));
    }
}

