/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.BCUtil;

public class BCUtilTest {
    private static final Logger LOGGER = Logger.getLogger(BCUtil.class.getName());

    @Test
    public void keyRingToCollectionTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPSecretKeyRing sec = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}).withDefaultAlgorithms()).withPrimaryUserId("donald@duck.tails").withoutPassphrase().build();
        PGPPublicKeyRing pub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)sec);
        LOGGER.log(Level.FINER, "Main ID: " + sec.getPublicKey().getKeyID() + " " + pub.getPublicKey().getKeyID());
        int secSize = 1;
        Iterator secPubIt = sec.getPublicKeys();
        while (secPubIt.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)secPubIt.next();
            LOGGER.log(Level.FINER, secSize + " " + k.getKeyID() + " " + k.isEncryptionKey() + " " + k.isMasterKey());
            ++secSize;
        }
        LOGGER.log(Level.FINER, "After BCUtil.publicKeyRingFromSecretKeyRing()");
        int pubSize = 1;
        Iterator pubPubIt = pub.getPublicKeys();
        while (pubPubIt.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)pubPubIt.next();
            LOGGER.log(Level.FINER, pubSize + " " + k.getKeyID() + " " + k.isEncryptionKey() + " " + k.isMasterKey());
            ++pubSize;
        }
        Assertions.assertEquals((int)secSize, (int)pubSize);
        PGPSecretKeyRingCollection secCol = KeyRingUtils.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{sec});
        int secColSize = 0;
        Iterator secColIt = secCol.getKeyRings();
        while (secColIt.hasNext()) {
            PGPSecretKeyRing r = (PGPSecretKeyRing)secColIt.next();
            LOGGER.log(Level.FINER, "" + r.getPublicKey().getKeyID());
            ++secColSize;
        }
        LOGGER.log(Level.FINER, "SecCol: " + secColSize);
        PGPPublicKeyRingCollection pubCol = KeyRingUtils.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{pub});
        int pubColSize = 0;
        Iterator pubColIt = pubCol.getKeyRings();
        while (pubColIt.hasNext()) {
            PGPPublicKeyRing r = (PGPPublicKeyRing)pubColIt.next();
            LOGGER.log(Level.FINER, "" + r.getPublicKey().getKeyID());
            ++pubColSize;
        }
        LOGGER.log(Level.FINER, "PubCol: " + pubColSize);
    }

    @Test
    public void removeUnsignedKeysTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PGPSecretKeyRing alice = PGPainless.generateKeyRing().simpleRsaKeyRing("alice@wonderland.lit", RsaLength._1024);
        PGPSecretKeyRing mallory = PGPainless.generateKeyRing().simpleEcKeyRing("mallory@mall.ory");
        PGPSecretKey subKey = null;
        Iterator sit = mallory.getSecretKeys();
        while (sit.hasNext()) {
            PGPSecretKey s = (PGPSecretKey)sit.next();
            if (s.isMasterKey()) continue;
            subKey = s;
            break;
        }
        Assertions.assertNotNull(subKey);
        PGPSecretKeyRing alice_mallory = PGPSecretKeyRing.insertSecretKey((PGPSecretKeyRing)alice, subKey);
        Assertions.assertNotNull((Object)alice_mallory.getSecretKey(subKey.getKeyID()));
        PGPSecretKeyRing cleaned = KeyRingUtils.removeUnassociatedKeysFromKeyRing((PGPSecretKeyRing)alice_mallory, (PGPPublicKey)alice.getPublicKey());
        Assertions.assertNull((Object)cleaned.getSecretKey(subKey.getKeyID()));
    }
}

