/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;

public class TestUtils {
    public static SimpleDateFormat UTC_PARSER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final Random RANDOM = new Random();

    public static Date getUTCDate(String dateString) {
        try {
            return UTC_PARSER.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int getNumberOfItemsInIterator(Iterator<?> iterator) {
        int num = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++num;
        }
        return num;
    }

    public static File createTempDirectory() throws IOException {
        String name = TestUtils.randomString(10);
        File dir = Files.createTempDirectory(name, new FileAttribute[0]).toFile();
        return dir;
    }

    private static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHABET.charAt(RANDOM.nextInt(ALPHABET.length())));
        }
        return sb.toString();
    }
}

