/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.key;

import java.io.IOException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.util.selection.key.SecretKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.EncryptionKeySelectionStrategy;
import org.pgpainless.util.selection.key.impl.HasAnyKeyFlagSelectionStrategy;
import org.pgpainless.util.selection.key.impl.Or;

public class AndOrSelectionStrategyTest {
    @Test
    public void testOr() throws IOException, PGPException {
        PGPSecretKeyRing ring = TestKeys.getEmilSecretKeyRing();
        Iterator secretKeys = ring.getSecretKeys();
        Or.SecKeySelectionStrategy secStrategy = new Or.SecKeySelectionStrategy(new SecretKeySelectionStrategy[]{new HasAnyKeyFlagSelectionStrategy.SecretKey(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}), new HasAnyKeyFlagSelectionStrategy.SecretKey(new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE})});
        PGPSecretKey certSecKey = (PGPSecretKey)secretKeys.next();
        PGPSecretKey cryptSecKey = (PGPSecretKey)secretKeys.next();
        Assertions.assertFalse((boolean)secStrategy.accept(certSecKey));
        Assertions.assertTrue((boolean)secStrategy.accept(cryptSecKey));
        Iterator publicKeys = ring.getPublicKeys();
        Or.PubKeySelectionStrategy pubStrategy = new Or.PubKeySelectionStrategy(new PublicKeySelectionStrategy[]{new EncryptionKeySelectionStrategy(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}), new EncryptionKeySelectionStrategy(new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE})});
        PGPPublicKey certPubKey = (PGPPublicKey)publicKeys.next();
        PGPPublicKey cryptPubKey = (PGPPublicKey)publicKeys.next();
        Assertions.assertFalse((boolean)pubStrategy.accept(certPubKey));
        Assertions.assertTrue((boolean)pubStrategy.accept(cryptPubKey));
    }
}

