/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.key;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.selection.key.impl.KeyBelongsToKeyRing;

public class KeyBelongsToKeyRingTest {
    @Test
    public void testStrategyOnlyAcceptsKeysThatBelongToKeyRing() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("test@test.test");
        Iterator iterator = secretKeys.getPublicKeys();
        PGPPublicKey primaryKey = (PGPPublicKey)iterator.next();
        PGPPublicKey subKey = (PGPPublicKey)iterator.next();
        KeyBelongsToKeyRing.PubkeySelectionStrategy strategy = new KeyBelongsToKeyRing.PubkeySelectionStrategy(primaryKey);
        Assertions.assertTrue((boolean)strategy.accept(primaryKey));
        Assertions.assertTrue((boolean)strategy.accept(subKey));
        PGPSecretKeyRing unrelatedKeys = TestKeys.getEmilSecretKeyRing();
        Iterator unrelated = unrelatedKeys.getPublicKeys();
        while (unrelated.hasNext()) {
            PGPPublicKey unrelatedKey = (PGPPublicKey)unrelated.next();
            Assertions.assertFalse((boolean)strategy.accept(unrelatedKey));
        }
    }
}

