/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class SubkeyIdentifier {
    private final OpenPgpV4Fingerprint primaryKeyFingerprint;
    private final OpenPgpV4Fingerprint subkeyFingerprint;

    public SubkeyIdentifier(@Nonnull PGPKeyRing keyRing, long keyId) {
        this(new OpenPgpV4Fingerprint(keyRing.getPublicKey()), new OpenPgpV4Fingerprint(keyRing.getPublicKey(keyId)));
    }

    public SubkeyIdentifier(@Nonnull OpenPgpV4Fingerprint primaryKeyFingerprint) {
        this(primaryKeyFingerprint, primaryKeyFingerprint);
    }

    public SubkeyIdentifier(@Nonnull OpenPgpV4Fingerprint primaryKeyFingerprint, @Nonnull OpenPgpV4Fingerprint subkeyFingerprint) {
        this.primaryKeyFingerprint = primaryKeyFingerprint;
        this.subkeyFingerprint = subkeyFingerprint;
    }

    public SubkeyIdentifier(PGPSecretKeyRing secretKeys) {
        this((PGPKeyRing)secretKeys, secretKeys.getPublicKey().getKeyID());
    }

    @Nonnull
    public OpenPgpV4Fingerprint getFingerprint() {
        return this.getSubkeyFingerprint();
    }

    public long getKeyId() {
        return this.getSubkeyId();
    }

    @Nonnull
    public OpenPgpV4Fingerprint getPrimaryKeyFingerprint() {
        return this.primaryKeyFingerprint;
    }

    public long getPrimaryKeyId() {
        return this.getPrimaryKeyFingerprint().getKeyId();
    }

    @Nonnull
    public OpenPgpV4Fingerprint getSubkeyFingerprint() {
        return this.subkeyFingerprint;
    }

    public long getSubkeyId() {
        return this.getSubkeyFingerprint().getKeyId();
    }

    public int hashCode() {
        return this.primaryKeyFingerprint.hashCode() * 31 + this.subkeyFingerprint.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubkeyIdentifier)) {
            return false;
        }
        SubkeyIdentifier other = (SubkeyIdentifier)obj;
        return this.getPrimaryKeyFingerprint().equals(other.getPrimaryKeyFingerprint()) && this.getSubkeyFingerprint().equals(other.getSubkeyFingerprint());
    }

    public String toString() {
        return this.getSubkeyFingerprint() + " " + this.getPrimaryKeyFingerprint();
    }
}

