/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.collection;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.pgpainless.implementation.ImplementationFactory;

public class PGPKeyRingCollection {
    private final PGPSecretKeyRingCollection pgpSecretKeyRingCollection;
    private final PGPPublicKeyRingCollection pgpPublicKeyRingCollection;

    public PGPKeyRingCollection(@Nonnull byte[] encoding, boolean isSilent) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), isSilent);
    }

    public PGPKeyRingCollection(@Nonnull InputStream in, boolean isSilent) throws IOException, PGPException {
        Object obj;
        InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)PGPUtil.getDecoderStream((InputStream)in));
        PGPObjectFactory pgpFact = new PGPObjectFactory(decoderStream, ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        ArrayList<PGPSecretKeyRing> secretKeyRings = new ArrayList<PGPSecretKeyRing>();
        ArrayList<PGPPublicKeyRing> publicKeyRings = new ArrayList<PGPPublicKeyRing>();
        while ((obj = pgpFact.nextObject()) != null) {
            if (obj instanceof MarkerPacket) continue;
            if (obj instanceof PGPSecretKeyRing) {
                secretKeyRings.add((PGPSecretKeyRing)obj);
                continue;
            }
            if (obj instanceof PGPPublicKeyRing) {
                publicKeyRings.add((PGPPublicKeyRing)obj);
                continue;
            }
            if (isSilent) continue;
            throw new PGPException(obj.getClass().getName() + " found where " + PGPSecretKeyRing.class.getSimpleName() + " or " + PGPPublicKeyRing.class.getSimpleName() + " expected");
        }
        this.pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(secretKeyRings);
        this.pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(publicKeyRings);
    }

    public PGPKeyRingCollection(@Nonnull Collection<PGPKeyRing> collection, boolean isSilent) throws IOException, PGPException {
        ArrayList<PGPSecretKeyRing> secretKeyRings = new ArrayList<PGPSecretKeyRing>();
        ArrayList<PGPPublicKeyRing> publicKeyRings = new ArrayList<PGPPublicKeyRing>();
        for (PGPKeyRing pgpKeyRing : collection) {
            if (pgpKeyRing instanceof PGPSecretKeyRing) {
                secretKeyRings.add((PGPSecretKeyRing)pgpKeyRing);
                continue;
            }
            if (pgpKeyRing instanceof PGPPublicKeyRing) {
                publicKeyRings.add((PGPPublicKeyRing)pgpKeyRing);
                continue;
            }
            if (isSilent) continue;
            throw new PGPException(pgpKeyRing.getClass().getName() + " found where " + PGPSecretKeyRing.class.getSimpleName() + " or " + PGPPublicKeyRing.class.getSimpleName() + " expected");
        }
        this.pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(secretKeyRings);
        this.pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(publicKeyRings);
    }

    public PGPSecretKeyRingCollection getPGPSecretKeyRingCollection() {
        return this.pgpSecretKeyRingCollection;
    }

    public PGPPublicKeyRingCollection getPgpPublicKeyRingCollection() {
        return this.pgpPublicKeyRingCollection;
    }

    public int size() {
        return this.pgpSecretKeyRingCollection.size() + this.pgpPublicKeyRingCollection.size();
    }
}

