/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.cleartext_signatures;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.pgpainless.signature.cleartext_signatures.CleartextSignatureProcessor;
import org.pgpainless.signature.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.signature.cleartext_signatures.VerifyCleartextSignatures;

public class VerifyCleartextSignaturesImpl
implements VerifyCleartextSignatures {
    private InputStream inputStream;
    private MultiPassStrategy multiPassStrategy;
    private PGPPublicKeyRingCollection verificationKeys;

    @Override
    public VerifyCleartextSignatures.WithStrategy onInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return new WithStrategyImpl();
    }

    public class VerifyWithImpl
    implements VerifyCleartextSignatures.VerifyWith {
        @Override
        public CleartextSignatureProcessor verifyWith(PGPPublicKeyRing publicKey) throws PGPException, IOException {
            VerifyCleartextSignaturesImpl.this.verificationKeys = new PGPPublicKeyRingCollection(Collections.singleton(publicKey));
            return new CleartextSignatureProcessor(VerifyCleartextSignaturesImpl.this.inputStream, VerifyCleartextSignaturesImpl.this.verificationKeys, VerifyCleartextSignaturesImpl.this.multiPassStrategy);
        }

        @Override
        public CleartextSignatureProcessor verifyWith(PGPPublicKeyRingCollection publicKeys) throws IOException {
            VerifyCleartextSignaturesImpl.this.verificationKeys = publicKeys;
            return new CleartextSignatureProcessor(VerifyCleartextSignaturesImpl.this.inputStream, VerifyCleartextSignaturesImpl.this.verificationKeys, VerifyCleartextSignaturesImpl.this.multiPassStrategy);
        }
    }

    public class WithStrategyImpl
    implements VerifyCleartextSignatures.WithStrategy {
        @Override
        public VerifyCleartextSignatures.VerifyWith withStrategy(MultiPassStrategy multiPassStrategy) {
            if (multiPassStrategy == null) {
                throw new NullPointerException("MultiPassStrategy cannot be null.");
            }
            VerifyCleartextSignaturesImpl.this.multiPassStrategy = multiPassStrategy;
            return new VerifyWithImpl();
        }
    }
}

