/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.PGPUtilWrapper;
import org.pgpainless.util.TestAllImplementations;

public class PGPUtilWrapperTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void testGetDecoderStream() throws IOException {
        ByteArrayInputStream msg = new ByteArrayInputStream("Foo\nBar".getBytes(StandardCharsets.UTF_8));
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStream litOut = literalDataGenerator.open((OutputStream)out, 't', "", new Date(), new byte[512]);
        Streams.pipeAll((InputStream)msg, (OutputStream)litOut);
        literalDataGenerator.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory((InputStream)in);
        PGPLiteralData literalData = (PGPLiteralData)objectFactory.nextObject();
        InputStream litIn = literalData.getDataStream();
        BufferedInputStream bufIn = new BufferedInputStream(litIn);
        InputStream decoderStream = PGPUtilWrapper.getDecoderStream((BufferedInputStream)bufIn);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decoderStream, (OutputStream)result);
        Assertions.assertEquals((Object)"Foo\nBar", (Object)result.toString());
    }
}

