/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public class IgnoreUnknownSignatureVersionsTest {
    private static final String CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: Bob's OpenPGP certificate\n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\nNEJd3XZRzaXZE2aAMQ==\n=NXei\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String message = "Hello World :)";
    private static PGPPublicKeyRing cert;

    @Test
    public void baseCase() throws IOException, PGPException {
        String BASE_CASE = "-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCgBvBYJhaVoTCRD7/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9u\ncy5zZXF1b2lhLXBncC5vcmcQWMonyHF4Gcry0TOPKj/RQyhVoSI+1C31rXHHBcxI\nyxYhBNGmbhojsYLJmA94jPv8yCoBXnMwAAB7RwwAo+/P0/foJZp0/4yZWbBu/uNC\n0afvqv/tfcLVX6tZEmXkh6DfCtDwqX0vWrwAJuqtLUC8RvUDj7X4vi90/LhU2GUs\n+h+eZoQ3VwZ8jmfisQs7FUhbPOURZhRoS4UT8w7Le3pLodj5vAcaB6VvZP7SZ2Ls\niNob9J0godpjlkGGWGqjWl0AO1kVvaNJTXpNhwpCRZyad8wUgri5QtrHWzRo4FBb\nJzrbJqWaS1FaqMCuPwcpq0KLsn4v6i4sD6Vy3HOaF29+avWNawnMLB/92csl4blq\nJ20D2sKGUGcJpmLdiupnDdsHWU1jSpUvoUv+viE1RDqBFDQaNkUxdv5DhDOSRcwI\na8Upx9lG8ol0uuDE4jieie4wuNq41jVRWJ55aJ46zO9QPifq59SMcRj8uN8byRKz\nWdg/ngldiePCjg2RQztgb6Hsut7xeYYhuAYQ8m1+vLCnS8tRnCqhAqxdW51uSfIq\nxKukH+bioF/+baqBu1AlXmNVou1uiXJaDzZ6wQfBwsE7BAABCgBvBYJhaVoTCRD7\n/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9ucy5zZXF1b2lhLXBncC5vcmcQ\nWMonyHF4Gcry0TOPKj/RQyhVoSI+1C31rXHHBcxIyxYhBNGmbhojsYLJmA94jPv8\nyCoBXnMwAAB7RwwAo+/P0/foJZp0/4yZWbBu/uNC0afvqv/tfcLVX6tZEmXkh6Df\nCtDwqX0vWrwAJuqtLUC8RvUDj7X4vi90/LhU2GUs+h+eZoQ3VwZ8jmfisQs7FUhb\nPOURZhRoS4UT8w7Le3pLodj5vAcaB6VvZP7SZ2LsiNob9J0godpjlkGGWGqjWl0A\nO1kVvaNJTXpNhwpCRZyad8wUgri5QtrHWzRo4FBbJzrbJqWaS1FaqMCuPwcpq0KL\nsn4v6i4sD6Vy3HOaF29+avWNawnMLB/92csl4blqJ20D2sKGUGcJpmLdiupnDdsH\nWU1jSpUvoUv+viE1RDqBFDQaNkUxdv5DhDOSRcwIa8Upx9lG8ol0uuDE4jieie4w\nuNq41jVRWJ55aJ46zO9QPifq59SMcRj8uN8byRKzWdg/ngldiePCjg2RQztgb6Hs\nut7xeYYhuAYQ8m1+vLCnS8tRnCqhAqxdW51uSfIqxKukH+bioF/+baqBu1AlXmNV\nou1uiXJaDzZ6wQfB\n=uHRc\n-----END PGP SIGNATURE-----\n";
        OpenPgpMetadata metadata = this.verifySignature(cert, BASE_CASE);
        Assertions.assertTrue((boolean)metadata.isVerified());
    }

    @Test
    public void detached_SIG4_SIG23() throws PGPException, IOException {
        String SIG4SIG23 = "-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCgBvBYJhaVoTCRD7/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9u\ncy5zZXF1b2lhLXBncC5vcmcQWMonyHF4Gcry0TOPKj/RQyhVoSI+1C31rXHHBcxI\nyxYhBNGmbhojsYLJmA94jPv8yCoBXnMwAAB7RwwAo+/P0/foJZp0/4yZWbBu/uNC\n0afvqv/tfcLVX6tZEmXkh6DfCtDwqX0vWrwAJuqtLUC8RvUDj7X4vi90/LhU2GUs\n+h+eZoQ3VwZ8jmfisQs7FUhbPOURZhRoS4UT8w7Le3pLodj5vAcaB6VvZP7SZ2Ls\niNob9J0godpjlkGGWGqjWl0AO1kVvaNJTXpNhwpCRZyad8wUgri5QtrHWzRo4FBb\nJzrbJqWaS1FaqMCuPwcpq0KLsn4v6i4sD6Vy3HOaF29+avWNawnMLB/92csl4blq\nJ20D2sKGUGcJpmLdiupnDdsHWU1jSpUvoUv+viE1RDqBFDQaNkUxdv5DhDOSRcwI\na8Upx9lG8ol0uuDE4jieie4wuNq41jVRWJ55aJ46zO9QPifq59SMcRj8uN8byRKz\nWdg/ngldiePCjg2RQztgb6Hsut7xeYYhuAYQ8m1+vLCnS8tRnCqhAqxdW51uSfIq\nxKukH+bioF/+baqBu1AlXmNVou1uiXJaDzZ6wQfBwsE7FwABCgBvBYJhaVoTCRD7\n/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9ucy5zZXF1b2lhLXBncC5vcmcQ\nWMonyHF4Gcry0TOPKj/RQyhVoSI+1C31rXHHBcxIyxYhBNGmbhojsYLJmA94jPv8\nyCoBXnMwAAB7RwwAo+/P0/foJZp0/4yZWbBu/uNC0afvqv/tfcLVX6tZEmXkh6Df\nCtDwqX0vWrwAJuqtLUC8RvUDj7X4vi90/LhU2GUs+h+eZoQ3VwZ8jmfisQs7FUhb\nPOURZhRoS4UT8w7Le3pLodj5vAcaB6VvZP7SZ2LsiNob9J0godpjlkGGWGqjWl0A\nO1kVvaNJTXpNhwpCRZyad8wUgri5QtrHWzRo4FBbJzrbJqWaS1FaqMCuPwcpq0KL\nsn4v6i4sD6Vy3HOaF29+avWNawnMLB/92csl4blqJ20D2sKGUGcJpmLdiupnDdsH\nWU1jSpUvoUv+viE1RDqBFDQaNkUxdv5DhDOSRcwIa8Upx9lG8ol0uuDE4jieie4w\nuNq41jVRWJ55aJ46zO9QPifq59SMcRj8uN8byRKzWdg/ngldiePCjg2RQztgb6Hs\nut7xeYYhuAYQ8m1+vLCnS8tRnCqhAqxdW51uSfIqxKukH+bioF/+baqBu1AlXmNV\nou1uiXJaDzZ6wQfB\n=/JL1\n-----END PGP SIGNATURE-----\n";
        OpenPgpMetadata metadata = this.verifySignature(cert, SIG4SIG23);
        Assertions.assertTrue((boolean)metadata.isVerified());
    }

    @Test
    public void detached_SIG23_SIG4() throws PGPException, IOException {
        String SIG23SIG4 = "-----BEGIN PGP SIGNATURE-----\n\nwsE7FwABCgBvBYJhaVoTCRD7/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9u\ncy5zZXF1b2lhLXBncC5vcmcQWMonyHF4Gcry0TOPKj/RQyhVoSI+1C31rXHHBcxI\nyxYhBNGmbhojsYLJmA94jPv8yCoBXnMwAAB7RwwAo+/P0/foJZp0/4yZWbBu/uNC\n0afvqv/tfcLVX6tZEmXkh6DfCtDwqX0vWrwAJuqtLUC8RvUDj7X4vi90/LhU2GUs\n+h+eZoQ3VwZ8jmfisQs7FUhbPOURZhRoS4UT8w7Le3pLodj5vAcaB6VvZP7SZ2Ls\niNob9J0godpjlkGGWGqjWl0AO1kVvaNJTXpNhwpCRZyad8wUgri5QtrHWzRo4FBb\nJzrbJqWaS1FaqMCuPwcpq0KLsn4v6i4sD6Vy3HOaF29+avWNawnMLB/92csl4blq\nJ20D2sKGUGcJpmLdiupnDdsHWU1jSpUvoUv+viE1RDqBFDQaNkUxdv5DhDOSRcwI\na8Upx9lG8ol0uuDE4jieie4wuNq41jVRWJ55aJ46zO9QPifq59SMcRj8uN8byRKz\nWdg/ngldiePCjg2RQztgb6Hsut7xeYYhuAYQ8m1+vLCnS8tRnCqhAqxdW51uSfIq\nxKukH+bioF/+baqBu1AlXmNVou1uiXJaDzZ6wQfBwsE7BAABCgBvBYJhaVoTCRD7\n/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9ucy5zZXF1b2lhLXBncC5vcmcQ\nWMonyHF4Gcry0TOPKj/RQyhVoSI+1C31rXHHBcxIyxYhBNGmbhojsYLJmA94jPv8\nyCoBXnMwAAB7RwwAo+/P0/foJZp0/4yZWbBu/uNC0afvqv/tfcLVX6tZEmXkh6Df\nCtDwqX0vWrwAJuqtLUC8RvUDj7X4vi90/LhU2GUs+h+eZoQ3VwZ8jmfisQs7FUhb\nPOURZhRoS4UT8w7Le3pLodj5vAcaB6VvZP7SZ2LsiNob9J0godpjlkGGWGqjWl0A\nO1kVvaNJTXpNhwpCRZyad8wUgri5QtrHWzRo4FBbJzrbJqWaS1FaqMCuPwcpq0KL\nsn4v6i4sD6Vy3HOaF29+avWNawnMLB/92csl4blqJ20D2sKGUGcJpmLdiupnDdsH\nWU1jSpUvoUv+viE1RDqBFDQaNkUxdv5DhDOSRcwIa8Upx9lG8ol0uuDE4jieie4w\nuNq41jVRWJ55aJ46zO9QPifq59SMcRj8uN8byRKzWdg/ngldiePCjg2RQztgb6Hs\nut7xeYYhuAYQ8m1+vLCnS8tRnCqhAqxdW51uSfIqxKukH+bioF/+baqBu1AlXmNV\nou1uiXJaDzZ6wQfB\n=Yc8d\n-----END PGP SIGNATURE-----\n";
        OpenPgpMetadata metadata = this.verifySignature(cert, SIG23SIG4);
        Assertions.assertTrue((boolean)metadata.isVerified());
    }

    private OpenPgpMetadata verifySignature(PGPPublicKeyRing cert, String BASE_CASE) throws PGPException, IOException {
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addVerificationCert(cert).addVerificationOfDetachedSignatures((InputStream)new ByteArrayInputStream(BASE_CASE.getBytes(StandardCharsets.UTF_8))));
        Streams.drain((InputStream)decryptionStream);
        decryptionStream.close();
        return decryptionStream.getResult();
    }

    static {
        try {
            cert = PGPainless.readKeyRing().publicKeyRing(CERT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

