/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.Passphrase;

public class Encrypt {
    @Test
    public void encryptAndSignMessage() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing keyAlice = PGPainless.generateKeyRing().modernKeyRing("alice@pgpainless.org", null);
        PGPPublicKeyRing certificateAlice = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)keyAlice);
        SecretKeyRingProtector protectorAlice = SecretKeyRingProtector.unprotectedKeys();
        PGPSecretKeyRing keyBob = PGPainless.generateKeyRing().modernKeyRing("bob@pgpainless.org", null);
        PGPPublicKeyRing certificateBob = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)keyBob);
        SecretKeyRingProtector protectorBob = SecretKeyRingProtector.unprotectedKeys();
        String message = "Hello, World!\n";
        ByteArrayOutputStream ciphertext = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertext).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(certificateBob).addRecipient(certificateAlice), (SigningOptions)new SigningOptions().addInlineSignature(protectorAlice, keyAlice, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setAsciiArmor(true));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptor);
        encryptor.close();
        String encryptedMessage = ciphertext.toString();
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(encryptedMessage.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addDecryptionKey(keyBob, protectorBob).addVerificationCert(certificateAlice));
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)plaintext);
        decryptor.close();
        OpenPgpMetadata metadata = decryptor.getResult();
        Assertions.assertTrue((boolean)metadata.isEncrypted());
        Assertions.assertTrue((boolean)metadata.containsVerifiedSignatureFrom(certificateAlice));
        Assertions.assertEquals((Object)message, (Object)plaintext.toString());
    }

    @Test
    public void encryptUsingPassphrase() throws PGPException, IOException {
        String message = "Hello, World!";
        ByteArrayOutputStream ciphertext = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)ciphertext).withOptions(ProducerOptions.encrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addPassphrase(Passphrase.fromPassword((String)"p4ssphr4s3"))).setAsciiArmor(true));
        Streams.pipeAll((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptor);
        encryptor.close();
        String asciiCiphertext = ciphertext.toString();
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(asciiCiphertext.getBytes(StandardCharsets.UTF_8))).withOptions(new ConsumerOptions().addDecryptionPassphrase(Passphrase.fromPassword((String)"p4ssphr4s3")));
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)plaintext);
        decryptor.close();
        Assertions.assertEquals((Object)message, (Object)plaintext.toString());
    }
}

