/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.key.info.KeyInfo;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.BCUtil;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.TestAllImplementations;

public class BrainpoolKeyGenerationTest {
    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void generateEcKeysTest() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        for (EllipticCurve curve : EllipticCurve.values()) {
            PGPSecretKeyRing secretKeys = this.generateKey(KeySpec.getBuilder((KeyType)KeyType.ECDSA((EllipticCurve)curve), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}).build(), KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)curve), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}).build(), "Elliptic Curve <elliptic@curve.key>");
            Assertions.assertEquals((Object)PublicKeyAlgorithm.ECDSA, (Object)PublicKeyAlgorithm.fromId((int)secretKeys.getPublicKey().getAlgorithm()));
            Iterator secretKeyIterator = secretKeys.iterator();
            PGPSecretKey primaryKey = (PGPSecretKey)secretKeyIterator.next();
            KeyInfo primaryInfo = new KeyInfo(primaryKey);
            Assertions.assertEquals((Object)curve.getName(), (Object)primaryInfo.getCurveName());
            Assertions.assertFalse((boolean)primaryInfo.isEncrypted());
            Assertions.assertTrue((boolean)primaryInfo.isDecrypted());
            Assertions.assertFalse((boolean)primaryInfo.hasDummyS2K());
            PGPSecretKey subKey = (PGPSecretKey)secretKeyIterator.next();
            KeyInfo subInfo = new KeyInfo(subKey);
            Assertions.assertEquals((Object)curve.getName(), (Object)subInfo.getCurveName());
        }
    }

    @TestTemplate
    @ExtendWith(value={TestAllImplementations.class})
    public void generateEdDSAKeyTest() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.ECDSA((EllipticCurve)EllipticCurve._BRAINPOOLP384R1), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]))).addUserId(UserId.nameAndEmail((String)"Alice", (String)"alice@pgpainless.org"))).setPassphrase(Passphrase.fromPassword((String)"passphrase")).build();
        for (PGPSecretKey key : secretKeys) {
            KeyInfo info = new KeyInfo(key);
            Assertions.assertTrue((boolean)info.isEncrypted());
            Assertions.assertFalse((boolean)info.isDecrypted());
            PGPPublicKey pubKey = key.getPublicKey();
            Assertions.assertFalse((boolean)new KeyInfo(pubKey).isEncrypted());
            Assertions.assertTrue((boolean)new KeyInfo(pubKey).isDecrypted());
            Assertions.assertFalse((boolean)new KeyInfo(pubKey).hasDummyS2K());
        }
        Iterator iterator = secretKeys.iterator();
        PGPSecretKey ecdsaPrim = (PGPSecretKey)iterator.next();
        KeyInfo ecdsaInfo = new KeyInfo(ecdsaPrim);
        Assertions.assertEquals((Object)EllipticCurve._BRAINPOOLP384R1.getName(), (Object)ecdsaInfo.getCurveName());
        Assertions.assertEquals((int)384, (int)BCUtil.getBitStrength((PGPPublicKey)ecdsaPrim.getPublicKey()));
        PGPSecretKey eddsaSub = (PGPSecretKey)iterator.next();
        KeyInfo eddsaInfo = new KeyInfo(eddsaSub);
        Assertions.assertEquals((Object)EdDSACurve._Ed25519.getName(), (Object)eddsaInfo.getCurveName());
        Assertions.assertEquals((int)256, (int)BCUtil.getBitStrength((PGPPublicKey)eddsaSub.getPublicKey()));
        PGPSecretKey xdhSub = (PGPSecretKey)iterator.next();
        KeyInfo xdhInfo = new KeyInfo(xdhSub);
        Assertions.assertEquals((Object)XDHSpec._X25519.getCurveName(), (Object)xdhInfo.getCurveName());
        Assertions.assertEquals((int)256, (int)BCUtil.getBitStrength((PGPPublicKey)xdhSub.getPublicKey()));
        PGPSecretKey rsaSub = (PGPSecretKey)iterator.next();
        KeyInfo rsaInfo = new KeyInfo(rsaSub);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((KeyInfo)rsaInfo).getCurveName(), (String)"RSA is not a curve-based encryption system");
        Assertions.assertEquals((int)3072, (int)BCUtil.getBitStrength((PGPPublicKey)rsaSub.getPublicKey()));
    }

    public PGPSecretKeyRing generateKey(KeySpec primaryKey, KeySpec subKey, String userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.buildKeyRing().setPrimaryKey(primaryKey).addSubkey(subKey).addUserId(userId).build();
        return secretKeys;
    }
}

