/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.IOException;
import java.util.List;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.encoders.Hex;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.util.KeyIdUtil;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.DateUtil;

public class SignatureStructureTest {
    private static PGPSignature signature;

    @BeforeAll
    public static void parseSignature() throws IOException, PGPException {
        signature = (PGPSignature)SignatureUtils.readSignatures((String)"-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCABlBYJgv4U3RxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZyPTSDcCaeqXuP6nWREE/C94XG6ABwpIlZHM08WewmWgFiEE0aZuGiOx\ngsmYD3iM+/zIKgFeczAACgkQ+/zIKgFeczBdoQv+MqOUYG+LA0Sa6P/827ILn9lW\n4IQJZVBo/ssvIU0Q8GjvCl4c/kRf+VKSprfkBz+q+vjHI1Ob0rW8amuTvvlSzBQX\n6Kb20ahvRYDo445Twuo+/rnp+j5PdRpYITY665AhdwfHSYoEEMhqrEDSQGT8O2xO\n1115FJEJaepomY4K9rv2pI8+pX9jOht7sCBK/qkTy/8RC22VyYWoPLSpxldzOBAK\n/AcuVCXFGfBt6ybRDXKJJduOVDQ5UFCoC71tq4ah7YmwIMD+/cXYPd+0Xg66U8Eq\n3F9MPYCzDYwnhEYZPuHODucHXZ0xpiFRlRkVMZT//+3b4NdOONRf/8sz9YUIMNxB\nU2qrEUnByfz3k1ZdkNwn40jYYWHp7hxVmaIDN3v+o5lZfzrKLTWU6wZThZL2FQlf\nSqGzjkxOW/c5OcO/EtCUNwIATpou32d1srfK0wGy2ar/o40yezukr5DLTo6B67Hq\nZ0D2bD+77247LmD4iuHMHxTI3yv2J+ecfM11Ejir\n=pQWH\n-----END PGP SIGNATURE-----\n").get(0);
    }

    @Test
    public void testGetSignatureVersion() {
        Assertions.assertEquals((int)4, (int)signature.getVersion());
    }

    @Test
    public void testGetSignatureType() {
        Assertions.assertEquals((Object)SignatureType.BINARY_DOCUMENT, (Object)SignatureType.valueOf((int)signature.getSignatureType()));
    }

    @Test
    public void testGetAlgorithm() {
        Assertions.assertEquals((Object)PublicKeyAlgorithm.RSA_GENERAL, (Object)PublicKeyAlgorithm.fromId((int)signature.getKeyAlgorithm()));
    }

    @Test
    public void testGetHashAlgorithm() {
        Assertions.assertEquals((Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.fromId((int)signature.getHashAlgorithm()));
    }

    @Test
    public void testGetSignatureCreationTime() {
        Assertions.assertEquals((Object)DateUtil.parseUTCDate((String)"2021-06-08 14:56:55 UTC"), (Object)signature.getCreationTime());
    }

    @Test
    public void testGetIssuerFingerprint() {
        Assertions.assertEquals((Object)new OpenPgpV4Fingerprint("D1A66E1A23B182C9980F788CFBFCC82A015E7330"), (Object)SignatureSubpacketsUtil.getIssuerFingerprintAsOpenPgpFingerprint((PGPSignature)signature));
    }

    @Test
    public void testGetIssuer() {
        Assertions.assertEquals((long)KeyIdUtil.fromLongKeyId((String)"FBFCC82A015E7330"), (long)SignatureSubpacketsUtil.getIssuerKeyId((PGPSignature)signature).getKeyID());
    }

    @Test
    public void testGetNotations() {
        List notations = SignatureSubpacketsUtil.getHashedNotationData((PGPSignature)signature, (String)"salt@notations.sequoia-pgp.org");
        Assertions.assertEquals((int)1, (int)notations.size());
        NotationData notation = (NotationData)notations.get(0);
        Assertions.assertEquals((Object)"23d348370269ea97b8fea7591104fc2f785c6e80070a489591ccd3c59ec265a0", (Object)Hex.toHexString((byte[])notation.getNotationValueBytes()));
    }

    @Test
    public void testGetSignatureDigestPrefix() {
        Assertions.assertEquals((Object)"5da1", (Object)SignatureUtils.getSignatureDigestPrefix((PGPSignature)signature));
    }
}

