/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.subpackets;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;
import org.pgpainless.util.DateUtil;
import org.pgpainless.util.Passphrase;

public class SignatureSubpacketsTest {
    private static PGPPublicKeyRing keys;
    private static PGPPublicKey key;
    private SignatureSubpackets wrapper;

    @BeforeAll
    public static void setup() throws IOException {
        keys = TestKeys.getEmilPublicKeyRing();
        key = keys.getPublicKey();
    }

    @BeforeEach
    public void createWrapper() {
        this.wrapper = SignatureSubpackets.createHashedSubpackets((PGPPublicKey)key);
    }

    @Test
    public void initialStateTest() {
        this.wrapper = new SignatureSubpackets();
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertNull((Object)vector.getSignatureCreationTime());
    }

    @Test
    public void initialStateFromKeyTest() throws PGPException {
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((long)key.getKeyID(), (long)vector.getIssuerKeyID());
        Assertions.assertEquals((int)key.getVersion(), (int)vector.getIssuerFingerprint().getKeyVersion());
        Assertions.assertArrayEquals((byte[])key.getFingerprint(), (byte[])vector.getIssuerFingerprint().getFingerprint());
        Assertions.assertNull((Object)vector.getSignatureCreationTime());
        Assertions.assertEquals((int)0, (int)vector.getKeyFlags());
        Assertions.assertEquals((long)0L, (long)vector.getSignatureExpirationTime());
        Assertions.assertNull((Object)vector.getSignerUserID());
        Assertions.assertFalse((boolean)vector.isPrimaryUserID());
        Assertions.assertEquals((long)0L, (long)vector.getKeyExpirationTime());
        Assertions.assertNull((Object)vector.getPreferredCompressionAlgorithms());
        Assertions.assertNull((Object)vector.getPreferredSymmetricAlgorithms());
        Assertions.assertNull((Object)vector.getPreferredHashAlgorithms());
        Assertions.assertEquals((int)0, (int)vector.getNotationDataOccurrences().length);
        Assertions.assertNull((Object)vector.getIntendedRecipientFingerprint());
        Assertions.assertNull((Object)vector.getSubpacket(4));
        Assertions.assertNull((Object)vector.getSubpacket(12));
        Assertions.assertNull((Object)vector.getSubpacket(29));
        Assertions.assertNull((Object)vector.getSignatureTarget());
        Assertions.assertNull((Object)vector.getFeatures());
        Assertions.assertNull((Object)vector.getSubpacket(5));
        Assertions.assertTrue((boolean)vector.getEmbeddedSignatures().isEmpty());
    }

    @Test
    public void testNullKeyId() {
        this.wrapper.setIssuerKeyId(null);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((long)0L, (long)vector.getIssuerKeyID());
    }

    @Test
    public void testNullFingerprint() {
        this.wrapper.setIssuerFingerprint((IssuerFingerprint)null);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertNull((Object)vector.getIssuerFingerprint());
    }

    @Test
    public void testAddNotationData() {
        this.wrapper.addNotationData(true, "critical@notation.data", "isCritical");
        this.wrapper.addNotationData(false, "noncrit@notation.data", "notCritical");
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        NotationData[] notationData = vector.getNotationDataOccurrences();
        Assertions.assertEquals((int)2, (int)notationData.length);
        NotationData first = notationData[0];
        Assertions.assertTrue((boolean)first.isCritical());
        Assertions.assertTrue((boolean)first.isHumanReadable());
        Assertions.assertEquals((Object)"critical@notation.data", (Object)first.getNotationName());
        Assertions.assertEquals((Object)"isCritical", (Object)first.getNotationValue());
        NotationData second = notationData[1];
        Assertions.assertFalse((boolean)second.isCritical());
        Assertions.assertTrue((boolean)second.isHumanReadable());
        Assertions.assertEquals((Object)"noncrit@notation.data", (Object)second.getNotationName());
        Assertions.assertEquals((Object)"notCritical", (Object)second.getNotationValue());
        this.wrapper.clearNotationData();
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)0, (int)vector.getNotationDataOccurrences().length);
    }

    @Test
    public void testIntendedRecipientFingerprints() {
        this.wrapper.addIntendedRecipientFingerprint(key);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)1, (int)vector.getSubpackets(35).length);
        Assertions.assertArrayEquals((byte[])key.getFingerprint(), (byte[])vector.getIntendedRecipientFingerprint().getFingerprint());
        Assertions.assertEquals((int)key.getVersion(), (int)vector.getIntendedRecipientFingerprint().getKeyVersion());
        this.wrapper.clearIntendedRecipientFingerprints();
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)0, (int)vector.getSubpackets(35).length);
    }

    @Test
    public void testAddRevocationKeys() {
        Iterator keyIterator = keys.getPublicKeys();
        PGPPublicKey first = (PGPPublicKey)keyIterator.next();
        this.wrapper.addRevocationKey(first);
        Assertions.assertTrue((boolean)keyIterator.hasNext());
        PGPPublicKey second = (PGPPublicKey)keyIterator.next();
        this.wrapper.addRevocationKey(false, true, second);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        SignatureSubpacket[] revKeys = vector.getSubpackets(12);
        Assertions.assertEquals((int)2, (int)revKeys.length);
        RevocationKey r1 = (RevocationKey)revKeys[0];
        RevocationKey r2 = (RevocationKey)revKeys[1];
        Assertions.assertTrue((boolean)r1.isCritical());
        Assertions.assertArrayEquals((byte[])first.getFingerprint(), (byte[])r1.getFingerprint());
        Assertions.assertEquals((int)first.getAlgorithm(), (int)r1.getAlgorithm());
        Assertions.assertEquals((byte)-128, (byte)r1.getSignatureClass());
        Assertions.assertFalse((boolean)r2.isCritical());
        Assertions.assertArrayEquals((byte[])second.getFingerprint(), (byte[])r2.getFingerprint());
        Assertions.assertEquals((int)second.getAlgorithm(), (int)r2.getAlgorithm());
        Assertions.assertEquals((byte)-64, (byte)r2.getSignatureClass());
        this.wrapper.clearRevocationKeys();
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)0, (int)vector.getSubpackets(12).length);
    }

    @Test
    public void testSetKeyFlags() {
        this.wrapper.setKeyFlags(new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA});
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}), (int)vector.getKeyFlags());
        Assertions.assertTrue((boolean)vector.getSubpacket(27).isCritical());
    }

    @Test
    public void testSignatureExpirationTime() {
        Date now = new Date();
        long secondsInAWeek = 604800L;
        Date inAWeek = new Date(now.getTime() + 1000L * secondsInAWeek);
        this.wrapper.setSignatureExpirationTime(now, inAWeek);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((long)secondsInAWeek, (long)vector.getSignatureExpirationTime());
    }

    @Test
    public void testSignatureExpirationTimeCannotBeNegative() {
        Date now = new Date();
        long secondsInAWeek = 604800L;
        Date oneWeekEarlier = new Date(now.getTime() - 1000L * secondsInAWeek);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.wrapper.setSignatureExpirationTime(now, oneWeekEarlier));
    }

    @Test
    public void testSignerUserId() {
        String userId = "Alice <alice@pgpainless.org>";
        this.wrapper.setSignerUserId(userId);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((Object)userId, (Object)vector.getSignerUserID());
    }

    @Test
    public void testSetPrimaryUserId() {
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertFalse((boolean)vector.isPrimaryUserID());
        this.wrapper.setPrimaryUserId();
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertTrue((boolean)vector.isPrimaryUserID());
    }

    @Test
    public void testSetKeyExpiration() {
        Date now = new Date();
        long secondsSinceKeyCreation = (now.getTime() - key.getCreationTime().getTime()) / 1000L;
        this.wrapper.setKeyExpirationTime(key, now);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((long)secondsSinceKeyCreation, (long)vector.getKeyExpirationTime());
    }

    @Test
    public void testSetKeyExpirationCannotBeNegative() {
        Date beforeKeyCreation = new Date(key.getCreationTime().getTime() - 10000L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.wrapper.setKeyExpirationTime(key, beforeKeyCreation));
    }

    @Test
    public void testSetPreferredCompressionAlgorithms() {
        this.wrapper.setPreferredCompressionAlgorithms(new CompressionAlgorithm[]{CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZIP, CompressionAlgorithm.BZIP2});
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        int[] ids = vector.getPreferredCompressionAlgorithms();
        Assertions.assertEquals((int)2, (int)ids.length);
        Assertions.assertEquals((int)CompressionAlgorithm.BZIP2.getAlgorithmId(), (int)ids[0]);
        Assertions.assertEquals((int)CompressionAlgorithm.ZIP.getAlgorithmId(), (int)ids[1]);
        this.wrapper.setPreferredCompressionAlgorithms(new CompressionAlgorithm[0]);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)0, (int)vector.getPreferredCompressionAlgorithms().length);
        this.wrapper.setPreferredCompressionAlgorithms((PreferredAlgorithms)null);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertNull((Object)vector.getPreferredCompressionAlgorithms());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.wrapper.setPreferredCompressionAlgorithms(new PreferredAlgorithms(11, true, new int[0])));
    }

    @Test
    public void testSetPreferredSymmetricKeyAlgorithms() {
        this.wrapper.setPreferredSymmetricKeyAlgorithms(new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.AES_128});
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        int[] ids = vector.getPreferredSymmetricAlgorithms();
        Assertions.assertEquals((int)2, (int)ids.length);
        Assertions.assertEquals((int)SymmetricKeyAlgorithm.AES_192.getAlgorithmId(), (int)ids[0]);
        Assertions.assertEquals((int)SymmetricKeyAlgorithm.AES_128.getAlgorithmId(), (int)ids[1]);
        this.wrapper.setPreferredSymmetricKeyAlgorithms(new SymmetricKeyAlgorithm[0]);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)0, (int)vector.getPreferredSymmetricAlgorithms().length);
        this.wrapper.setPreferredSymmetricKeyAlgorithms((PreferredAlgorithms)null);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertNull((Object)vector.getPreferredCompressionAlgorithms());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.wrapper.setPreferredSymmetricKeyAlgorithms(new PreferredAlgorithms(21, true, new int[0])));
    }

    @Test
    public void testSetPreferredHashAlgorithms() {
        this.wrapper.setPreferredHashAlgorithms(new HashAlgorithm[]{HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA512});
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        int[] ids = vector.getPreferredHashAlgorithms();
        Assertions.assertEquals((int)2, (int)ids.length);
        Assertions.assertEquals((int)HashAlgorithm.SHA512.getAlgorithmId(), (int)ids[0]);
        Assertions.assertEquals((int)HashAlgorithm.SHA384.getAlgorithmId(), (int)ids[1]);
        this.wrapper.setPreferredHashAlgorithms(new HashAlgorithm[0]);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)0, (int)vector.getPreferredHashAlgorithms().length);
        this.wrapper.setPreferredHashAlgorithms((PreferredAlgorithms)null);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertNull((Object)vector.getPreferredHashAlgorithms());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.wrapper.setPreferredHashAlgorithms(new PreferredAlgorithms(22, true, new int[0])));
    }

    @Test
    public void testSetExportable() {
        this.wrapper.setExportable(true, false);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Exportable exportable = (Exportable)vector.getSubpacket(4);
        Assertions.assertTrue((boolean)exportable.isCritical());
        Assertions.assertFalse((boolean)exportable.isExportable());
        this.wrapper.setExportable(false, true);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        exportable = (Exportable)vector.getSubpacket(4);
        Assertions.assertFalse((boolean)exportable.isCritical());
        Assertions.assertTrue((boolean)exportable.isExportable());
    }

    @Test
    public void testSetRevocable() {
        this.wrapper.setRevocable(true, true);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Revocable revocable = (Revocable)vector.getSubpacket(7);
        Assertions.assertTrue((boolean)revocable.isCritical());
        Assertions.assertTrue((boolean)revocable.isRevocable());
        this.wrapper.setRevocable(false, false);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        revocable = (Revocable)vector.getSubpacket(7);
        Assertions.assertFalse((boolean)revocable.isCritical());
        Assertions.assertFalse((boolean)revocable.isRevocable());
    }

    @Test
    public void testSetRevocationReason() {
        this.wrapper.setRevocationReason(RevocationAttributes.createKeyRevocation().withReason(RevocationAttributes.Reason.KEY_RETIRED).withDescription("The key is too weak."));
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)1, (int)vector.getSubpackets(29).length);
        RevocationReason reason = (RevocationReason)vector.getSubpacket(29);
        Assertions.assertEquals((byte)RevocationAttributes.Reason.KEY_RETIRED.code(), (byte)reason.getRevocationReason());
        Assertions.assertEquals((Object)"The key is too weak.", (Object)reason.getRevocationDescription());
    }

    @Test
    public void testSetSignatureTarget() {
        byte[] hash = new byte[20];
        new Random().nextBytes(hash);
        this.wrapper.setSignatureTarget(PublicKeyAlgorithm.fromId((int)key.getAlgorithm()), HashAlgorithm.SHA512, hash);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        SignatureTarget target = vector.getSignatureTarget();
        Assertions.assertNotNull((Object)target);
        Assertions.assertEquals((int)key.getAlgorithm(), (int)target.getPublicKeyAlgorithm());
        Assertions.assertEquals((int)HashAlgorithm.SHA512.getAlgorithmId(), (int)target.getHashAlgorithm());
        Assertions.assertArrayEquals((byte[])hash, (byte[])target.getHashData());
    }

    @Test
    public void testSetFeatures() {
        this.wrapper.setFeatures(new Feature[]{Feature.MODIFICATION_DETECTION, Feature.AEAD_ENCRYPTED_DATA});
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Features features = vector.getFeatures();
        Assertions.assertTrue((boolean)features.supportsModificationDetection());
        Assertions.assertTrue((boolean)features.supportsFeature((byte)2));
        Assertions.assertFalse((boolean)features.supportsFeature((byte)4));
    }

    @Test
    public void testSetTrust() {
        this.wrapper.setTrust(10, 5);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        TrustSignature trustSignature = (TrustSignature)vector.getSubpacket(5);
        Assertions.assertNotNull((Object)trustSignature);
        Assertions.assertEquals((int)10, (int)trustSignature.getDepth());
        Assertions.assertEquals((int)5, (int)trustSignature.getTrustAmount());
    }

    @Test
    public void testAddEmbeddedSignature() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        Iterator secretKeyIterator = secretKeys.iterator();
        PGPSecretKey primaryKey = (PGPSecretKey)secretKeyIterator.next();
        PGPSignatureGenerator generator = new PGPSignatureGenerator(ImplementationFactory.getInstance().getPGPContentSignerBuilder(primaryKey.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId()));
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)primaryKey, (Passphrase)null);
        generator.init(SignatureType.DIRECT_KEY.getCode(), privateKey);
        PGPSignature sig1 = generator.generateCertification(primaryKey.getPublicKey());
        generator.init(SignatureType.DIRECT_KEY.getCode(), privateKey);
        PGPSignature sig2 = generator.generateCertification(((PGPSecretKey)secretKeyIterator.next()).getPublicKey());
        this.wrapper.addEmbeddedSignature(sig1);
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)1, (int)vector.getEmbeddedSignatures().size());
        Assertions.assertArrayEquals((byte[])sig1.getSignature(), (byte[])vector.getEmbeddedSignatures().get(0).getSignature());
        this.wrapper.addEmbeddedSignature(sig2);
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)2, (int)vector.getEmbeddedSignatures().size());
        Assertions.assertArrayEquals((byte[])sig2.getSignature(), (byte[])vector.getEmbeddedSignatures().get(1).getSignature());
        this.wrapper.clearEmbeddedSignatures();
        vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)this.wrapper);
        Assertions.assertEquals((int)0, (int)vector.getEmbeddedSignatures().size());
    }

    @Test
    public void testExtractSubpacketsFromVector() throws IOException {
        Date sigCreationDate = DateUtil.parseUTCDate((String)"2021-11-06 12:39:06 UTC");
        PGPPublicKeyRing publicKeys = TestKeys.getEmilPublicKeyRing();
        OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of((PGPKeyRing)publicKeys);
        long keyId = fingerprint.getKeyId();
        PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
        subpackets.setSignatureCreationTime(true, sigCreationDate);
        subpackets.setIssuerKeyID(true, keyId);
        subpackets.setIssuerFingerprint(true, publicKeys.getPublicKey());
        subpackets.setSignatureExpirationTime(true, 256000L);
        subpackets.setExportable(true, true);
        subpackets.setTrust(true, 5, 15);
        subpackets.setRevocable(true, true);
        subpackets.setKeyExpirationTime(true, 512000L);
        subpackets.setPreferredSymmetricAlgorithms(true, new int[]{SymmetricKeyAlgorithm.AES_192.getAlgorithmId(), SymmetricKeyAlgorithm.AES_128.getAlgorithmId()});
        subpackets.addRevocationKey(true, publicKeys.getPublicKey().getAlgorithm(), publicKeys.getPublicKey().getFingerprint());
        subpackets.addNotationData(false, true, "test@test.test", "test");
        subpackets.addNotationData(false, true, "check@check.check", "check");
        subpackets.setPreferredHashAlgorithms(true, new int[]{HashAlgorithm.SHA512.getAlgorithmId(), HashAlgorithm.SHA384.getAlgorithmId()});
        subpackets.setPreferredCompressionAlgorithms(true, new int[]{CompressionAlgorithm.ZIP.getAlgorithmId(), CompressionAlgorithm.BZIP2.getAlgorithmId()});
        subpackets.setPrimaryUserID(true, true);
        subpackets.setKeyFlags(true, KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}));
        subpackets.addSignerUserID(false, "alice@test.test");
        subpackets.setRevocationReason(true, RevocationAttributes.Reason.KEY_RETIRED.code(), "Key was retired.");
        subpackets.setFeature(true, Feature.toBitmask((Feature[])new Feature[]{Feature.MODIFICATION_DETECTION, Feature.AEAD_ENCRYPTED_DATA}));
        byte[] hash = new byte[128];
        new Random().nextBytes(hash);
        subpackets.setSignatureTarget(false, publicKeys.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId(), hash);
        subpackets.addIntendedRecipientFingerprint(true, publicKeys.getPublicKey());
        PreferredAlgorithms aead = new PreferredAlgorithms(34, false, new int[]{2});
        subpackets.addCustomSubpacket((SignatureSubpacket)aead);
        SignatureSubpackets wrapper = SignatureSubpackets.createSubpacketsFrom((PGPSignatureSubpacketVector)subpackets.generate());
        PGPSignatureSubpacketVector vector = SignatureSubpacketsHelper.toVector((SignatureSubpackets)wrapper);
        Assertions.assertEquals((long)0L, (long)vector.getIssuerKeyID());
        Assertions.assertNull((Object)vector.getIssuerFingerprint());
        Assertions.assertNull((Object)vector.getSignatureCreationTime());
        Assertions.assertEquals((long)256000L, (long)vector.getSignatureExpirationTime());
        Assertions.assertTrue((boolean)((Exportable)vector.getSubpacket(4)).isExportable());
        TrustSignature trust = (TrustSignature)vector.getSubpacket(5);
        Assertions.assertEquals((int)5, (int)trust.getDepth());
        Assertions.assertEquals((int)15, (int)trust.getTrustAmount());
        Assertions.assertTrue((boolean)((Revocable)vector.getSubpacket(7)).isRevocable());
        Assertions.assertEquals((long)512000L, (long)vector.getKeyExpirationTime());
        Assertions.assertArrayEquals((int[])new int[]{SymmetricKeyAlgorithm.AES_192.getAlgorithmId(), SymmetricKeyAlgorithm.AES_128.getAlgorithmId()}, (int[])vector.getPreferredSymmetricAlgorithms());
        Assertions.assertArrayEquals((byte[])publicKeys.getPublicKey().getFingerprint(), (byte[])((RevocationKey)vector.getSubpacket(12)).getFingerprint());
        Assertions.assertEquals((int)2, (int)vector.getNotationDataOccurrences().length);
        Assertions.assertEquals((Object)"test@test.test", (Object)vector.getNotationDataOccurrences()[0].getNotationName());
        Assertions.assertEquals((Object)"test", (Object)vector.getNotationDataOccurrences()[0].getNotationValue());
        Assertions.assertEquals((Object)"check@check.check", (Object)vector.getNotationDataOccurrences()[1].getNotationName());
        Assertions.assertEquals((Object)"check", (Object)vector.getNotationDataOccurrences()[1].getNotationValue());
        Assertions.assertArrayEquals((int[])new int[]{HashAlgorithm.SHA512.getAlgorithmId(), HashAlgorithm.SHA384.getAlgorithmId()}, (int[])vector.getPreferredHashAlgorithms());
        Assertions.assertArrayEquals((int[])new int[]{CompressionAlgorithm.ZIP.getAlgorithmId(), CompressionAlgorithm.BZIP2.getAlgorithmId()}, (int[])vector.getPreferredCompressionAlgorithms());
        Assertions.assertTrue((boolean)vector.isPrimaryUserID());
        Assertions.assertEquals((int)KeyFlag.toBitmask((KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}), (int)vector.getKeyFlags());
        Assertions.assertEquals((Object)"alice@test.test", (Object)vector.getSignerUserID());
        RevocationReason reason = (RevocationReason)vector.getSubpacket(29);
        Assertions.assertEquals((byte)RevocationAttributes.Reason.KEY_RETIRED.code(), (byte)reason.getRevocationReason());
        Assertions.assertEquals((Object)"Key was retired.", (Object)reason.getRevocationDescription());
        Assertions.assertTrue((boolean)vector.getFeatures().supportsFeature((byte)1));
        Assertions.assertTrue((boolean)vector.getFeatures().supportsFeature((byte)2));
        SignatureTarget signatureTarget = vector.getSignatureTarget();
        Assertions.assertEquals((int)publicKeys.getPublicKey().getAlgorithm(), (int)signatureTarget.getPublicKeyAlgorithm());
        Assertions.assertEquals((int)HashAlgorithm.SHA512.getAlgorithmId(), (int)signatureTarget.getHashAlgorithm());
        Assertions.assertArrayEquals((byte[])hash, (byte[])signatureTarget.getHashData());
        Assertions.assertArrayEquals((byte[])publicKeys.getPublicKey().getFingerprint(), (byte[])vector.getIntendedRecipientFingerprint().getFingerprint());
        PreferredAlgorithms aeadAlgorithms = (PreferredAlgorithms)vector.getSubpacket(34);
        Assertions.assertArrayEquals((int[])aead.getPreferences(), (int[])aeadAlgorithms.getPreferences());
    }
}

