/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.StreamGeneratorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptionStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionStream.class);
    private final ProducerOptions options;
    private final EncryptionResult.Builder resultBuilder = EncryptionResult.builder();
    private boolean closed = false;
    private static final int BUFFER_SIZE = 512;
    OutputStream outermostStream;
    private ArmoredOutputStream armorOutputStream = null;
    private OutputStream publicKeyEncryptedStream = null;
    private PGPCompressedDataGenerator compressedDataGenerator;
    private BCPGOutputStream basicCompressionStream;
    private StreamGeneratorWrapper streamGeneratorWrapper;
    private OutputStream literalDataStream;

    EncryptionStream(@Nonnull OutputStream targetOutputStream, @Nonnull ProducerOptions options) throws IOException, PGPException {
        this.options = options;
        this.outermostStream = targetOutputStream;
        this.prepareArmor();
        this.prepareEncryption();
        this.prepareCompression();
        this.prepareOnePassSignatures();
        this.prepareLiteralDataProcessing();
    }

    private void prepareArmor() {
        if (!this.options.isAsciiArmor()) {
            LOGGER.debug("Output will be unarmored");
            return;
        }
        LOGGER.debug("Wrap encryption output in ASCII armor");
        this.armorOutputStream = ArmoredOutputStreamFactory.get(this.outermostStream);
        this.outermostStream = this.armorOutputStream;
    }

    private void prepareEncryption() throws IOException, PGPException {
        EncryptionOptions encryptionOptions = this.options.getEncryptionOptions();
        if (encryptionOptions == null || encryptionOptions.getEncryptionMethods().isEmpty()) {
            this.resultBuilder.setEncryptionAlgorithm(SymmetricKeyAlgorithm.NULL);
            return;
        }
        SymmetricKeyAlgorithm encryptionAlgorithm = EncryptionBuilder.negotiateSymmetricEncryptionAlgorithm(encryptionOptions);
        this.resultBuilder.setEncryptionAlgorithm(encryptionAlgorithm);
        LOGGER.debug("Encrypt message using {}", (Object)encryptionAlgorithm);
        PGPDataEncryptorBuilder dataEncryptorBuilder = ImplementationFactory.getInstance().getPGPDataEncryptorBuilder(encryptionAlgorithm);
        dataEncryptorBuilder.setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(dataEncryptorBuilder);
        for (PGPKeyEncryptionMethodGenerator encryptionMethod : encryptionOptions.getEncryptionMethods()) {
            encryptedDataGenerator.addMethod(encryptionMethod);
        }
        for (SubkeyIdentifier recipientSubkeyIdentifier : encryptionOptions.getEncryptionKeyIdentifiers()) {
            this.resultBuilder.addRecipient(recipientSubkeyIdentifier);
        }
        this.outermostStream = this.publicKeyEncryptedStream = encryptedDataGenerator.open(this.outermostStream, new byte[512]);
    }

    private void prepareCompression() throws IOException {
        CompressionAlgorithm compressionAlgorithm = EncryptionBuilder.negotiateCompressionAlgorithm(this.options);
        this.resultBuilder.setCompressionAlgorithm(compressionAlgorithm);
        this.compressedDataGenerator = new PGPCompressedDataGenerator(compressionAlgorithm.getAlgorithmId());
        if (compressionAlgorithm == CompressionAlgorithm.UNCOMPRESSED) {
            return;
        }
        LOGGER.debug("Compress using {}", (Object)compressionAlgorithm);
        this.basicCompressionStream = new BCPGOutputStream(this.compressedDataGenerator.open(this.outermostStream));
        this.outermostStream = this.basicCompressionStream;
    }

    private void prepareOnePassSignatures() throws IOException, PGPException {
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        int sigIndex = 0;
        for (SubkeyIdentifier identifier : signingOptions.getSigningMethods().keySet()) {
            ++sigIndex;
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(identifier);
            if (signingMethod.isDetached()) continue;
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            boolean nested = sigIndex != signingOptions.getSigningMethods().size();
            signatureGenerator.generateOnePassVersion(nested).encode(this.outermostStream);
        }
    }

    private void prepareLiteralDataProcessing() throws IOException {
        if (this.options.isCleartextSigned()) {
            SigningOptions.SigningMethod firstMethod = this.options.getSigningOptions().getSigningMethods().values().iterator().next();
            this.armorOutputStream.beginClearText(firstMethod.getHashAlgorithm().getAlgorithmId());
            return;
        }
        this.streamGeneratorWrapper = StreamGeneratorWrapper.forStreamEncoding(this.options.getEncoding());
        this.outermostStream = this.literalDataStream = this.streamGeneratorWrapper.open(this.outermostStream, this.options.getFileName(), this.options.getModificationDate(), new byte[512]);
        this.resultBuilder.setFileName(this.options.getFileName()).setModificationDate(this.options.getModificationDate()).setFileEncoding(this.options.getEncoding());
    }

    @Override
    public void write(int data) throws IOException {
        this.outermostStream.write(data);
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier signingKey : signingOptions.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            byte asByte = (byte)(data & 0xFF);
            signatureGenerator.update(asByte);
        }
    }

    @Override
    public void write(@Nonnull byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(@Nonnull byte[] buffer, int off, int len) throws IOException {
        this.outermostStream.write(buffer, 0, len);
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        for (SubkeyIdentifier signingKey : signingOptions.getSigningMethods().keySet()) {
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            signatureGenerator.update(buffer, 0, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outermostStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.literalDataStream != null) {
            this.literalDataStream.flush();
            this.literalDataStream.close();
        }
        if (this.streamGeneratorWrapper != null) {
            this.streamGeneratorWrapper.close();
        }
        if (this.options.isCleartextSigned()) {
            this.armorOutputStream.write(13);
            this.armorOutputStream.write(10);
            this.armorOutputStream.endClearText();
        }
        try {
            this.writeSignatures();
        }
        catch (PGPException e) {
            throw new IOException("Exception while writing signatures.", e);
        }
        this.compressedDataGenerator.close();
        if (this.publicKeyEncryptedStream != null) {
            this.publicKeyEncryptedStream.flush();
            this.publicKeyEncryptedStream.close();
        }
        if (this.armorOutputStream != null) {
            this.armorOutputStream.flush();
            this.armorOutputStream.close();
        }
        this.closed = true;
    }

    private void writeSignatures() throws PGPException, IOException {
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions == null || signingOptions.getSigningMethods().isEmpty()) {
            return;
        }
        ArrayList<SubkeyIdentifier> signingKeys = new ArrayList<SubkeyIdentifier>();
        for (SubkeyIdentifier signingKey : signingOptions.getSigningMethods().keySet()) {
            signingKeys.add(signingKey);
        }
        for (int i = signingKeys.size() - 1; i >= 0; --i) {
            SubkeyIdentifier signingKey;
            signingKey = (SubkeyIdentifier)signingKeys.get(i);
            SigningOptions.SigningMethod signingMethod = signingOptions.getSigningMethods().get(signingKey);
            PGPSignatureGenerator signatureGenerator = signingMethod.getSignatureGenerator();
            PGPSignature signature = signatureGenerator.generate();
            if (signingMethod.isDetached()) {
                this.resultBuilder.addDetachedSignature(signingKey, signature);
            }
            if (signingMethod.isDetached() && !this.options.isCleartextSigned()) continue;
            signature.encode(this.outermostStream);
        }
    }

    public EncryptionResult getResult() {
        if (!this.closed) {
            throw new IllegalStateException("EncryptionStream must be closed before accessing the Result.");
        }
        return this.resultBuilder.build();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

