/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification.secretkeyring;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditorInterface;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.fixes.S2KUsageFix;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.builder.DirectKeySignatureBuilder;
import org.pgpainless.signature.builder.RevocationSignatureBuilder;
import org.pgpainless.signature.builder.SelfSignatureBuilder;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.BCUtil;
import org.pgpainless.util.CollectionUtils;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.selection.userid.SelectUserId;

public class SecretKeyRingEditor
implements SecretKeyRingEditorInterface {
    private PGPSecretKeyRing secretKeyRing;

    public SecretKeyRingEditor(PGPSecretKeyRing secretKeyRing) {
        if (secretKeyRing == null) {
            throw new NullPointerException("SecretKeyRing MUST NOT be null.");
        }
        this.secretKeyRing = secretKeyRing;
    }

    @Override
    public SecretKeyRingEditorInterface addUserId(@Nonnull CharSequence userId, @Nonnull SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        return this.addUserId(userId, null, secretKeyRingProtector);
    }

    @Override
    public SecretKeyRingEditorInterface addUserId(@Nonnull CharSequence userId, @Nullable SelfSignatureSubpackets.Callback signatureSubpacketCallback, @Nonnull SecretKeyRingProtector protector) throws PGPException {
        Set<CompressionAlgorithm> compressionAlgorithmPreferences;
        Set<SymmetricKeyAlgorithm> symmetricKeyAlgorithmPreferences;
        Set<HashAlgorithm> hashAlgorithmPreferences;
        String sanitizeUserId = this.sanitizeUserId(userId);
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing);
        if (info.isHardRevoked(userId.toString())) {
            throw new IllegalArgumentException("User-ID " + userId + " is hard revoked and cannot be re-certified.");
        }
        List<KeyFlag> keyFlags = info.getKeyFlagsOf(info.getKeyId());
        try {
            hashAlgorithmPreferences = info.getPreferredHashAlgorithms();
            symmetricKeyAlgorithmPreferences = info.getPreferredSymmetricKeyAlgorithms();
            compressionAlgorithmPreferences = info.getPreferredCompressionAlgorithms();
        }
        catch (IllegalStateException e) {
            AlgorithmSuite algorithmSuite = AlgorithmSuite.getDefaultAlgorithmSuite();
            hashAlgorithmPreferences = algorithmSuite.getHashAlgorithms();
            symmetricKeyAlgorithmPreferences = algorithmSuite.getSymmetricKeyAlgorithms();
            compressionAlgorithmPreferences = algorithmSuite.getCompressionAlgorithms();
        }
        SelfSignatureBuilder builder = new SelfSignatureBuilder(primaryKey, protector);
        builder.setSignatureType(SignatureType.POSITIVE_CERTIFICATION);
        builder.getHashedSubpackets().setKeyFlags(keyFlags);
        builder.getHashedSubpackets().setPreferredHashAlgorithms(hashAlgorithmPreferences);
        builder.getHashedSubpackets().setPreferredSymmetricKeyAlgorithms(symmetricKeyAlgorithmPreferences);
        builder.getHashedSubpackets().setPreferredCompressionAlgorithms(compressionAlgorithmPreferences);
        builder.getHashedSubpackets().setFeatures(Feature.MODIFICATION_DETECTION);
        builder.applyCallback(signatureSubpacketCallback);
        PGPSignature signature = builder.build(primaryKey.getPublicKey(), sanitizeUserId);
        this.secretKeyRing = KeyRingUtils.injectCertification(this.secretKeyRing, sanitizeUserId, signature);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface addPrimaryUserId(@Nonnull CharSequence userId, @Nonnull SecretKeyRingProtector protector) throws PGPException {
        final PGPPublicKey primaryKey = this.secretKeyRing.getSecretKey().getPublicKey();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing);
        String primaryUserId = info.getPrimaryUserId();
        PGPSignature signature = primaryUserId == null ? info.getLatestDirectKeySelfSignature() : info.getLatestUserIdCertification(primaryUserId);
        final Date previousKeyExpiration = signature == null ? null : SignatureSubpacketsUtil.getKeyExpirationTimeAsDate(signature, primaryKey);
        this.addUserId(userId, new SelfSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setPrimaryUserId();
                if (previousKeyExpiration != null) {
                    hashedSubpackets.setKeyExpirationTime(primaryKey, previousKeyExpiration);
                } else {
                    hashedSubpackets.setKeyExpirationTime(null);
                }
            }
        }, protector);
        info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing);
        for (String otherUserId : info.getBoundButPossiblyExpiredUserIds()) {
            if (userId.toString().equals(otherUserId) || !info.getLatestUserIdCertification(otherUserId).getHashedSubPackets().isPrimaryUserID()) continue;
            this.addUserId(otherUserId, new SelfSignatureSubpackets.Callback(){

                @Override
                public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                    hashedSubpackets.setPrimaryUserId(null);
                    hashedSubpackets.setKeyExpirationTime(null);
                }
            }, protector);
        }
        return this;
    }

    private String sanitizeUserId(@Nonnull CharSequence userId) {
        return userId.toString().trim();
    }

    @Override
    public SecretKeyRingEditorInterface addSubKey(final @Nonnull KeySpec keySpec, @Nonnull Passphrase subKeyPassphrase, @Nonnull SecretKeyRingProtector secretKeyRingProtector) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPKeyPair keyPair = KeyRingBuilder.generateKeyPair(keySpec);
        PasswordBasedSecretKeyRingProtector subKeyProtector = PasswordBasedSecretKeyRingProtector.forKeyId(keyPair.getKeyID(), subKeyPassphrase);
        SelfSignatureSubpackets.Callback callback = new SelfSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                SignatureSubpacketsHelper.applyFrom(keySpec.getSubpackets(), (SignatureSubpackets)hashedSubpackets);
            }
        };
        List<KeyFlag> keyFlags = KeyFlag.fromBitmask(keySpec.getSubpackets().getKeyFlags());
        KeyFlag firstFlag = keyFlags.remove(0);
        KeyFlag[] otherFlags = keyFlags.toArray(new KeyFlag[0]);
        return this.addSubKey(keyPair, callback, subKeyProtector, secretKeyRingProtector, firstFlag, otherFlags);
    }

    @Override
    public SecretKeyRingEditorInterface addSubKey(@Nonnull KeySpec keySpec, @Nullable Passphrase subkeyPassphrase, @Nullable SelfSignatureSubpackets.Callback subpacketsCallback, @Nonnull SecretKeyRingProtector secretKeyRingProtector) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPKeyPair keyPair = KeyRingBuilder.generateKeyPair(keySpec);
        PasswordBasedSecretKeyRingProtector subKeyProtector = PasswordBasedSecretKeyRingProtector.forKeyId(keyPair.getKeyID(), subkeyPassphrase);
        List<KeyFlag> keyFlags = KeyFlag.fromBitmask(keySpec.getSubpackets().getKeyFlags());
        KeyFlag firstFlag = keyFlags.remove(0);
        KeyFlag[] otherFlags = keyFlags.toArray(new KeyFlag[0]);
        return this.addSubKey(keyPair, subpacketsCallback, subKeyProtector, secretKeyRingProtector, firstFlag, otherFlags);
    }

    @Override
    public SecretKeyRingEditorInterface addSubKey(@Nonnull PGPKeyPair subkey, @Nullable SelfSignatureSubpackets.Callback bindingSignatureCallback, @Nonnull SecretKeyRingProtector subkeyProtector, @Nonnull SecretKeyRingProtector primaryKeyProtector, @Nonnull KeyFlag keyFlag, KeyFlag ... additionalKeyFlags) throws PGPException, IOException, NoSuchAlgorithmException {
        KeyFlag[] flags = CollectionUtils.concat(keyFlag, additionalKeyFlags);
        PublicKeyAlgorithm subkeyAlgorithm = PublicKeyAlgorithm.fromId(subkey.getPublicKey().getAlgorithm());
        SignatureSubpacketsUtil.assureKeyCanCarryFlags(subkeyAlgorithm, new KeyFlag[0]);
        PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.fromId(subkey.getPublicKey().getAlgorithm());
        int bitStrength = BCUtil.getBitStrength(subkey.getPublicKey());
        if (!PGPainless.getPolicy().getPublicKeyAlgorithmPolicy().isAcceptable(publicKeyAlgorithm, bitStrength)) {
            throw new IllegalArgumentException("Public key algorithm policy violation: " + (Object)((Object)publicKeyAlgorithm) + " with bit strength " + bitStrength + " is not acceptable.");
        }
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing);
        PublicKeyAlgorithm signingKeyAlgorithm = PublicKeyAlgorithm.fromId(primaryKey.getPublicKey().getAlgorithm());
        HashAlgorithm hashAlgorithm = HashAlgorithmNegotiator.negotiateSignatureHashAlgorithm(PGPainless.getPolicy()).negotiateHashAlgorithm(info.getPreferredHashAlgorithms());
        PGPKeyRingGenerator ringGenerator = new PGPKeyRingGenerator(this.secretKeyRing, primaryKeyProtector.getDecryptor(primaryKey.getKeyID()), ImplementationFactory.getInstance().getV4FingerprintCalculator(), ImplementationFactory.getInstance().getPGPContentSignerBuilder(signingKeyAlgorithm, hashAlgorithm), subkeyProtector.getEncryptor(subkey.getKeyID()));
        SignatureSubpackets hashedSubpackets = SignatureSubpackets.createHashedSubpackets(primaryKey.getPublicKey());
        SignatureSubpackets unhashedSubpackets = SignatureSubpackets.createEmptySubpackets();
        hashedSubpackets.setKeyFlags(flags);
        if (bindingSignatureCallback != null) {
            bindingSignatureCallback.modifyHashedSubpackets(hashedSubpackets);
            bindingSignatureCallback.modifyUnhashedSubpackets(unhashedSubpackets);
        }
        boolean isSigningKey = CollectionUtils.contains(flags, KeyFlag.SIGN_DATA) || CollectionUtils.contains(flags, KeyFlag.CERTIFY_OTHER);
        PGPContentSignerBuilder primaryKeyBindingSigner = null;
        if (isSigningKey) {
            primaryKeyBindingSigner = ImplementationFactory.getInstance().getPGPContentSignerBuilder(subkeyAlgorithm, hashAlgorithm);
        }
        ringGenerator.addSubKey(subkey, SignatureSubpacketsHelper.toVector(hashedSubpackets), SignatureSubpacketsHelper.toVector(unhashedSubpackets), primaryKeyBindingSigner);
        this.secretKeyRing = ringGenerator.generateSecretKeyRing();
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface revoke(@Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationAttributes revocationAttributes) throws PGPException {
        RevocationSignatureSubpackets.Callback callback = SecretKeyRingEditor.callbackFromRevocationAttributes(revocationAttributes);
        return this.revoke(secretKeyRingProtector, callback);
    }

    @Override
    public SecretKeyRingEditorInterface revoke(@Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationSignatureSubpackets.Callback subpacketsCallback) throws PGPException {
        return this.revokeSubKey(this.secretKeyRing.getSecretKey().getKeyID(), secretKeyRingProtector, subpacketsCallback);
    }

    @Override
    public SecretKeyRingEditorInterface revokeSubKey(long subKeyId, SecretKeyRingProtector protector, RevocationAttributes revocationAttributes) throws PGPException {
        RevocationSignatureSubpackets.Callback callback = SecretKeyRingEditor.callbackFromRevocationAttributes(revocationAttributes);
        return this.revokeSubKey(subKeyId, protector, callback);
    }

    @Override
    public SecretKeyRingEditorInterface revokeSubKey(long keyID, @Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationSignatureSubpackets.Callback subpacketsCallback) throws PGPException {
        PGPPublicKey revokeeSubKey = KeyRingUtils.requirePublicKeyFrom((PGPKeyRing)this.secretKeyRing, keyID);
        PGPSignature subKeyRevocation = this.generateRevocation(secretKeyRingProtector, revokeeSubKey, subpacketsCallback);
        this.secretKeyRing = KeyRingUtils.injectCertification(this.secretKeyRing, revokeeSubKey, subKeyRevocation);
        return this;
    }

    @Override
    public PGPSignature createRevocationCertificate(@Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubKey = this.secretKeyRing.getPublicKey();
        PGPSignature revocationCertificate = this.generateRevocation(secretKeyRingProtector, revokeeSubKey, SecretKeyRingEditor.callbackFromRevocationAttributes(revocationAttributes));
        return revocationCertificate;
    }

    @Override
    public PGPSignature createRevocationCertificate(long subkeyId, @Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationAttributes revocationAttributes) throws PGPException {
        PGPPublicKey revokeeSubkey = KeyRingUtils.requirePublicKeyFrom((PGPKeyRing)this.secretKeyRing, subkeyId);
        RevocationSignatureSubpackets.Callback callback = SecretKeyRingEditor.callbackFromRevocationAttributes(revocationAttributes);
        return this.generateRevocation(secretKeyRingProtector, revokeeSubkey, callback);
    }

    @Override
    public PGPSignature createRevocationCertificate(long subkeyId, @Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationSignatureSubpackets.Callback certificateSubpacketsCallback) throws PGPException {
        PGPPublicKey revokeeSubkey = KeyRingUtils.requirePublicKeyFrom((PGPKeyRing)this.secretKeyRing, subkeyId);
        return this.generateRevocation(secretKeyRingProtector, revokeeSubkey, certificateSubpacketsCallback);
    }

    private PGPSignature generateRevocation(@Nonnull SecretKeyRingProtector protector, @Nonnull PGPPublicKey revokeeSubKey, @Nullable RevocationSignatureSubpackets.Callback callback) throws PGPException {
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        SignatureType signatureType = revokeeSubKey.isMasterKey() ? SignatureType.KEY_REVOCATION : SignatureType.SUBKEY_REVOCATION;
        RevocationSignatureBuilder signatureBuilder = new RevocationSignatureBuilder(signatureType, primaryKey, protector);
        signatureBuilder.applyCallback(callback);
        PGPSignature revocation = signatureBuilder.build(revokeeSubKey);
        return revocation;
    }

    private static RevocationSignatureSubpackets.Callback callbackFromRevocationAttributes(final @Nullable RevocationAttributes attributes) {
        return new RevocationSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(RevocationSignatureSubpackets hashedSubpackets) {
                if (attributes != null) {
                    hashedSubpackets.setRevocationReason(attributes);
                }
            }
        };
    }

    @Override
    public SecretKeyRingEditorInterface revokeUserId(@Nonnull CharSequence userId, @Nonnull SecretKeyRingProtector secretKeyRingProtector, final @Nullable RevocationAttributes revocationAttributes) throws PGPException {
        RevocationAttributes.Reason reason;
        if (revocationAttributes != null && (reason = revocationAttributes.getReason()) != RevocationAttributes.Reason.NO_REASON && reason != RevocationAttributes.Reason.USER_ID_NO_LONGER_VALID) {
            throw new IllegalArgumentException("Revocation reason must either be NO_REASON or USER_ID_NO_LONGER_VALID");
        }
        RevocationSignatureSubpackets.Callback callback = new RevocationSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(RevocationSignatureSubpackets hashedSubpackets) {
                if (revocationAttributes != null) {
                    hashedSubpackets.setRevocationReason(false, revocationAttributes);
                }
            }
        };
        return this.revokeUserId(userId, secretKeyRingProtector, callback);
    }

    @Override
    public SecretKeyRingEditorInterface revokeUserId(@Nonnull CharSequence userId, @Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationSignatureSubpackets.Callback subpacketCallback) throws PGPException {
        String sanitized = this.sanitizeUserId(userId);
        return this.revokeUserIds(SelectUserId.exactMatch(sanitized), secretKeyRingProtector, subpacketCallback);
    }

    @Override
    public SecretKeyRingEditorInterface revokeUserIds(@Nonnull SelectUserId userIdSelector, @Nonnull SecretKeyRingProtector secretKeyRingProtector, final @Nullable RevocationAttributes revocationAttributes) throws PGPException {
        return this.revokeUserIds(userIdSelector, secretKeyRingProtector, new RevocationSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(RevocationSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setRevocationReason(revocationAttributes);
            }
        });
    }

    @Override
    public SecretKeyRingEditorInterface revokeUserIds(@Nonnull SelectUserId userIdSelector, @Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nullable RevocationSignatureSubpackets.Callback subpacketsCallback) throws PGPException {
        List<String> selected = userIdSelector.selectUserIds((PGPKeyRing)this.secretKeyRing);
        if (selected.isEmpty()) {
            throw new NoSuchElementException("No matching user-ids found on the key.");
        }
        for (String userId : selected) {
            this.doRevokeUserId(userId, secretKeyRingProtector, subpacketsCallback);
        }
        return this;
    }

    private SecretKeyRingEditorInterface doRevokeUserId(@Nonnull String userId, @Nonnull SecretKeyRingProtector protector, @Nullable RevocationSignatureSubpackets.Callback callback) throws PGPException {
        PGPSecretKey primarySecretKey = this.secretKeyRing.getSecretKey();
        RevocationSignatureBuilder signatureBuilder = new RevocationSignatureBuilder(SignatureType.CERTIFICATION_REVOCATION, primarySecretKey, protector);
        signatureBuilder.applyCallback(callback);
        PGPSignature revocationSignature = signatureBuilder.build(userId);
        this.secretKeyRing = KeyRingUtils.injectCertification(this.secretKeyRing, userId, revocationSignature);
        return this;
    }

    @Override
    public SecretKeyRingEditorInterface setExpirationDate(@Nullable Date expiration, @Nonnull SecretKeyRingProtector secretKeyRingProtector) throws PGPException {
        String primaryUserId;
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        if (!primaryKey.isMasterKey()) {
            throw new IllegalArgumentException("Key Ring does not appear to contain a primary secret key.");
        }
        PGPSignature prevDirectKeySig = this.getPreviousDirectKeySignature();
        if (prevDirectKeySig != null) {
            PGPSignature directKeySig = this.reissueDirectKeySignature(expiration, secretKeyRingProtector, prevDirectKeySig);
            this.secretKeyRing = KeyRingUtils.injectCertification(this.secretKeyRing, primaryKey.getPublicKey(), directKeySig);
        }
        if ((primaryUserId = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing).getPossiblyExpiredUserId()) != null) {
            PGPSignature prevUserIdSig = this.getPreviousUserIdSignatures(primaryUserId);
            PGPSignature userIdSig = this.reissuePrimaryUserIdSig(expiration, secretKeyRingProtector, primaryUserId, prevUserIdSig);
            this.secretKeyRing = KeyRingUtils.injectCertification(this.secretKeyRing, primaryUserId, userIdSig);
        }
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing);
        for (String userId : info.getValidUserIds()) {
            if (userId.equals(primaryUserId)) continue;
            PGPSignature prevUserIdSig = info.getLatestUserIdCertification(userId);
            if (prevUserIdSig == null) {
                throw new AssertionError((Object)"A valid user-id shall never have no user-id signature.");
            }
            if (!prevUserIdSig.getHashedSubPackets().isPrimaryUserID()) continue;
            PGPSignature userIdSig = this.reissueNonPrimaryUserId(secretKeyRingProtector, userId, prevUserIdSig);
            this.secretKeyRing = KeyRingUtils.injectCertification(this.secretKeyRing, primaryUserId, userIdSig);
        }
        return this;
    }

    private PGPSignature reissueNonPrimaryUserId(SecretKeyRingProtector secretKeyRingProtector, String userId, PGPSignature prevUserIdSig) throws PGPException {
        SelfSignatureBuilder builder = new SelfSignatureBuilder(this.secretKeyRing.getSecretKey(), secretKeyRingProtector, prevUserIdSig);
        builder.applyCallback(new SelfSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setPrimaryUserId(null);
            }
        });
        return builder.build(this.secretKeyRing.getPublicKey(), userId);
    }

    private PGPSignature reissuePrimaryUserIdSig(final @Nullable Date expiration, @Nonnull SecretKeyRingProtector secretKeyRingProtector, @Nonnull String primaryUserId, @Nonnull PGPSignature prevUserIdSig) throws PGPException {
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        final PGPPublicKey publicKey = primaryKey.getPublicKey();
        SelfSignatureBuilder builder = new SelfSignatureBuilder(primaryKey, secretKeyRingProtector, prevUserIdSig);
        builder.applyCallback(new SelfSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                if (expiration != null) {
                    hashedSubpackets.setKeyExpirationTime(true, publicKey.getCreationTime(), expiration);
                } else {
                    hashedSubpackets.setKeyExpirationTime(new KeyExpirationTime(true, 0L));
                }
                hashedSubpackets.setPrimaryUserId();
            }
        });
        return builder.build(publicKey, primaryUserId);
    }

    private PGPSignature reissueDirectKeySignature(final Date expiration, SecretKeyRingProtector secretKeyRingProtector, PGPSignature prevDirectKeySig) throws PGPException {
        PGPSecretKey primaryKey = this.secretKeyRing.getSecretKey();
        PGPPublicKey publicKey = primaryKey.getPublicKey();
        final Date keyCreationTime = publicKey.getCreationTime();
        DirectKeySignatureBuilder builder = new DirectKeySignatureBuilder(primaryKey, secretKeyRingProtector, prevDirectKeySig);
        builder.applyCallback(new SelfSignatureSubpackets.Callback(){

            @Override
            public void modifyHashedSubpackets(SelfSignatureSubpackets hashedSubpackets) {
                if (expiration != null) {
                    hashedSubpackets.setKeyExpirationTime(keyCreationTime, expiration);
                } else {
                    hashedSubpackets.setKeyExpirationTime(null);
                }
            }
        });
        return builder.build(publicKey);
    }

    private PGPSignature getPreviousDirectKeySignature() {
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing);
        return info.getLatestDirectKeySelfSignature();
    }

    private PGPSignature getPreviousUserIdSignatures(String userId) {
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)this.secretKeyRing);
        return info.getLatestUserIdCertification(userId);
    }

    @Override
    public SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings changePassphraseFromOldPassphrase(@Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        PasswordBasedSecretKeyRingProtector protector = new PasswordBasedSecretKeyRingProtector(oldProtectionSettings, new SolitaryPassphraseProvider(oldPassphrase));
        return new WithKeyRingEncryptionSettingsImpl(null, protector);
    }

    @Override
    public SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings changeSubKeyPassphraseFromOldPassphrase(@Nonnull Long keyId, @Nullable Passphrase oldPassphrase, @Nonnull KeyRingProtectionSettings oldProtectionSettings) {
        Map<Long, Passphrase> passphraseMap = Collections.singletonMap(keyId, oldPassphrase);
        CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector(passphraseMap, oldProtectionSettings, null);
        return new WithKeyRingEncryptionSettingsImpl(keyId, protector);
    }

    @Override
    public PGPSecretKeyRing done() {
        return this.secretKeyRing;
    }

    private PGPSecretKeyRing changePassphrase(Long keyId, PGPSecretKeyRing secretKeys, SecretKeyRingProtector oldProtector, SecretKeyRingProtector newProtector) throws PGPException {
        Iterator secretKeyIterator;
        ArrayList<PGPSecretKey> secretKeyList = new ArrayList<PGPSecretKey>();
        if (keyId == null) {
            secretKeyIterator = secretKeys.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                secretKey = SecretKeyRingEditor.reencryptPrivateKey(secretKey, oldProtector, newProtector);
                secretKeyList.add(secretKey);
            }
        } else {
            secretKeyIterator = secretKeys.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                if (secretKey.getPublicKey().getKeyID() == keyId.longValue()) {
                    secretKey = SecretKeyRingEditor.reencryptPrivateKey(secretKey, oldProtector, newProtector);
                }
                secretKeyList.add(secretKey);
            }
        }
        PGPSecretKeyRing newRing = new PGPSecretKeyRing(secretKeyList);
        newRing = this.s2kUsageFixIfNecessary(newRing, newProtector);
        return newRing;
    }

    private PGPSecretKeyRing s2kUsageFixIfNecessary(PGPSecretKeyRing secretKeys, SecretKeyRingProtector protector) throws PGPException {
        boolean hasS2KUsageChecksum = false;
        for (PGPSecretKey secKey : secretKeys) {
            if (secKey.getS2KUsage() != 255) continue;
            hasS2KUsageChecksum = true;
            break;
        }
        if (hasS2KUsageChecksum) {
            secretKeys = S2KUsageFix.replaceUsageChecksumWithUsageSha1(secretKeys, protector, true);
        }
        return secretKeys;
    }

    private static PGPSecretKey reencryptPrivateKey(PGPSecretKey secretKey, SecretKeyRingProtector oldProtector, SecretKeyRingProtector newProtector) throws PGPException {
        S2K s2k = secretKey.getS2K();
        if (s2k == null || s2k.getType() != 101) {
            long secretKeyId = secretKey.getKeyID();
            PBESecretKeyDecryptor decryptor = oldProtector.getDecryptor(secretKeyId);
            PBESecretKeyEncryptor encryptor = newProtector.getEncryptor(secretKeyId);
            secretKey = PGPSecretKey.copyWithNewPassword((PGPSecretKey)secretKey, (PBESecretKeyDecryptor)decryptor, (PBESecretKeyEncryptor)encryptor);
        }
        return secretKey;
    }

    private final class WithPassphraseImpl
    implements SecretKeyRingEditorInterface.WithPassphrase {
        private final SecretKeyRingProtector oldProtector;
        private final KeyRingProtectionSettings newProtectionSettings;
        private final Long keyId;

        private WithPassphraseImpl(Long keyId, SecretKeyRingProtector oldProtector, KeyRingProtectionSettings newProtectionSettings) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
            this.newProtectionSettings = newProtectionSettings;
        }

        @Override
        public SecretKeyRingEditorInterface toNewPassphrase(Passphrase passphrase) throws PGPException {
            PasswordBasedSecretKeyRingProtector newProtector = new PasswordBasedSecretKeyRingProtector(this.newProtectionSettings, new SolitaryPassphraseProvider(passphrase));
            PGPSecretKeyRing secretKeys = SecretKeyRingEditor.this.changePassphrase(this.keyId, SecretKeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            SecretKeyRingEditor.this.secretKeyRing = secretKeys;
            return SecretKeyRingEditor.this;
        }

        @Override
        public SecretKeyRingEditorInterface toNoPassphrase() throws PGPException {
            UnprotectedKeysProtector newProtector = new UnprotectedKeysProtector();
            PGPSecretKeyRing secretKeys = SecretKeyRingEditor.this.changePassphrase(this.keyId, SecretKeyRingEditor.this.secretKeyRing, this.oldProtector, newProtector);
            SecretKeyRingEditor.this.secretKeyRing = secretKeys;
            return SecretKeyRingEditor.this;
        }
    }

    private final class WithKeyRingEncryptionSettingsImpl
    implements SecretKeyRingEditorInterface.WithKeyRingEncryptionSettings {
        private final Long keyId;
        private final SecretKeyRingProtector oldProtector;

        private WithKeyRingEncryptionSettingsImpl(Long keyId, SecretKeyRingProtector oldProtector) {
            this.keyId = keyId;
            this.oldProtector = oldProtector;
        }

        @Override
        public SecretKeyRingEditorInterface.WithPassphrase withSecureDefaultSettings() {
            return this.withCustomSettings(KeyRingProtectionSettings.secureDefaultSettings());
        }

        @Override
        public SecretKeyRingEditorInterface.WithPassphrase withCustomSettings(KeyRingProtectionSettings settings) {
            return new WithPassphraseImpl(this.keyId, this.oldProtector, settings);
        }
    }
}

