/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.DirectKeySignatureBuilder;
import org.pgpainless.signature.builder.SelfSignatureBuilder;

public class ProofUtil {
    public PGPSecretKeyRing addProof(PGPSecretKeyRing secretKey, SecretKeyRingProtector protector, Proof proof) throws PGPException {
        return this.addProofs(secretKey, protector, Collections.singletonList(proof));
    }

    public PGPSecretKeyRing addProofs(PGPSecretKeyRing secretKey, SecretKeyRingProtector protector, List<Proof> proofs) throws PGPException {
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        return this.addProofs(secretKey, protector, info.getPrimaryUserId(), proofs);
    }

    public PGPSecretKeyRing addProof(PGPSecretKeyRing secretKey, SecretKeyRingProtector protector, String userId, Proof proof) throws PGPException {
        return this.addProofs(secretKey, protector, userId, Collections.singletonList(proof));
    }

    public PGPSecretKeyRing addProofs(PGPSecretKeyRing secretKey, SecretKeyRingProtector protector, @Nullable String userId, List<Proof> proofs) throws PGPException {
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        PGPSecretKey certificationKey = secretKey.getSecretKey();
        PGPPublicKey certificationPubKey = certificationKey.getPublicKey();
        PGPSignature certification = null;
        if (userId == null) {
            PGPSignature previousCertification = info.getLatestDirectKeySelfSignature();
            if (previousCertification == null) {
                throw new NoSuchElementException("No previous valid direct key signature found.");
            }
            DirectKeySignatureBuilder sigBuilder = new DirectKeySignatureBuilder(certificationKey, protector, previousCertification);
            for (Proof proof : proofs) {
                sigBuilder.getHashedSubpackets().addNotationData(false, proof.getNotationName(), proof.getNotationValue());
            }
            certification = sigBuilder.build(certificationPubKey);
            certificationPubKey = PGPPublicKey.addCertification((PGPPublicKey)certificationPubKey, (PGPSignature)certification);
        } else {
            if (!info.isUserIdValid(userId)) {
                throw new IllegalArgumentException("User ID " + userId + " seems to not be valid for this key.");
            }
            PGPSignature previousCertification = info.getLatestUserIdCertification(userId);
            if (previousCertification == null) {
                throw new NoSuchElementException("No previous valid user-id certification found.");
            }
            SelfSignatureBuilder sigBuilder = new SelfSignatureBuilder(certificationKey, protector, previousCertification);
            for (Proof proof : proofs) {
                sigBuilder.getHashedSubpackets().addNotationData(false, proof.getNotationName(), proof.getNotationValue());
            }
            certification = sigBuilder.build(certificationPubKey, userId);
            certificationPubKey = PGPPublicKey.addCertification((PGPPublicKey)certificationPubKey, (String)userId, (PGPSignature)certification);
        }
        certificationKey = PGPSecretKey.replacePublicKey((PGPSecretKey)certificationKey, (PGPPublicKey)certificationPubKey);
        secretKey = PGPSecretKeyRing.insertSecretKey((PGPSecretKeyRing)secretKey, (PGPSecretKey)certificationKey);
        return secretKey;
    }

    public static List<Proof> getProofs(PGPSignature signature) {
        PGPSignatureSubpacketVector hashedSubpackets = signature.getHashedSubPackets();
        NotationData[] notations = hashedSubpackets.getNotationDataOccurrences();
        ArrayList<Proof> proofs = new ArrayList<Proof>();
        for (NotationData notation : notations) {
            if (!notation.getNotationName().equals("proof@metacode.biz")) continue;
            proofs.add(new Proof(notation.getNotationValue()));
        }
        return proofs;
    }

    public static class Proof {
        public static final String NOTATION_NAME = "proof@metacode.biz";
        private final String notationValue;

        public Proof(String notationValue) {
            if (notationValue == null) {
                throw new IllegalArgumentException("Notation value cannot be null.");
            }
            String trimmed = notationValue.trim();
            if (trimmed.isEmpty()) {
                throw new IllegalArgumentException("Notation value cannot be empty.");
            }
            this.notationValue = trimmed;
        }

        public String getNotationName() {
            return NOTATION_NAME;
        }

        public String getNotationValue() {
            return this.notationValue;
        }

        public static Proof fromMatrixPermalink(String username, String eventPermalink) {
            Pattern pattern = Pattern.compile("^https:\\/\\/matrix\\.to\\/#\\/(![a-zA-Z]{18}:matrix\\.org)\\/(\\$[a-zA-Z0-9\\-_]{43})\\?via=.*$");
            Matcher matcher = pattern.matcher(eventPermalink);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid matrix event permalink.");
            }
            String roomId = matcher.group(1);
            String eventId = matcher.group(2);
            return new Proof(String.format("matrix:u/%s?org.keyoxide.r=%s&org.keyoxide.e=%s", username, roomId, eventId));
        }

        public String toString() {
            return this.getNotationName() + "=" + this.getNotationValue();
        }
    }
}

