/*
 * Decompiled with CFR 0.152.
 */
package investigations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.ArmorUtils;

public class InvestigateThunderbirdDecryption {
    String OUR_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 47D2 3A5E 1455 1FD2 0599  C1FC B57B 5451 9E2D 8FE4\nComment: Alice <alice@pgpainless.org>\n\nlFgEYP8FlBYJKwYBBAHaRw8BAQdAeJ7fL4TbpSLUJsxGUFnN5MzDZr3lKoKWEO+z\nhQEFPqcAAP0T8ED8kcch++7UpcN7qZMP4ihbE9Fu9kp/IKOCZDVwGhF+tBxBbGlj\nZSA8YWxpY2VAcGdwYWlubGVzcy5vcmc+iHgEExYKACAFAmD/BZQCGwEFFgIDAQAE\nCwkIBwUVCgkICwIeAQIZAQAKCRC1e1RRni2P5PYqAQC/r4R4RFfVIOPAc16PiffO\nGDMzRUYAjIyflvOBIEE//QEAsZGQzIstdIp8gY5CF27pbnnSAA/OGPXbDsNArzPN\ntQicXQRg/wWUEgorBgEEAZdVAQUBAQdAFHEP5NzgON0usvHOsTsROojwVTAqgayc\nfdPdb597u3UDAQgHAAD/ShtbTmAyZJDjcEDfUNblOogyWntCEgb18Cs5rRm1+agP\nmIh1BBgWCgAdBQJg/wWUAhsMBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQtXtUUZ4t\nj+SWdwD/cCXm/ufcaIMMOqRw10Lwefc4euOrpFScWA0rUjnK6yEBAMOH1kGHlLbz\nmk6D7RbBDdC3aW4xGRjSYBkyhbuxevsDnFgEYP8FlBYJKwYBBAHaRw8BAQdAmuvN\nFF+pklSxw3+VVqVu2g2ulpJE7HldtU/Jud/jiEgAAP0RPh7QWqm2hhY6vBNr8fhz\n3GBAfZ4A9HxVymuu1M6qMxEdiNUEGBYKAH0FAmD/BZQCGwIFFgIDAQAECwkIBwUV\nCgkICwIeAV8gBBkWCgAGBQJg/wWUAAoJEIYvdZaRbR0mBesA/2dxyf9vfRnyrNcm\ndguMzYe9oLfD2SU2Sa0jXcURQ+A6AP9uYaehPZvEH0kwdeSi60uCOVznCePrY1mK\nM6UEDMPGBwAKCRC1e1RRni2P5J1FAQDhI3tN5C/klh2j8ptQ7ht0LPlbgVU/WmT8\nkqejd80WVgEA4dg7MZTk+uzwOWEGIHyxWXRzma9a5k1kM+uxX3RflQU=\n=IEzi\n-----END PGP PRIVATE KEY BLOCK-----";
    String THEIR_CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: FlowCrypt [BUILD_REPLACEABLE_VERSION] Gmail Encryption\nComment: Seamlessly send and receive encrypted email\n\nxjMEYL/CRRYJKwYBBAHaRw8BAQdAxaJrnD/gWRGqaAVtQ8R9PI0ZGu/YESJ4\nHsJeeCxUZOvNF0RlbiA8ZGVuQGZsb3djcnlwdC5jb20+wn4EExYKACYFAmC/\nwkUCGwMFFgIDAQAECwkIBwUVCgkICwIeAQIZAQWJAQ/XOQAKCRCGwF2G4DXc\ncttHAP9Axna+jmFhZEajILW7BZ8UJpgz7mCC48RMtRj/pre4nQD/bKJXB+sD\nzti+tRbi7KNncgkSQeau+Vy/ZnpBUUHBWwjOOARgv8JFEgorBgEEAZdVAQUB\nAQdA3dN8Hh18Pqd6OevXWl36y7cM58ZRmUVEEZukXRIholYDAQgHwnUEGBYK\nAB0FAmC/wkUCGwwFFgIDAQAECwkIBwUVCgkICwIeAQAKCRCGwF2G4DXcclpK\nAQC0uUHWUFNao1Fl85+4c8WecGKsGCihNU9H3q+I1gz22gEAtVo1dWnc0t1f\nh1MUYq5FmME+KeFCBZZ9lrMAxRhvigI=\n=+XVJ\n-----END PGP PUBLIC KEY BLOCK-----\n";

    @Test
    public void generateMessage() throws PGPException, IOException {
        System.out.println("Decryption Key");
        System.out.println(this.OUR_KEY);
        PGPSecretKeyRing ourKey = PGPainless.readKeyRing().secretKeyRing(this.OUR_KEY);
        PGPPublicKeyRing ourCert = PGPainless.extractCertificate((PGPSecretKeyRing)ourKey);
        PGPPublicKeyRing theirCert = PGPainless.readKeyRing().publicKeyRing(this.THEIR_CERT);
        System.out.println("Certificate:");
        System.out.println(ArmorUtils.toAsciiArmoredString((PGPPublicKeyRing)ourCert));
        System.out.println("Crypt-Only:");
        ProducerOptions producerOptions = ProducerOptions.encrypt((EncryptionOptions)new EncryptionOptions().addRecipient(ourCert).addRecipient(theirCert)).setFileName("msg.txt").setModificationDate(new Date());
        this.generateMessage(producerOptions);
        System.out.println("Sign-Crypt:");
        producerOptions = ProducerOptions.signAndEncrypt((EncryptionOptions)new EncryptionOptions().addRecipient(ourCert).addRecipient(theirCert), (SigningOptions)new SigningOptions().addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), ourKey, DocumentSignatureType.BINARY_DOCUMENT)).setFileName("msg.txt").setModificationDate(new Date());
        this.generateMessage(producerOptions);
    }

    private void generateMessage(ProducerOptions producerOptions) throws PGPException, IOException {
        String data = "Hello World\n";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(producerOptions);
        Streams.pipeAll((InputStream)new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptionStream);
        encryptionStream.close();
        System.out.println(out);
    }

    @Test
    public void testWithSuspiciousKey() throws PGPException, IOException {
        String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: 4409 A346 1359 96C9 4595  510E 5A18 53D1 5656 CB7A\nComment: Alice (Created with pgpkeygen.com) <alice@pgpainless.or\n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\n=Zaty\n-----END PGP PRIVATE KEY BLOCK-----\n";
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(KEY);
        PGPPublicKeyRing publicKey = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        ByteArrayInputStream data = new ByteArrayInputStream("Hello, World!\n".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)EncryptionOptions.encryptCommunications().addRecipient(publicKey), (SigningOptions)SigningOptions.get().addInlineSignature(SecretKeyRingProtector.unprotectedKeys(), secretKey, DocumentSignatureType.BINARY_DOCUMENT)).setAsciiArmor(true));
        Streams.pipeAll((InputStream)data, (OutputStream)encryptionStream);
        encryptionStream.close();
        System.out.println(out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ByteArrayOutputStream clear = new ByteArrayOutputStream();
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(new ConsumerOptions().addDecryptionKey(secretKey, SecretKeyRingProtector.unprotectedKeys()).addVerificationCert(publicKey));
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)clear);
        decryptionStream.close();
        System.out.println(clear);
    }
}

