/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection.fixes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.fixes.S2KUsageFix;
import org.pgpainless.util.Passphrase;

public class S2KUsageFixTest {
    private static final String KEY_WITH_USAGE_CHECKSUM = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 23BF 0F50 8FE4 2304 6AC6  6EE3 7616 09ED DAF2 A7EE\nComment: Alice\n\nlHQEYTpM0xYJKwYBBAHaRw8BAQdA77HCCgjnEWBk9O9guvePTA7235v6yoTGUmUo\n91V2OVr/CQMC5+tUnE2l4Ypg4dv9+qzBXjlQKAU5fktbQpIvYV9+pPXY6O+Wa7qJ\nmIJsX2GsMR4uSLeAeQtFuPP0ZydL8rQFQWxpY2WIeAQTFgoAIAUCYTpM1AIbAQUW\nAgMBAAQLCQgHBRUKCQgLAh4BAhkBAAoJEHYWCe3a8qfu9uYBAJGoTlRUEPCmzDBY\niqAXI8q1ZJDpYAF/AgdyfHgPZBLZAQDFagfWe/YyZV36EQ8P978gycUn4psQZyXE\nQoNByDZDAJx5BGE6TNQSCisGAQQBl1UBBQEBB0BM9uoewIA3wDjChe7qdpp9B/uD\nfQwxFj8AFcgR0qmDNgMBCAf/CQMC4B9NmOhlt+BgyZTk4BqqudczkJsRhoKPPC3e\nTEqvyeBavp1fPgvAUfsZdL7Z8RoVQNd0LFptsj2zN2VcmIh1BBgWCgAdBQJhOkzU\nAhsMBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQdhYJ7dryp+4FxgEA29VePCidazQt\nF6DfQCyNPW/d0Y+rm64KaMfBHJGCorQA/Rdg/gGVH7RoMiIJ8+kDxWOC92tn8JBJ\nnIekiMcU45QJnHQEYTpM1BYJKwYBBAHaRw8BAQdAv2fItqEBrRsnrtWOU0Rc/S62\ntafcr2huX3W5Nu6R1On/CQMCR9EMBma4cl9gE854C43bgYY2o53XSnBS/OMzo1rt\nh+ixzZ6RZNafiAcXRUldVa55kc5KUvpc3y8lMlkDjYjVBBgWCgB9BQJhOkzUAhsC\nBRYCAwEABAsJCAcFFQoJCAsCHgFfIAQZFgoABgUCYTpM1AAKCRB7qwD3I/Rg7Iic\nAP4gOcJFEkRcNJMXVyXWWMaHGzvH7SJSn7/NDxjlbo+IhAD9HiPJoOm/88mHWxSr\nudMemY82nrspaOyxcwqgkJbT8wIACgkQdhYJ7dryp+6yUQD+IufwT/XdopWA+GPD\nIgT1CHRecJCkeYYmr7sZdPCLs3YA/jeVaFw4Z0drFnys4rh6aSoG6uf+YSba56V3\nVBL8P8MC\n=m6iF\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String MESSAGE = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4DnMY7X1OYFewSAQdAxAxbWTZordzH+fN5s32ZU4PjYM/Og8z6DG7mrjOy+2Mw\nBCiqa3G9GNZrRQyXihd1sFaxlgqiHrhhmFyCCMLgj2RxjZ7DJ4E0tA7RbF0lkqx4\n0kAB1XXqAOJ50mEEQLYRN94xojDoJrlz2ZdmV1zqC2ZFd6YITEPIqSdwBuEG61rd\nBLkPg8RuGdPMKZHZzOxIALtv\n=//m8\n-----END PGP MESSAGE-----";
    private static final String MESSAGE_PLAIN = "Hello, World!\n";

    @Test
    public void verifyOutFixInChangePassphraseWorks() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing before = PGPainless.generateKeyRing().modernKeyRing("Alice", "before");
        for (Object key : before) {
            Assertions.assertEquals((int)254, (int)key.getS2KUsage());
        }
        PGPSecretKeyRing unprotected = PGPainless.modifyKeyRing((PGPSecretKeyRing)before).changePassphraseFromOldPassphrase(Passphrase.fromPassword((String)"before")).withSecureDefaultSettings().toNoPassphrase().done();
        for (PGPSecretKey key : unprotected) {
            Assertions.assertEquals((int)0, (int)key.getS2KUsage());
        }
        PGPSecretKeyRing after = PGPainless.modifyKeyRing((PGPSecretKeyRing)unprotected).changePassphraseFromOldPassphrase(null).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((String)"after")).done();
        for (PGPSecretKey key : after) {
            Assertions.assertEquals((int)254, (int)key.getS2KUsage());
        }
    }

    @Test
    public void testFixS2KUsageFrom_USAGE_CHECKSUM_to_USAGE_SHA1() throws IOException, PGPException {
        PGPSecretKeyRing keys = PGPainless.readKeyRing().secretKeyRing(KEY_WITH_USAGE_CHECKSUM);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)Passphrase.fromPassword((String)"after"));
        PGPSecretKeyRing fixed = S2KUsageFix.replaceUsageChecksumWithUsageSha1((PGPSecretKeyRing)keys, (SecretKeyRingProtector)protector);
        for (PGPSecretKey key : fixed) {
            Assertions.assertEquals((int)254, (int)key.getS2KUsage());
        }
        this.testCanStillDecrypt(keys, protector);
    }

    private void testCanStillDecrypt(PGPSecretKeyRing keys, SecretKeyRingProtector protector) throws PGPException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(MESSAGE.getBytes(StandardCharsets.UTF_8));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(new ConsumerOptions().addDecryptionKey(keys, protector));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        Assertions.assertArrayEquals((byte[])MESSAGE_PLAIN.getBytes(StandardCharsets.UTF_8), (byte[])out.toByteArray());
    }
}

