/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.SignaturePicker;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public class SignatureSubpacketsUtilTest {
    @Test
    public void testGetKeyExpirationTimeAsDate() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Expire", null);
        Date expiration = Date.from(new Date().toInstant().plus(365L, ChronoUnit.DAYS));
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(expiration, SecretKeyRingProtector.unprotectedKeys()).done();
        PGPSignature expirationSig = SignaturePicker.pickCurrentUserIdCertificationSignature((PGPKeyRing)secretKeys, (String)"Expire", (Policy)Policy.getInstance(), (Date)new Date());
        PGPPublicKey notTheRightKey = (PGPPublicKey)PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getSigningSubkeys().get(0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SignatureSubpacketsUtil.getKeyExpirationTimeAsDate((PGPSignature)expirationSig, (PGPPublicKey)notTheRightKey));
    }

    @Test
    public void testGetRevocable() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignature withoutRevocable = generator.generateCertification(secretKeys.getPublicKey());
        Assertions.assertNull((Object)SignatureSubpacketsUtil.getRevocable((PGPSignature)withoutRevocable));
        generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator hashed = new PGPSignatureSubpacketGenerator();
        hashed.setRevocable(true, true);
        generator.setHashedSubpackets(hashed.generate());
        PGPSignature withRevocable = generator.generateCertification(secretKeys.getPublicKey());
        Assertions.assertNotNull((Object)SignatureSubpacketsUtil.getRevocable((PGPSignature)withRevocable));
    }

    @Test
    public void testParsePreferredCompressionAlgorithms() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator hashed = new PGPSignatureSubpacketGenerator();
        LinkedHashSet<CompressionAlgorithm> compressionAlgorithmSet = new LinkedHashSet<CompressionAlgorithm>(Arrays.asList(CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZIP));
        int[] ids = new int[compressionAlgorithmSet.size()];
        Iterator it = compressionAlgorithmSet.iterator();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((CompressionAlgorithm)it.next()).getAlgorithmId();
        }
        hashed.setPreferredCompressionAlgorithms(true, ids);
        generator.setHashedSubpackets(hashed.generate());
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        Set parsed = SignatureSubpacketsUtil.parsePreferredCompressionAlgorithms((PGPSignature)signature);
        Assertions.assertEquals(compressionAlgorithmSet, (Object)parsed);
    }

    @Test
    public void testParseKeyFlagsOfNullIsNull() {
        Assertions.assertNull((Object)SignatureSubpacketsUtil.parseKeyFlags(null));
    }

    @Test
    public void testParseKeyFlagsOfNullSubpacketIsNull() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignature withoutKeyFlags = generator.generateCertification(secretKeys.getPublicKey());
        Assertions.assertNull((Object)SignatureSubpacketsUtil.parseKeyFlags((PGPSignature)withoutKeyFlags));
    }

    @Test
    public void testParseFeaturesIsNullForNullSubpacket() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignature withoutKeyFlags = generator.generateCertification(secretKeys.getPublicKey());
        Assertions.assertNull((Object)SignatureSubpacketsUtil.parseFeatures((PGPSignature)withoutKeyFlags));
    }

    @Test
    public void testParseFeatures() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator hashed = new PGPSignatureSubpacketGenerator();
        hashed.setFeature(true, Feature.toBitmask((Feature[])new Feature[]{Feature.MODIFICATION_DETECTION, Feature.AEAD_ENCRYPTED_DATA}));
        generator.setHashedSubpackets(hashed.generate());
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        Set featureSet = SignatureSubpacketsUtil.parseFeatures((PGPSignature)signature);
        Assertions.assertEquals((int)2, (int)featureSet.size());
        Assertions.assertTrue((boolean)featureSet.contains(Feature.MODIFICATION_DETECTION));
        Assertions.assertTrue((boolean)featureSet.contains(Feature.AEAD_ENCRYPTED_DATA));
        Assertions.assertFalse((boolean)featureSet.contains(Feature.VERSION_5_PUBLIC_KEY));
    }

    @Test
    public void getSignatureTargetIsNull() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignature withoutSignatureTarget = generator.generateCertification(secretKeys.getPublicKey());
        Assertions.assertNull((Object)SignatureSubpacketsUtil.getSignatureTarget((PGPSignature)withoutSignatureTarget));
    }

    @Test
    public void testGetUnhashedNotationData() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator unhashed = new PGPSignatureSubpacketGenerator();
        unhashed.addNotationData(true, true, "test@notation.data", "notation-value");
        unhashed.addNotationData(true, true, "test@notation.data", "another-value");
        unhashed.addNotationData(true, true, "another@notation.data", "Hello-World!");
        generator.setUnhashedSubpackets(unhashed.generate());
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        List notations = SignatureSubpacketsUtil.getUnhashedNotationData((PGPSignature)signature);
        Assertions.assertEquals((int)3, (int)notations.size());
        Assertions.assertEquals((Object)"test@notation.data", (Object)((NotationData)notations.get(0)).getNotationName());
        Assertions.assertEquals((Object)"test@notation.data", (Object)((NotationData)notations.get(1)).getNotationName());
        Assertions.assertEquals((Object)"another@notation.data", (Object)((NotationData)notations.get(2)).getNotationName());
        Assertions.assertEquals((Object)"notation-value", (Object)((NotationData)notations.get(0)).getNotationValue());
        Assertions.assertEquals((Object)"another-value", (Object)((NotationData)notations.get(1)).getNotationValue());
        Assertions.assertEquals((Object)"Hello-World!", (Object)((NotationData)notations.get(2)).getNotationValue());
        notations = SignatureSubpacketsUtil.getUnhashedNotationData((PGPSignature)signature, (String)"test@notation.data");
        Assertions.assertEquals((int)2, (int)notations.size());
        Assertions.assertEquals((Object)"notation-value", (Object)((NotationData)notations.get(0)).getNotationValue());
        Assertions.assertEquals((Object)"another-value", (Object)((NotationData)notations.get(1)).getNotationValue());
        notations = SignatureSubpacketsUtil.getUnhashedNotationData((PGPSignature)signature, (String)"invalid");
        Assertions.assertEquals((int)0, (int)notations.size());
    }

    @Test
    public void testGetRevocationKeyIsNull() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        Assertions.assertNull((Object)SignatureSubpacketsUtil.getRevocationKey((PGPSignature)signature));
    }

    @Test
    public void testGetRevocationKey() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator hashed = new PGPSignatureSubpacketGenerator();
        hashed.addRevocationKey(true, secretKeys.getPublicKey().getAlgorithm(), secretKeys.getPublicKey().getFingerprint());
        generator.setHashedSubpackets(hashed.generate());
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        RevocationKey revocationKey = SignatureSubpacketsUtil.getRevocationKey((PGPSignature)signature);
        Assertions.assertArrayEquals((byte[])secretKeys.getPublicKey().getFingerprint(), (byte[])revocationKey.getFingerprint());
        Assertions.assertEquals((int)secretKeys.getPublicKey().getAlgorithm(), (int)revocationKey.getAlgorithm());
    }

    @Test
    public void testGetIntendedRecipientFingerprintsEmpty() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        Assertions.assertEquals((int)0, (int)SignatureSubpacketsUtil.getIntendedRecipientFingerprints((PGPSignature)signature).size());
    }

    @Test
    public void testGetIntendedRecipientFingerprints() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator hashed = new PGPSignatureSubpacketGenerator();
        hashed.addIntendedRecipientFingerprint(true, secretKeys.getPublicKey());
        hashed.addIntendedRecipientFingerprint(true, TestKeys.getCryptiePublicKeyRing().getPublicKey());
        generator.setHashedSubpackets(hashed.generate());
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        List intendedRecipientFingerprints = SignatureSubpacketsUtil.getIntendedRecipientFingerprints((PGPSignature)signature);
        Assertions.assertEquals((int)2, (int)intendedRecipientFingerprints.size());
        Assertions.assertArrayEquals((byte[])secretKeys.getPublicKey().getFingerprint(), (byte[])((IntendedRecipientFingerprint)intendedRecipientFingerprints.get(0)).getFingerprint());
        Assertions.assertArrayEquals((byte[])TestKeys.getCryptiePublicKeyRing().getPublicKey().getFingerprint(), (byte[])((IntendedRecipientFingerprint)intendedRecipientFingerprints.get(1)).getFingerprint());
    }

    @Test
    public void testGetExportableCertification() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator hashed = new PGPSignatureSubpacketGenerator();
        hashed.setExportable(true, true);
        generator.setHashedSubpackets(hashed.generate());
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        Exportable exportable = SignatureSubpacketsUtil.getExportableCertification((PGPSignature)signature);
        Assertions.assertNotNull((Object)exportable);
        Assertions.assertTrue((boolean)exportable.isExportable());
    }

    @Test
    public void testGetTrustSignature() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPrivateKey certKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKeys.getSecretKey(), (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = this.getSignatureGenerator(certKey, SignatureType.CASUAL_CERTIFICATION);
        PGPSignatureSubpacketGenerator hashed = new PGPSignatureSubpacketGenerator();
        hashed.setTrust(true, 10, 3);
        generator.setHashedSubpackets(hashed.generate());
        PGPSignature signature = generator.generateCertification(secretKeys.getPublicKey());
        TrustSignature trustSignature = SignatureSubpacketsUtil.getTrustSignature((PGPSignature)signature);
        Assertions.assertEquals((int)10, (int)trustSignature.getDepth());
        Assertions.assertEquals((int)3, (int)trustSignature.getTrustAmount());
    }

    private PGPSignatureGenerator getSignatureGenerator(PGPPrivateKey signingKey, SignatureType signatureType) throws PGPException {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(ImplementationFactory.getInstance().getPGPContentSignerBuilder(signingKey.getPublicKeyPacket().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId()));
        signatureGenerator.init(signatureType.getCode(), signingKey);
        return signatureGenerator;
    }
}

