/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.consumer.ProofUtil;

public class ProofUtilTest {
    @Test
    public void testEmptyProofThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ProofUtil.Proof(""));
    }

    @Test
    public void testNullProofThrows() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ProofUtil.Proof(null));
    }

    @Test
    public void proofIsTrimmed() {
        ProofUtil.Proof proof = new ProofUtil.Proof("    foo:bar ");
        Assertions.assertEquals((Object)"proof@metacode.biz=foo:bar", (Object)proof.toString());
    }

    @Test
    public void testMatrixProof() {
        String matrixUser = "@foo:matrix.org";
        String permalink = "https://matrix.to/#/!dBfQZxCoGVmSTujfiv:matrix.org/$3dVX1nv3lmwnKxc0mgto_Sf-REVr45Z6G7LWLWal10w?via=chat.matrix.org";
        ProofUtil.Proof proof = ProofUtil.Proof.fromMatrixPermalink((String)matrixUser, (String)permalink);
        Assertions.assertEquals((Object)"proof@metacode.biz=matrix:u/@foo:matrix.org?org.keyoxide.r=!dBfQZxCoGVmSTujfiv:matrix.org&org.keyoxide.e=$3dVX1nv3lmwnKxc0mgto_Sf-REVr45Z6G7LWLWal10w", (Object)proof.toString());
    }

    @Test
    public void testXmppBasicProof() {
        String jid = "alice@pgpainless.org";
        ProofUtil.Proof proof = new ProofUtil.Proof("xmpp:" + jid);
        Assertions.assertEquals((Object)"proof@metacode.biz=xmpp:alice@pgpainless.org", (Object)proof.toString());
    }

    @Test
    public void testAddProof() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, InterruptedException {
        String userId = "Alice <alice@pgpainless.org>";
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing(userId, null);
        Thread.sleep(1000L);
        secretKey = new ProofUtil().addProof(secretKey, SecretKeyRingProtector.unprotectedKeys(), new ProofUtil.Proof("xmpp:alice@pgpainless.org"));
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKey);
        PGPSignature signature = info.getLatestUserIdCertification(userId);
        Assertions.assertNotNull((Object)signature);
        Assertions.assertFalse((boolean)ProofUtil.getProofs((PGPSignature)signature).isEmpty());
    }
}

