/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;

public class UnlockSecretKeys {
    @Test
    public void unlockUnprotectedKeys() throws PGPException, IOException {
        PGPSecretKeyRing unprotectedKey = TestKeys.getJulietSecretKeyRing();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        this.assertProtectorUnlocksAllSecretKeys(unprotectedKey, protector);
    }

    @Test
    public void unlockWholeKeyWithSamePassphrase() throws PGPException, IOException {
        PGPSecretKeyRing secretKey = TestKeys.getCryptieSecretKeyRing();
        Passphrase passphrase = TestKeys.CRYPTIE_PASSPHRASE;
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockAnyKeyWith((Passphrase)passphrase);
        this.assertProtectorUnlocksAllSecretKeys(secretKey, protector);
    }

    @Test
    public void unlockWithPerSubkeyPassphrases() throws PGPException, IOException {
        String pgpPrivateKeyBlock = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 4F28 5D16 A201 21BB 5B89  E76E 5D71 171E 059A 1D2F\nComment: alice@pgpainless.org\n\nlIYEYNc8xhYJKwYBBAHaRw8BAQdAQiDSNqkU4b4TmdacOxi9mfw06pI23NNiTj/C\nK1P+Q0/+CQMCm+6zb2ORC8BgHltvucr4KKx7QZdO5jIDWDZe1DjeS2JsJXoqOMeK\nyjxB8aVoSZTmsAm1KMbeDWcqtsltgm+DipRUyWFxeYOoj+CugJ42GbQUYWxpY2VA\ncGdwYWlubGVzcy5vcmeIeAQTFgoAIAUCYNc8xgIbAQUWAgMBAAQLCQgHBRUKCQgL\nAh4BAhkBAAoJEF1xFx4Fmh0viTEBAJmfpCJsVi7BzMh2iP6ecWZSRYtgqAhKjGTT\n4i9IKgIUAP47SbJr4qexi3jWj9W9ng//+CKEQ857Up6iSR6u+3poApyLBGDXPMYS\nCisGAQQBl1UBBQEBB0BUfOJMRcgWdPeyEz2kL79JfhckuDRAwZJyGd8mcFBofQMB\nCAf+CQMCKdEpNMEpflBguXamH33Vhx2tr3iYleiWI0VfhPrQledNzJ1uCHFH5q+k\nUnALeSCLJXIekPl3q1ux9C2MQkD/X4+mHh+fE4gSd1G5nd3oh4h1BBgWCgAdBQJg\n1zzGAhsMBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQXXEXHgWaHS/8DgD/Qnpe5g6C\nWHeXvgg06PJR7HRPkpE5NSnqEWP9X0tPe2EBAIdTiDozZ7HL6NVI89MnLBkw+524\ny5YzlNpQn4Al3tMCnIYEYNc8xhYJKwYBBAHaRw8BAQdAXdTUv2F0XGfi4qFnIPrL\nYbOpEZIWYjGVf5Ggbs9OBrb+CQMClCGIqeO7yJlgR9z490pJUD4al/ATofqGPPqx\nVsTz4gl1IkkWKQn7GJv2AYn09jZgnWm2a7u16cS6HZLJjRl2XvMzMQp3dRsOPHTP\nnulJ7YjVBBgWCgB9BQJg1zzGAhsCBRYCAwEABAsJCAcFFQoJCAsCHgFfIAQZFgoA\nBgUCYNc8xgAKCRD2BAJwjnXZQQLiAQCJGx9PF5ywwE93nMu8nZrhgDtl/eiCsryM\nqjDfY5XyCgEAim9m50QU9I9gAzBgLeH2NSJhlHYZZ2LKsRE02tGvXQMACgkQXXEX\nHgWaHS806AD+KUmSoKja11wJqCMVhYSU2IMGdGYEwa7Dqpbhyzu/LtAA/jmF10Ss\nUPPI6jsYqxEHzRGex8t971atnDAjvDiS31YN\n=fTmB\n-----END PGP PRIVATE KEY BLOCK-----";
        PGPSecretKeyRing secretKey = PGPainless.readKeyRing().secretKeyRing(pgpPrivateKeyBlock);
        CachingSecretKeyRingProtector protector = SecretKeyRingProtector.defaultSecretKeyRingProtector(null);
        protector.addPassphrase(secretKey.getPublicKey(), Passphrase.fromPassword((String)"pr1maryK3y"));
        protector.addPassphrase(Long.valueOf(3907509425258753406L), Passphrase.fromPassword((String)"f1rs7subk3y"));
        protector.addPassphrase((OpenPgpFingerprint)new OpenPgpV4Fingerprint("DD8E1195E4B1720E7FB10EF7F60402708E75D941"), Passphrase.fromPassword((String)"s3c0ndsubk3y"));
        this.assertProtectorUnlocksAllSecretKeys(secretKey, (SecretKeyRingProtector)protector);
    }

    private void assertProtectorUnlocksAllSecretKeys(PGPSecretKeyRing secretKey, SecretKeyRingProtector protector) throws PGPException {
        for (PGPSecretKey key : secretKey) {
            UnlockSecretKey.unlockSecretKey((PGPSecretKey)key, (SecretKeyRingProtector)protector);
        }
    }
}

