/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;

public class OpenPgpV4FingerprintTest {
    @Test
    public void fpTooShort() {
        String fp = "484f57414c495645";
        Assertions.assertThrows(IllegalArgumentException.class, () -> new OpenPgpV4Fingerprint(fp));
    }

    @Test
    public void invalidHexTest() {
        String fp = "UNFORTUNATELYTHISISNOVALIDHEXADECIMALDOH";
        Assertions.assertThrows(IllegalArgumentException.class, () -> new OpenPgpV4Fingerprint(fp));
    }

    @Test
    public void validFingerprintTest() {
        String fp = "4A4F48414E4E53454E2049532041204E45524421";
        OpenPgpV4Fingerprint finger = new OpenPgpV4Fingerprint(fp);
        Assertions.assertEquals((Object)fp, (Object)finger.toString());
        Assertions.assertEquals((int)fp.length(), (int)finger.length());
        for (int i = 0; i < finger.length(); ++i) {
            Assertions.assertEquals((char)fp.charAt(i), (char)finger.charAt(i));
        }
        Assertions.assertEquals((Object)"4A4F", (Object)finger.subSequence(0, 4));
    }

    @Test
    public void convertsToUpperCaseTest() {
        String fp = "444f4e5420552048415645204120484f4242593f";
        OpenPgpV4Fingerprint finger = new OpenPgpV4Fingerprint(fp);
        Assertions.assertEquals((Object)"444F4E5420552048415645204120484F4242593F", (Object)finger.toString());
    }

    @Test
    public void equalsOtherFingerprintTest() {
        OpenPgpV4Fingerprint finger = new OpenPgpV4Fingerprint("5448452043414b452049532041204c4945212121");
        Assertions.assertEquals((Object)finger, (Object)new OpenPgpV4Fingerprint("5448452043414B452049532041204C4945212121"));
        Assertions.assertEquals((int)0, (int)finger.compareTo((OpenPgpFingerprint)new OpenPgpV4Fingerprint("5448452043414B452049532041204C4945212121")));
        Assertions.assertNotEquals((Object)finger, (Object)new OpenPgpV4Fingerprint("0000000000000000000000000000000000000000"));
        Assertions.assertNotEquals((Object)finger, null);
        Assertions.assertNotEquals((Object)finger, (Object)new Object());
    }

    @Test
    public void assertFingerprintGetKeyIdEqualsKeyId() throws IOException {
        PGPPublicKey key = TestKeys.getJulietPublicKeyRing().getPublicKey();
        long keyId = key.getKeyID();
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(key);
        Assertions.assertEquals((long)keyId, (long)fingerprint.getKeyId());
    }

    @Test
    public void testToUri() {
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint("5448452043414B452049532041204C4945212121");
        URI uri = fingerprint.toUri();
        Assertions.assertEquals((Object)"openpgp4fpr:5448452043414B452049532041204C4945212121", (Object)uri.toString());
        OpenPgpV4Fingerprint parsed = OpenPgpV4Fingerprint.fromUri((URI)uri);
        Assertions.assertEquals((Object)fingerprint, (Object)parsed);
    }

    @Test
    public void testFromUriThrowsIfWrongScheme() throws URISyntaxException {
        URI uri = new URI(null, "5448452043414B452049532041204C4945212121", null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> OpenPgpV4Fingerprint.fromUri((URI)uri));
    }

    @Test
    public void testFromPrettyPrinted() {
        String prettyPrint = "C94B 884B 9A56 7B1C FB23  6999 7DC5 BDAC BBDF BF87";
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(prettyPrint);
        Assertions.assertEquals((Object)prettyPrint, (Object)fingerprint.prettyPrint());
    }
}

