/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.ThirdPartyCertificationSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.CertificationSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public class ThirdPartyCertificationSignatureBuilderTest {
    @Test
    public void testInvalidSignatureTypeThrows() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ThirdPartyCertificationSignatureBuilder(SignatureType.BINARY_DOCUMENT, secretKeys.getSecretKey(), SecretKeyRingProtector.unprotectedKeys()));
    }

    @Test
    public void testUserIdCertification() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
        PGPPublicKeyRing bobsPublicKeys = PGPainless.extractCertificate((PGPSecretKeyRing)PGPainless.generateKeyRing().modernKeyRing("Bob", null));
        ThirdPartyCertificationSignatureBuilder signatureBuilder = new ThirdPartyCertificationSignatureBuilder(secretKeys.getSecretKey(), SecretKeyRingProtector.unprotectedKeys());
        signatureBuilder.applyCallback(new CertificationSubpackets.Callback(){

            public void modifyHashedSubpackets(BaseSignatureSubpackets hashedSubpackets) {
                hashedSubpackets.setExportable(true, false);
            }
        });
        PGPSignature certification = signatureBuilder.build(bobsPublicKeys, "Bob");
        Assertions.assertEquals((Object)SignatureType.GENERIC_CERTIFICATION, (Object)SignatureType.valueOf((int)certification.getSignatureType()));
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)certification.getKeyID());
        Assertions.assertArrayEquals((byte[])secretKeys.getPublicKey().getFingerprint(), (byte[])certification.getHashedSubPackets().getIssuerFingerprint().getFingerprint());
        Assertions.assertFalse((boolean)SignatureSubpacketsUtil.getExportableCertification((PGPSignature)certification).isExportable());
        certification.init(ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider(), secretKeys.getPublicKey());
        Assertions.assertTrue((boolean)certification.verifyCertification("Bob", bobsPublicKeys.getPublicKey()));
    }
}

