/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.IntegrityProtectedInputStream;
import org.pgpainless.decryption_verification.MissingKeyPassphraseStrategy;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.SignatureInputStream;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.MessageNotIntegrityProtectedException;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.exception.MissingLiteralDataException;
import org.pgpainless.exception.MissingPassphraseException;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.exception.UnacceptableAlgorithmException;
import org.pgpainless.exception.WrongConsumingMethodException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.consumer.DetachedSignatureCheck;
import org.pgpainless.signature.consumer.OnePassSignatureCheck;
import org.pgpainless.util.CRCingArmoredInputStreamWrapper;
import org.pgpainless.util.PGPUtilWrapper;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.SessionKey;
import org.pgpainless.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecryptionStreamFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecryptionStreamFactory.class);
    private static final int MAX_PACKET_NESTING_DEPTH = 16;
    private final ConsumerOptions options;
    private final OpenPgpMetadata.Builder resultBuilder = OpenPgpMetadata.getBuilder();
    private final List<OnePassSignatureCheck> onePassSignatureChecks = new ArrayList<OnePassSignatureCheck>();
    private final List<DetachedSignatureCheck> detachedSignatureChecks = new ArrayList<DetachedSignatureCheck>();
    private final Map<Long, OnePassSignatureCheck> onePassSignaturesWithMissingCert = new HashMap<Long, OnePassSignatureCheck>();
    private static final PGPContentVerifierBuilderProvider verifierBuilderProvider = ImplementationFactory.getInstance().getPGPContentVerifierBuilderProvider();
    private IntegrityProtectedInputStream integrityProtectedEncryptedInputStream;

    public static DecryptionStream create(@Nonnull InputStream inputStream, @Nonnull ConsumerOptions options) throws PGPException, IOException {
        DecryptionStreamFactory factory = new DecryptionStreamFactory(options);
        return factory.parseOpenPGPDataAndCreateDecryptionStream(inputStream);
    }

    public DecryptionStreamFactory(ConsumerOptions options) {
        this.options = options;
        this.initializeDetachedSignatures(options.getDetachedSignatures());
    }

    private void initializeDetachedSignatures(Set<PGPSignature> signatures) {
        for (PGPSignature signature : signatures) {
            long issuerKeyId = SignatureUtils.determineIssuerKeyId(signature);
            PGPPublicKeyRing signingKeyRing = this.findSignatureVerificationKeyRing(issuerKeyId);
            if (signingKeyRing == null) {
                SignatureValidationException ex = new SignatureValidationException("Missing verification certificate " + Long.toHexString(issuerKeyId));
                this.resultBuilder.addInvalidDetachedSignature(new SignatureVerification(signature, null), ex);
                continue;
            }
            PGPPublicKey signingKey = signingKeyRing.getPublicKey(issuerKeyId);
            SubkeyIdentifier signingKeyIdentifier = new SubkeyIdentifier((PGPKeyRing)signingKeyRing, signingKey.getKeyID());
            try {
                signature.init(verifierBuilderProvider, signingKey);
                DetachedSignatureCheck detachedSignature = new DetachedSignatureCheck(signature, (PGPKeyRing)signingKeyRing, signingKeyIdentifier);
                this.detachedSignatureChecks.add(detachedSignature);
            }
            catch (PGPException e) {
                SignatureValidationException ex = new SignatureValidationException("Cannot verify detached signature made by " + signingKeyIdentifier + ".", (Exception)((Object)e));
                this.resultBuilder.addInvalidDetachedSignature(new SignatureVerification(signature, signingKeyIdentifier), ex);
            }
        }
    }

    private DecryptionStream parseOpenPGPDataAndCreateDecryptionStream(InputStream inputStream) throws IOException, PGPException {
        InputStream decoderStream;
        BufferedInputStream bufferedIn = new BufferedInputStream(inputStream, 512);
        bufferedIn.mark(512);
        if (this.options.isCleartextSigned()) {
            inputStream = this.wrapInVerifySignatureStream(bufferedIn, null);
            return new DecryptionStream(inputStream, this.resultBuilder, this.integrityProtectedEncryptedInputStream, null);
        }
        try {
            ArmoredInputStream armor;
            decoderStream = PGPUtilWrapper.getDecoderStream(bufferedIn);
            decoderStream = CRCingArmoredInputStreamWrapper.possiblyWrap(decoderStream);
            if (decoderStream instanceof ArmoredInputStream && (armor = (ArmoredInputStream)decoderStream).isClearText()) {
                throw new WrongConsumingMethodException("Message appears to be using the Cleartext Signature Framework. Use PGPainless.verifyCleartextSignedMessage() to verify this message instead.");
            }
            PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(decoderStream);
            inputStream = this.processPGPPackets(objectFactory, 1);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (MissingLiteralDataException e) {
            LOGGER.debug("The message appears to not be an OpenPGP message. This is probably data signed with detached signatures?");
            bufferedIn.reset();
            decoderStream = bufferedIn;
            PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(decoderStream);
            inputStream = this.wrapInVerifySignatureStream(bufferedIn, objectFactory);
        }
        catch (IOException e) {
            if (e.getMessage().contains("invalid armor") || e.getMessage().contains("invalid header encountered")) {
                LOGGER.debug("The message is apparently not armored.");
                bufferedIn.reset();
                decoderStream = bufferedIn;
                PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(decoderStream);
                inputStream = this.wrapInVerifySignatureStream(bufferedIn, objectFactory);
            }
            throw e;
        }
        return new DecryptionStream(inputStream, this.resultBuilder, this.integrityProtectedEncryptedInputStream, decoderStream instanceof ArmoredInputStream ? decoderStream : null);
    }

    private InputStream wrapInVerifySignatureStream(InputStream bufferedIn, @Nullable PGPObjectFactory objectFactory) {
        return new SignatureInputStream.VerifySignatures(bufferedIn, objectFactory, this.onePassSignatureChecks, this.onePassSignaturesWithMissingCert, this.detachedSignatureChecks, this.options, this.resultBuilder);
    }

    private InputStream processPGPPackets(@Nonnull PGPObjectFactory objectFactory, int depth) throws IOException, PGPException {
        Object nextPgpObject;
        if (depth >= 16) {
            throw new PGPException("Maximum depth of nested packages exceeded.");
        }
        while ((nextPgpObject = objectFactory.nextObject()) != null) {
            if (nextPgpObject instanceof PGPEncryptedDataList) {
                return this.processPGPEncryptedDataList((PGPEncryptedDataList)nextPgpObject, depth);
            }
            if (nextPgpObject instanceof PGPCompressedData) {
                return this.processPGPCompressedData((PGPCompressedData)nextPgpObject, depth);
            }
            if (nextPgpObject instanceof PGPOnePassSignatureList) {
                return this.processOnePassSignatureList(objectFactory, (PGPOnePassSignatureList)nextPgpObject, depth);
            }
            if (!(nextPgpObject instanceof PGPLiteralData)) continue;
            return this.processPGPLiteralData(objectFactory, (PGPLiteralData)nextPgpObject, depth);
        }
        throw new MissingLiteralDataException("No Literal Data Packet found");
    }

    private InputStream processPGPEncryptedDataList(PGPEncryptedDataList pgpEncryptedDataList, int depth) throws PGPException, IOException {
        LOGGER.debug("Depth {}: Encountered PGPEncryptedDataList", (Object)depth);
        SessionKey sessionKey = this.options.getSessionKey();
        if (sessionKey != null) {
            this.integrityProtectedEncryptedInputStream = this.decryptWithProvidedSessionKey(pgpEncryptedDataList, sessionKey);
            InputStream decodedDataStream = PGPUtil.getDecoderStream((InputStream)this.integrityProtectedEncryptedInputStream);
            PGPObjectFactory factory = ImplementationFactory.getInstance().getPGPObjectFactory(decodedDataStream);
            return this.processPGPPackets(factory, ++depth);
        }
        InputStream decryptedDataStream = this.decryptSessionKey(pgpEncryptedDataList);
        InputStream decodedDataStream = PGPUtil.getDecoderStream((InputStream)decryptedDataStream);
        PGPObjectFactory factory = ImplementationFactory.getInstance().getPGPObjectFactory(decodedDataStream);
        return this.processPGPPackets(factory, ++depth);
    }

    private IntegrityProtectedInputStream decryptWithProvidedSessionKey(PGPEncryptedDataList pgpEncryptedDataList, SessionKey sessionKey) throws PGPException {
        PGPSessionKey pgpSessionKey = new PGPSessionKey(sessionKey.getAlgorithm().getAlgorithmId(), sessionKey.getKey());
        SessionKeyDataDecryptorFactory decryptorFactory = ImplementationFactory.getInstance().provideSessionKeyDataDecryptorFactory(pgpSessionKey);
        InputStream decryptedDataStream = null;
        PGPEncryptedData encryptedData = null;
        Iterator iterator = pgpEncryptedDataList.iterator();
        while (iterator.hasNext()) {
            PGPEncryptedData pgpEncryptedData;
            encryptedData = pgpEncryptedData = (PGPEncryptedData)iterator.next();
            if (!this.options.isIgnoreMDCErrors() && !encryptedData.isIntegrityProtected()) {
                throw new MessageNotIntegrityProtectedException();
            }
            if (encryptedData instanceof PGPPBEEncryptedData) {
                PGPPBEEncryptedData pbeEncrypted = (PGPPBEEncryptedData)encryptedData;
                decryptedDataStream = pbeEncrypted.getDataStream(decryptorFactory);
                break;
            }
            if (!(encryptedData instanceof PGPPublicKeyEncryptedData)) continue;
            PGPPublicKeyEncryptedData pkEncrypted = (PGPPublicKeyEncryptedData)encryptedData;
            decryptedDataStream = pkEncrypted.getDataStream(decryptorFactory);
            break;
        }
        if (decryptedDataStream == null) {
            throw new PGPException("No valid PGP data encountered.");
        }
        this.resultBuilder.setSessionKey(sessionKey);
        this.throwIfAlgorithmIsRejected(sessionKey.getAlgorithm());
        this.integrityProtectedEncryptedInputStream = new IntegrityProtectedInputStream(decryptedDataStream, encryptedData, this.options);
        return this.integrityProtectedEncryptedInputStream;
    }

    private InputStream processPGPCompressedData(PGPCompressedData pgpCompressedData, int depth) throws PGPException, IOException {
        CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.fromId(pgpCompressedData.getAlgorithm());
        LOGGER.debug("Depth {}: Encountered PGPCompressedData: {}", (Object)depth, (Object)compressionAlgorithm);
        this.resultBuilder.setCompressionAlgorithm(compressionAlgorithm);
        InputStream inflatedDataStream = pgpCompressedData.getDataStream();
        InputStream decodedDataStream = PGPUtil.getDecoderStream((InputStream)inflatedDataStream);
        PGPObjectFactory objectFactory = ImplementationFactory.getInstance().getPGPObjectFactory(decodedDataStream);
        return this.processPGPPackets(objectFactory, ++depth);
    }

    private InputStream processOnePassSignatureList(@Nonnull PGPObjectFactory objectFactory, PGPOnePassSignatureList onePassSignatures, int depth) throws PGPException, IOException {
        LOGGER.debug("Depth {}: Encountered PGPOnePassSignatureList of size {}", (Object)depth, (Object)onePassSignatures.size());
        this.initOnePassSignatures(onePassSignatures);
        return this.processPGPPackets(objectFactory, depth);
    }

    private InputStream processPGPLiteralData(@Nonnull PGPObjectFactory objectFactory, PGPLiteralData pgpLiteralData, int depth) {
        LOGGER.debug("Depth {}: Found PGPLiteralData", (Object)depth);
        InputStream literalDataInputStream = pgpLiteralData.getInputStream();
        this.resultBuilder.setFileName(pgpLiteralData.getFileName()).setModificationDate(pgpLiteralData.getModificationTime()).setFileEncoding(StreamEncoding.fromCode(pgpLiteralData.getFormat()));
        if (this.onePassSignatureChecks.isEmpty() && this.onePassSignaturesWithMissingCert.isEmpty()) {
            LOGGER.debug("No OnePassSignatures found -> We are done");
            return literalDataInputStream;
        }
        return new SignatureInputStream.VerifySignatures(literalDataInputStream, objectFactory, this.onePassSignatureChecks, this.onePassSignaturesWithMissingCert, this.detachedSignatureChecks, this.options, this.resultBuilder){};
    }

    /*
     * WARNING - void declaration
     */
    private InputStream decryptSessionKey(@Nonnull PGPEncryptedDataList encryptedDataList) throws PGPException {
        Iterator encryptedDataIterator = encryptedDataList.getEncryptedDataObjects();
        if (!encryptedDataIterator.hasNext()) {
            throw new PGPException("Decryption failed - EncryptedDataList has no items");
        }
        PGPPrivateKey decryptionKey = null;
        PGPPublicKeyEncryptedData encryptedSessionKey = null;
        ArrayList<PGPPBEEncryptedData> passphraseProtected = new ArrayList<PGPPBEEncryptedData>();
        ArrayList<PGPPublicKeyEncryptedData> publicKeyProtected = new ArrayList<PGPPublicKeyEncryptedData>();
        ArrayList<Tuple<SubkeyIdentifier, PGPPublicKeyEncryptedData>> postponedDueToMissingPassphrase = new ArrayList<Tuple<SubkeyIdentifier, PGPPublicKeyEncryptedData>>();
        while (encryptedDataIterator.hasNext()) {
            PGPEncryptedData encryptedData = (PGPEncryptedData)encryptedDataIterator.next();
            if (!encryptedData.isIntegrityProtected() && !this.options.isIgnoreMDCErrors()) {
                throw new MessageNotIntegrityProtectedException();
            }
            if (encryptedData instanceof PGPPBEEncryptedData) {
                passphraseProtected.add((PGPPBEEncryptedData)encryptedData);
                continue;
            }
            if (!(encryptedData instanceof PGPPublicKeyEncryptedData)) continue;
            publicKeyProtected.add((PGPPublicKeyEncryptedData)encryptedData);
        }
        for (PGPPBEEncryptedData pGPPBEEncryptedData : passphraseProtected) {
            for (Passphrase passphrase : this.options.getDecryptionPassphrases()) {
                PBEDataDecryptorFactory passphraseDecryptor = ImplementationFactory.getInstance().getPBEDataDecryptorFactory(passphrase);
                try {
                    InputStream decryptedDataStream = pGPPBEEncryptedData.getDataStream(passphraseDecryptor);
                    PGPSessionKey pgpSessionKey = pGPPBEEncryptedData.getSessionKey(passphraseDecryptor);
                    SessionKey sessionKey = new SessionKey(pgpSessionKey);
                    this.resultBuilder.setSessionKey(sessionKey);
                    this.throwIfAlgorithmIsRejected(sessionKey.getAlgorithm());
                    this.integrityProtectedEncryptedInputStream = new IntegrityProtectedInputStream(decryptedDataStream, (PGPEncryptedData)pGPPBEEncryptedData, this.options);
                    return this.integrityProtectedEncryptedInputStream;
                }
                catch (PGPException e) {
                    LOGGER.debug("Probable passphrase mismatch, skip PBE encrypted data block", (Throwable)e);
                }
            }
        }
        for (PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData : publicKeyProtected) {
            void var10_21;
            Object var10_17 = null;
            if (this.options.getDecryptionKeys().isEmpty()) break;
            long keyId = pGPPublicKeyEncryptedData.getKeyID();
            if (keyId == 0L) {
                LOGGER.debug("Hidden recipient detected. Try to decrypt with all available secret keys.");
                for (PGPSecretKeyRing secretKeys : this.options.getDecryptionKeys()) {
                    void var10_18;
                    if (var10_18 == null) {
                        KeyRingInfo info = new KeyRingInfo((PGPKeyRing)secretKeys);
                        List<PGPPublicKey> encryptionSubkeys = info.getEncryptionSubkeys(EncryptionPurpose.ANY);
                        for (PGPPublicKey pubkey : encryptionSubkeys) {
                            PGPSecretKey secretKey = secretKeys.getSecretKey(pubkey.getKeyID());
                            if (secretKey == null) continue;
                            PGPPrivateKey pGPPrivateKey = this.tryPublicKeyDecryption(secretKeys, secretKey, pGPPublicKeyEncryptedData, postponedDueToMissingPassphrase, true);
                        }
                        continue;
                    }
                    break;
                }
            } else {
                LOGGER.debug("PGPEncryptedData is encrypted for key {}", (Object)Long.toHexString(keyId));
                this.resultBuilder.addRecipientKeyId(keyId);
                PGPSecretKeyRing secretKeys = this.findDecryptionKeyRing(keyId);
                if (secretKeys == null) {
                    LOGGER.debug("Missing certificate of {}. Skip.", (Object)Long.toHexString(keyId));
                    continue;
                }
                KeyRingInfo info = new KeyRingInfo((PGPKeyRing)secretKeys);
                List<PGPPublicKey> encryptionSubkeys = info.getEncryptionSubkeys(EncryptionPurpose.ANY);
                PGPSecretKey secretKey = null;
                for (PGPPublicKey pubkey : encryptionSubkeys) {
                    if (pubkey.getKeyID() != keyId) continue;
                    secretKey = secretKeys.getSecretKey(keyId);
                    break;
                }
                if (secretKey == null) {
                    LOGGER.debug("Key " + Long.toHexString(keyId) + " is not valid or not capable for decryption.");
                } else {
                    PGPPrivateKey pGPPrivateKey = this.tryPublicKeyDecryption(secretKeys, secretKey, pGPPublicKeyEncryptedData, postponedDueToMissingPassphrase, true);
                }
            }
            if (var10_21 == null) continue;
            decryptionKey = var10_21;
            encryptedSessionKey = pGPPublicKeyEncryptedData;
            break;
        }
        if (encryptedSessionKey == null) {
            if (this.options.getMissingKeyPassphraseStrategy() == MissingKeyPassphraseStrategy.THROW_EXCEPTION) {
                HashSet<SubkeyIdentifier> keyIds = new HashSet<SubkeyIdentifier>();
                for (Tuple tuple : postponedDueToMissingPassphrase) {
                    keyIds.add((SubkeyIdentifier)tuple.getA());
                }
                if (!keyIds.isEmpty()) {
                    throw new MissingPassphraseException(keyIds);
                }
            } else if (this.options.getMissingKeyPassphraseStrategy() == MissingKeyPassphraseStrategy.INTERACTIVE) {
                for (Tuple tuple : postponedDueToMissingPassphrase) {
                    PGPSecretKey secretKey;
                    SubkeyIdentifier subkeyIdentifier = (SubkeyIdentifier)tuple.getA();
                    PGPPublicKeyEncryptedData publicKeyEncryptedData = (PGPPublicKeyEncryptedData)tuple.getB();
                    PGPSecretKeyRing secretKeys = this.findDecryptionKeyRing(subkeyIdentifier.getKeyId());
                    PGPPrivateKey privateKey = this.tryPublicKeyDecryption(secretKeys, secretKey = secretKeys.getSecretKey(subkeyIdentifier.getSubkeyId()), publicKeyEncryptedData, postponedDueToMissingPassphrase, false);
                    if (privateKey == null) continue;
                    decryptionKey = privateKey;
                    encryptedSessionKey = publicKeyEncryptedData;
                    break;
                }
            } else {
                throw new IllegalStateException("Invalid PostponedKeysStrategy set in consumer options.");
            }
        }
        return this.decryptWith(encryptedSessionKey, decryptionKey);
    }

    private PGPPrivateKey tryPublicKeyDecryption(PGPSecretKeyRing secretKeys, PGPSecretKey secretKey, PGPPublicKeyEncryptedData publicKeyEncryptedData, List<Tuple<SubkeyIdentifier, PGPPublicKeyEncryptedData>> postponed, boolean postponeIfMissingPassphrase) throws PGPException {
        SecretKeyRingProtector protector = this.options.getSecretKeyProtector(secretKeys);
        if (postponeIfMissingPassphrase && !protector.hasPassphraseFor(secretKey.getKeyID())) {
            SubkeyIdentifier identifier = new SubkeyIdentifier((PGPKeyRing)secretKeys, secretKey.getKeyID());
            postponed.add(new Tuple<SubkeyIdentifier, PGPPublicKeyEncryptedData>(identifier, publicKeyEncryptedData));
            return null;
        }
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey(secretKey, protector.getDecryptor(secretKey.getKeyID()));
        PublicKeyDataDecryptorFactory decryptorFactory = ImplementationFactory.getInstance().getPublicKeyDataDecryptorFactory(privateKey);
        try {
            publicKeyEncryptedData.getSymmetricAlgorithm(decryptorFactory);
            LOGGER.debug("Found correct decryption key {}.", (Object)Long.toHexString(secretKey.getKeyID()));
            this.resultBuilder.setDecryptionKey(new SubkeyIdentifier((PGPKeyRing)secretKeys, privateKey.getKeyID()));
            return privateKey;
        }
        catch (ClassCastException | PGPException e) {
            return null;
        }
    }

    private InputStream decryptWith(PGPPublicKeyEncryptedData encryptedSessionKey, PGPPrivateKey decryptionKey) throws PGPException {
        if (decryptionKey == null || encryptedSessionKey == null) {
            throw new MissingDecryptionMethodException("Decryption failed - No suitable decryption key or passphrase found");
        }
        PublicKeyDataDecryptorFactory dataDecryptor = ImplementationFactory.getInstance().getPublicKeyDataDecryptorFactory(decryptionKey);
        PGPSessionKey pgpSessionKey = encryptedSessionKey.getSessionKey(dataDecryptor);
        SessionKey sessionKey = new SessionKey(pgpSessionKey);
        this.resultBuilder.setSessionKey(sessionKey);
        SymmetricKeyAlgorithm symmetricKeyAlgorithm = sessionKey.getAlgorithm();
        if (symmetricKeyAlgorithm == SymmetricKeyAlgorithm.NULL) {
            LOGGER.debug("Message is unencrypted");
        } else {
            LOGGER.debug("Message is encrypted using {}", (Object)symmetricKeyAlgorithm);
        }
        this.throwIfAlgorithmIsRejected(symmetricKeyAlgorithm);
        this.integrityProtectedEncryptedInputStream = new IntegrityProtectedInputStream(encryptedSessionKey.getDataStream(dataDecryptor), (PGPEncryptedData)encryptedSessionKey, this.options);
        return this.integrityProtectedEncryptedInputStream;
    }

    private void throwIfAlgorithmIsRejected(SymmetricKeyAlgorithm algorithm) throws UnacceptableAlgorithmException {
        if (!PGPainless.getPolicy().getSymmetricKeyDecryptionAlgorithmPolicy().isAcceptable(algorithm)) {
            throw new UnacceptableAlgorithmException("Data is " + (algorithm == SymmetricKeyAlgorithm.NULL ? "unencrypted" : "encrypted with symmetric algorithm " + (Object)((Object)algorithm)) + " which is not acceptable as per PGPainless' policy.\nTo mark this algorithm as acceptable, use PGPainless.getPolicy().setSymmetricKeyDecryptionAlgorithmPolicy().");
        }
    }

    private void initOnePassSignatures(@Nonnull PGPOnePassSignatureList onePassSignatureList) throws PGPException {
        Iterator iterator = onePassSignatureList.iterator();
        if (!iterator.hasNext()) {
            throw new PGPException("Verification failed - No OnePassSignatures found");
        }
        this.processOnePassSignatures(iterator);
    }

    private void processOnePassSignatures(Iterator<PGPOnePassSignature> signatures) throws PGPException {
        while (signatures.hasNext()) {
            PGPOnePassSignature signature = signatures.next();
            this.processOnePassSignature(signature);
        }
    }

    private void processOnePassSignature(PGPOnePassSignature signature) throws PGPException {
        long keyId = signature.getKeyID();
        LOGGER.debug("Encountered OnePassSignature from {}", (Object)Long.toHexString(keyId));
        PGPPublicKeyRing verificationKeyRing = this.findSignatureVerificationKeyRing(keyId);
        if (verificationKeyRing == null) {
            this.onePassSignaturesWithMissingCert.put(keyId, new OnePassSignatureCheck(signature, null));
            return;
        }
        PGPPublicKey verificationKey = verificationKeyRing.getPublicKey(keyId);
        signature.init(verifierBuilderProvider, verificationKey);
        OnePassSignatureCheck onePassSignature = new OnePassSignatureCheck(signature, verificationKeyRing);
        this.onePassSignatureChecks.add(onePassSignature);
    }

    private PGPSecretKeyRing findDecryptionKeyRing(long keyId) {
        for (PGPSecretKeyRing key : this.options.getDecryptionKeys()) {
            if (key.getSecretKey(keyId) == null) continue;
            return key;
        }
        return null;
    }

    private PGPPublicKeyRing findSignatureVerificationKeyRing(long keyId) {
        PGPPublicKeyRing verificationKeyRing = null;
        for (PGPPublicKeyRing publicKeyRing : this.options.getCertificates()) {
            PGPPublicKey verificationKey = publicKeyRing.getPublicKey(keyId);
            if (verificationKey == null) continue;
            LOGGER.debug("Found public key {} for signature verification", (Object)Long.toHexString(keyId));
            verificationKeyRing = publicKeyRing;
            break;
        }
        if (verificationKeyRing == null && this.options.getMissingCertificateCallback() != null) {
            verificationKeyRing = this.options.getMissingCertificateCallback().onMissingPublicKeyEncountered(keyId);
        }
        return verificationKeyRing;
    }
}

