/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.consumer.SignatureCreationDateComparator;
import org.pgpainless.signature.consumer.SignatureVerifier;
import org.pgpainless.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyRingValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyRingValidator.class);

    private KeyRingValidator() {
    }

    public static <R extends PGPKeyRing> R validate(R keyRing, Policy policy) {
        try {
            return KeyRingValidator.validate(keyRing, policy, new Date());
        }
        catch (PGPException e) {
            return null;
        }
    }

    public static <R extends PGPKeyRing> R validate(R keyRing, Policy policy, Date validationDate) throws PGPException {
        return KeyRingValidator.getKeyRingAtDate(keyRing, policy, validationDate);
    }

    private static <R extends PGPKeyRing> R getKeyRingAtDate(R keyRing, Policy policy, Date validationDate) throws PGPException {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        primaryKey = KeyRingValidator.evaluatePrimaryKey(primaryKey, policy, validationDate);
        if (keyRing instanceof PGPPublicKeyRing) {
            PGPPublicKeyRing publicKeys = (PGPPublicKeyRing)keyRing;
            publicKeys = PGPPublicKeyRing.insertPublicKey((PGPPublicKeyRing)publicKeys, (PGPPublicKey)primaryKey);
            keyRing = publicKeys;
        }
        return keyRing;
    }

    private static PGPPublicKey evaluatePrimaryKey(PGPPublicKey primaryKey, Policy policy, Date validationDate) throws PGPException {
        PGPPublicKey blank = new PGPPublicKey(primaryKey.getPublicKeyPacket(), ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        Iterator directKeyIterator = primaryKey.getSignaturesOfType(SignatureType.DIRECT_KEY.getCode());
        List<PGPSignature> directKeyCertifications = CollectionUtils.iteratorToList(directKeyIterator);
        Collections.sort(directKeyCertifications, new SignatureCreationDateComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
        for (PGPSignature signature : directKeyCertifications) {
            try {
                if (!SignatureVerifier.verifyDirectKeySignature(signature, blank, policy, validationDate)) continue;
                blank = PGPPublicKey.addCertification((PGPPublicKey)blank, (PGPSignature)signature);
            }
            catch (SignatureValidationException e) {
                LOGGER.debug("Rejecting direct key signature: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        Iterator revocationIterator = primaryKey.getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode());
        List<PGPSignature> directKeyRevocations = CollectionUtils.iteratorToList(revocationIterator);
        Collections.sort(directKeyRevocations, new SignatureCreationDateComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
        for (PGPSignature signature : directKeyRevocations) {
            try {
                if (!SignatureVerifier.verifyKeyRevocationSignature(signature, primaryKey, policy, validationDate)) continue;
                blank = PGPPublicKey.addCertification((PGPPublicKey)blank, (PGPSignature)signature);
            }
            catch (SignatureValidationException e) {
                LOGGER.debug("Rejecting key revocation signature: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        Iterator userIdIterator = primaryKey.getUserIDs();
        while (userIdIterator.hasNext()) {
            String userId = (String)userIdIterator.next();
            Iterator userIdSigs = primaryKey.getSignaturesForID(userId);
            List<PGPSignature> signatures = CollectionUtils.iteratorToList(userIdSigs);
            Collections.sort(signatures, new SignatureCreationDateComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
            for (PGPSignature signature : signatures) {
                try {
                    if (SignatureType.valueOf(signature.getSignatureType()) == SignatureType.CERTIFICATION_REVOCATION) {
                        if (!SignatureVerifier.verifyUserIdRevocation(userId, signature, primaryKey, policy, validationDate)) continue;
                        blank = PGPPublicKey.addCertification((PGPPublicKey)blank, (String)userId, (PGPSignature)signature);
                        continue;
                    }
                    if (!SignatureVerifier.verifyUserIdCertification(userId, signature, primaryKey, policy, validationDate)) continue;
                    blank = PGPPublicKey.addCertification((PGPPublicKey)blank, (String)userId, (PGPSignature)signature);
                }
                catch (SignatureValidationException e) {
                    LOGGER.debug("Rejecting user-id certification for user-id {}: {}", new Object[]{userId, e.getMessage(), e});
                }
            }
        }
        Iterator userAttributes = primaryKey.getUserAttributes();
        while (userAttributes.hasNext()) {
            PGPUserAttributeSubpacketVector userAttribute = (PGPUserAttributeSubpacketVector)userAttributes.next();
            Iterator userAttributeSignatureIterator = primaryKey.getSignaturesForUserAttribute(userAttribute);
            while (userAttributeSignatureIterator.hasNext()) {
                PGPSignature signature = (PGPSignature)userAttributeSignatureIterator.next();
                try {
                    if (SignatureType.valueOf(signature.getSignatureType()) == SignatureType.CERTIFICATION_REVOCATION) {
                        if (!SignatureVerifier.verifyUserAttributesRevocation(userAttribute, signature, primaryKey, policy, validationDate)) continue;
                        blank = PGPPublicKey.addCertification((PGPPublicKey)blank, (PGPUserAttributeSubpacketVector)userAttribute, (PGPSignature)signature);
                        continue;
                    }
                    if (!SignatureVerifier.verifyUserAttributesCertification(userAttribute, signature, primaryKey, policy, validationDate)) continue;
                    blank = PGPPublicKey.addCertification((PGPPublicKey)blank, (PGPUserAttributeSubpacketVector)userAttribute, (PGPSignature)signature);
                }
                catch (SignatureValidationException e) {
                    LOGGER.debug("Rejecting user-attribute signature: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return blank;
    }
}

