/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public class SignedMessageVerificationWithoutCertIsStillSigned {
    private static final String message = "-----BEGIN PGP MESSAGE-----\n\nowGbwMvMwCGmFN+gfIiXM5zxtG4SQ2Iw74rgzPS81BSFktSKEoW0/CKFlNS0xNKc\nEoe0nPzy5KLKghK9ktTiEq6OXhYGMQ4GUzFFFtvXL7+VX9252+LpIheYcaxMQLMO\niMtg183AxSkAUynizshwbBMnx4e4tn6NgJYtG/od3HL1y26GvpgqUtr2o37HpC+v\nGRmudmly/g+Osdt3t6Rb+8t8i8Y94ZJ3P/zNlk015FihXM0JAA==\n=A8uF\n-----END PGP MESSAGE-----\n";

    @Test
    public void verifyMissingVerificationCertOptionStillResultsInMessageIsSigned() throws IOException, PGPException {
        ConsumerOptions withoutVerificationCert = new ConsumerOptions();
        DecryptionStream verificationStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8))).withOptions(withoutVerificationCert);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verificationStream, (OutputStream)out);
        verificationStream.close();
        OpenPgpMetadata metadata = verificationStream.getResult();
        Assertions.assertTrue((boolean)metadata.isSigned(), (String)"Message is signed, even though we miss the verification cert.");
        Assertions.assertFalse((boolean)metadata.isVerified(), (String)"Message is not verified because we lack the verification cert.");
    }
}

