/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.KeySpecBuilderInterface;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.CollectionUtils;

public class KeySpecBuilder
implements KeySpecBuilderInterface {
    private final KeyType type;
    private final KeyFlag[] keyFlags;
    private final SelfSignatureSubpackets hashedSubpackets = new SignatureSubpackets();
    private final AlgorithmSuite algorithmSuite = PGPainless.getPolicy().getKeyGenerationAlgorithmSuite();
    private Set<CompressionAlgorithm> preferredCompressionAlgorithms = this.algorithmSuite.getCompressionAlgorithms();
    private Set<HashAlgorithm> preferredHashAlgorithms = this.algorithmSuite.getHashAlgorithms();
    private Set<SymmetricKeyAlgorithm> preferredSymmetricAlgorithms = this.algorithmSuite.getSymmetricKeyAlgorithms();

    KeySpecBuilder(@Nonnull KeyType type, KeyFlag flag, KeyFlag ... flags) {
        if (flag == null) {
            throw new IllegalArgumentException("Key MUST carry at least one key flag");
        }
        if (flags == null) {
            throw new IllegalArgumentException("List of additional flags MUST NOT be null.");
        }
        flags = CollectionUtils.concat(flag, flags);
        SignatureSubpacketsUtil.assureKeyCanCarryFlags(type, flags);
        this.type = type;
        this.keyFlags = flags;
    }

    @Override
    public KeySpecBuilder overridePreferredCompressionAlgorithms(CompressionAlgorithm ... compressionAlgorithms) {
        this.preferredCompressionAlgorithms = new LinkedHashSet<CompressionAlgorithm>(Arrays.asList(compressionAlgorithms));
        return this;
    }

    @Override
    public KeySpecBuilder overridePreferredHashAlgorithms(HashAlgorithm ... preferredHashAlgorithms) {
        this.preferredHashAlgorithms = new LinkedHashSet<HashAlgorithm>(Arrays.asList(preferredHashAlgorithms));
        return this;
    }

    @Override
    public KeySpecBuilder overridePreferredSymmetricKeyAlgorithms(SymmetricKeyAlgorithm ... preferredSymmetricKeyAlgorithms) {
        this.preferredSymmetricAlgorithms = new LinkedHashSet<SymmetricKeyAlgorithm>(Arrays.asList(preferredSymmetricKeyAlgorithms));
        return this;
    }

    @Override
    public KeySpec build() {
        this.hashedSubpackets.setKeyFlags(this.keyFlags);
        this.hashedSubpackets.setPreferredCompressionAlgorithms(this.preferredCompressionAlgorithms);
        this.hashedSubpackets.setPreferredHashAlgorithms(this.preferredHashAlgorithms);
        this.hashedSubpackets.setPreferredSymmetricKeyAlgorithms(this.preferredSymmetricAlgorithms);
        this.hashedSubpackets.setFeatures(Feature.MODIFICATION_DETECTION);
        return new KeySpec(this.type, (SignatureSubpackets)this.hashedSubpackets, false);
    }
}

