/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.subpackets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.EmbeddedSignature;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.CertificationSubpackets;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

public class SignatureSubpackets
implements BaseSignatureSubpackets,
SelfSignatureSubpackets,
CertificationSubpackets,
RevocationSignatureSubpackets {
    private SignatureCreationTime signatureCreationTime;
    private SignatureExpirationTime signatureExpirationTime;
    private IssuerKeyID issuerKeyID;
    private IssuerFingerprint issuerFingerprint;
    private final List<NotationData> notationDataList = new ArrayList<NotationData>();
    private final List<IntendedRecipientFingerprint> intendedRecipientFingerprintList = new ArrayList<IntendedRecipientFingerprint>();
    private final List<RevocationKey> revocationKeyList = new ArrayList<RevocationKey>();
    private Exportable exportable;
    private SignatureTarget signatureTarget;
    private Features features;
    private KeyFlags keyFlags;
    private TrustSignature trust;
    private PreferredAlgorithms preferredCompressionAlgorithms;
    private PreferredAlgorithms preferredSymmetricKeyAlgorithms;
    private PreferredAlgorithms preferredHashAlgorithms;
    private final List<EmbeddedSignature> embeddedSignatureList = new ArrayList<EmbeddedSignature>();
    private SignerUserID signerUserId;
    private KeyExpirationTime keyExpirationTime;
    private PrimaryUserID primaryUserId;
    private Revocable revocable;
    private RevocationReason revocationReason;
    private final List<SignatureSubpacket> residualSubpackets = new ArrayList<SignatureSubpacket>();

    public static SignatureSubpackets refreshHashedSubpackets(PGPPublicKey issuer, PGPSignature oldSignature) {
        return SignatureSubpackets.createHashedSubpacketsFrom(issuer, oldSignature.getHashedSubPackets());
    }

    public static SignatureSubpackets refreshUnhashedSubpackets(PGPSignature oldSignature) {
        return SignatureSubpackets.createSubpacketsFrom(oldSignature.getUnhashedSubPackets());
    }

    public static SignatureSubpackets createHashedSubpacketsFrom(PGPPublicKey issuer, PGPSignatureSubpacketVector base) {
        SignatureSubpackets wrapper = SignatureSubpackets.createSubpacketsFrom(base);
        wrapper.setIssuerFingerprintAndKeyId(issuer);
        return wrapper;
    }

    public static SignatureSubpackets createSubpacketsFrom(PGPSignatureSubpacketVector base) {
        SignatureSubpackets wrapper = new SignatureSubpackets();
        SignatureSubpacketsHelper.applyFrom(base, wrapper);
        return wrapper;
    }

    public static SignatureSubpackets createHashedSubpackets(PGPPublicKey issuer) {
        SignatureSubpackets wrapper = new SignatureSubpackets();
        wrapper.setIssuerFingerprintAndKeyId(issuer);
        return wrapper;
    }

    public static SignatureSubpackets createEmptySubpackets() {
        return new SignatureSubpackets();
    }

    @Override
    public SignatureSubpackets setIssuerFingerprintAndKeyId(PGPPublicKey key) {
        this.setIssuerKeyId(key.getKeyID());
        this.setIssuerFingerprint(key);
        return this;
    }

    @Override
    public SignatureSubpackets setIssuerKeyId(long keyId) {
        return this.setIssuerKeyId(true, keyId);
    }

    @Override
    public SignatureSubpackets setIssuerKeyId(boolean isCritical, long keyId) {
        return this.setIssuerKeyId(new IssuerKeyID(isCritical, keyId));
    }

    @Override
    public SignatureSubpackets setIssuerKeyId(@Nullable IssuerKeyID issuerKeyID) {
        this.issuerKeyID = issuerKeyID;
        return this;
    }

    public IssuerKeyID getIssuerKeyIdSubpacket() {
        return this.issuerKeyID;
    }

    @Override
    public SignatureSubpackets setIssuerFingerprint(@Nonnull PGPPublicKey key) {
        return this.setIssuerFingerprint(true, key);
    }

    @Override
    public SignatureSubpackets setIssuerFingerprint(boolean isCritical, @Nonnull PGPPublicKey key) {
        return this.setIssuerFingerprint(new IssuerFingerprint(isCritical, key.getVersion(), key.getFingerprint()));
    }

    @Override
    public SignatureSubpackets setIssuerFingerprint(@Nullable IssuerFingerprint fingerprint) {
        this.issuerFingerprint = fingerprint;
        return this;
    }

    public IssuerFingerprint getIssuerFingerprintSubpacket() {
        return this.issuerFingerprint;
    }

    @Override
    public SignatureSubpackets setKeyFlags(KeyFlag ... keyFlags) {
        return this.setKeyFlags(true, keyFlags);
    }

    @Override
    public SignatureSubpackets setKeyFlags(boolean isCritical, KeyFlag ... keyFlags) {
        int bitmask = KeyFlag.toBitmask(keyFlags);
        return this.setKeyFlags(new KeyFlags(isCritical, bitmask));
    }

    @Override
    public SignatureSubpackets setKeyFlags(@Nullable KeyFlags keyFlags) {
        this.keyFlags = keyFlags;
        return this;
    }

    public KeyFlags getKeyFlagsSubpacket() {
        return this.keyFlags;
    }

    @Override
    public SignatureSubpackets setSignatureCreationTime(@Nonnull Date creationTime) {
        return this.setSignatureCreationTime(true, creationTime);
    }

    @Override
    public SignatureSubpackets setSignatureCreationTime(boolean isCritical, @Nonnull Date creationTime) {
        return this.setSignatureCreationTime(new SignatureCreationTime(isCritical, creationTime));
    }

    @Override
    public SignatureSubpackets setSignatureCreationTime(@Nullable SignatureCreationTime signatureCreationTime) {
        this.signatureCreationTime = signatureCreationTime;
        return this;
    }

    public SignatureCreationTime getSignatureCreationTimeSubpacket() {
        return this.signatureCreationTime;
    }

    @Override
    public SignatureSubpackets setSignatureExpirationTime(@Nonnull Date creationTime, @Nonnull Date expirationTime) {
        return this.setSignatureExpirationTime(true, creationTime, expirationTime);
    }

    @Override
    public SignatureSubpackets setSignatureExpirationTime(boolean isCritical, @Nonnull Date creationTime, @Nonnull Date expirationTime) {
        return this.setSignatureExpirationTime(isCritical, expirationTime.getTime() / 1000L - creationTime.getTime() / 1000L);
    }

    @Override
    public SignatureSubpackets setSignatureExpirationTime(boolean isCritical, long seconds) {
        if (seconds < 0L) {
            throw new IllegalArgumentException("Expiration time cannot be negative.");
        }
        return this.setSignatureExpirationTime(new SignatureExpirationTime(isCritical, seconds));
    }

    @Override
    public SignatureSubpackets setSignatureExpirationTime(@Nullable SignatureExpirationTime expirationTime) {
        this.signatureExpirationTime = expirationTime;
        return this;
    }

    public SignatureExpirationTime getSignatureExpirationTimeSubpacket() {
        return this.signatureExpirationTime;
    }

    @Override
    public SignatureSubpackets setSignerUserId(@Nonnull String userId) {
        return this.setSignerUserId(false, userId);
    }

    @Override
    public SignatureSubpackets setSignerUserId(boolean isCritical, @Nonnull String userId) {
        return this.setSignerUserId(new SignerUserID(isCritical, userId));
    }

    @Override
    public SignatureSubpackets setSignerUserId(@Nullable SignerUserID signerUserId) {
        this.signerUserId = signerUserId;
        return this;
    }

    public SignerUserID getSignerUserIdSubpacket() {
        return this.signerUserId;
    }

    @Override
    public SignatureSubpackets setPrimaryUserId() {
        return this.setPrimaryUserId(true);
    }

    @Override
    public SignatureSubpackets setPrimaryUserId(boolean isCritical) {
        return this.setPrimaryUserId(new PrimaryUserID(isCritical, true));
    }

    @Override
    public SignatureSubpackets setPrimaryUserId(@Nullable PrimaryUserID primaryUserId) {
        this.primaryUserId = primaryUserId;
        return this;
    }

    public PrimaryUserID getPrimaryUserIdSubpacket() {
        return this.primaryUserId;
    }

    @Override
    public SignatureSubpackets setKeyExpirationTime(@Nonnull PGPPublicKey key, @Nonnull Date keyExpirationTime) {
        return this.setKeyExpirationTime(key.getCreationTime(), keyExpirationTime);
    }

    @Override
    public SignatureSubpackets setKeyExpirationTime(@Nonnull Date keyCreationTime, @Nonnull Date keyExpirationTime) {
        return this.setKeyExpirationTime(true, keyCreationTime, keyExpirationTime);
    }

    @Override
    public SignatureSubpackets setKeyExpirationTime(boolean isCritical, @Nonnull Date keyCreationTime, @Nonnull Date keyExpirationTime) {
        return this.setKeyExpirationTime(isCritical, keyExpirationTime.getTime() / 1000L - keyCreationTime.getTime() / 1000L);
    }

    @Override
    public SignatureSubpackets setKeyExpirationTime(boolean isCritical, long secondsFromCreationToExpiration) {
        if (secondsFromCreationToExpiration < 0L) {
            throw new IllegalArgumentException("Seconds from key creation to expiration cannot be less than 0.");
        }
        return this.setKeyExpirationTime(new KeyExpirationTime(isCritical, secondsFromCreationToExpiration));
    }

    @Override
    public SignatureSubpackets setKeyExpirationTime(@Nullable KeyExpirationTime keyExpirationTime) {
        this.keyExpirationTime = keyExpirationTime;
        return this;
    }

    public KeyExpirationTime getKeyExpirationTimeSubpacket() {
        return this.keyExpirationTime;
    }

    @Override
    public SignatureSubpackets setPreferredCompressionAlgorithms(CompressionAlgorithm ... algorithms) {
        return this.setPreferredCompressionAlgorithms(new LinkedHashSet<CompressionAlgorithm>(Arrays.asList(algorithms)));
    }

    @Override
    public SignatureSubpackets setPreferredCompressionAlgorithms(Set<CompressionAlgorithm> algorithms) {
        return this.setPreferredCompressionAlgorithms(true, (Set)algorithms);
    }

    @Override
    public SignatureSubpackets setPreferredCompressionAlgorithms(boolean isCritical, Set<CompressionAlgorithm> algorithms) {
        int[] ids = new int[algorithms.size()];
        Iterator<CompressionAlgorithm> iterator = algorithms.iterator();
        for (int i = 0; i < algorithms.size(); ++i) {
            ids[i] = iterator.next().getAlgorithmId();
        }
        return this.setPreferredCompressionAlgorithms(new PreferredAlgorithms(22, isCritical, ids));
    }

    @Override
    public SignatureSubpackets setPreferredCompressionAlgorithms(@Nullable PreferredAlgorithms algorithms) {
        if (algorithms == null) {
            this.preferredCompressionAlgorithms = null;
            return this;
        }
        if (algorithms.getType() != 22) {
            throw new IllegalArgumentException("Invalid preferred compression algorithms type.");
        }
        this.preferredCompressionAlgorithms = algorithms;
        return this;
    }

    public PreferredAlgorithms getPreferredCompressionAlgorithmsSubpacket() {
        return this.preferredCompressionAlgorithms;
    }

    @Override
    public SignatureSubpackets setPreferredSymmetricKeyAlgorithms(SymmetricKeyAlgorithm ... algorithms) {
        return this.setPreferredSymmetricKeyAlgorithms(new LinkedHashSet<SymmetricKeyAlgorithm>(Arrays.asList(algorithms)));
    }

    @Override
    public SignatureSubpackets setPreferredSymmetricKeyAlgorithms(Set<SymmetricKeyAlgorithm> algorithms) {
        return this.setPreferredSymmetricKeyAlgorithms(true, (Set)algorithms);
    }

    @Override
    public SignatureSubpackets setPreferredSymmetricKeyAlgorithms(boolean isCritical, Set<SymmetricKeyAlgorithm> algorithms) {
        int[] ids = new int[algorithms.size()];
        Iterator<SymmetricKeyAlgorithm> iterator = algorithms.iterator();
        for (int i = 0; i < algorithms.size(); ++i) {
            ids[i] = iterator.next().getAlgorithmId();
        }
        return this.setPreferredSymmetricKeyAlgorithms(new PreferredAlgorithms(11, isCritical, ids));
    }

    @Override
    public SignatureSubpackets setPreferredSymmetricKeyAlgorithms(@Nullable PreferredAlgorithms algorithms) {
        if (algorithms == null) {
            this.preferredSymmetricKeyAlgorithms = null;
            return this;
        }
        if (algorithms.getType() != 11) {
            throw new IllegalArgumentException("Invalid preferred symmetric key algorithms type.");
        }
        this.preferredSymmetricKeyAlgorithms = algorithms;
        return this;
    }

    public PreferredAlgorithms getPreferredSymmetricKeyAlgorithmsSubpacket() {
        return this.preferredSymmetricKeyAlgorithms;
    }

    @Override
    public SignatureSubpackets setPreferredHashAlgorithms(HashAlgorithm ... algorithms) {
        return this.setPreferredHashAlgorithms(new LinkedHashSet<HashAlgorithm>(Arrays.asList(algorithms)));
    }

    @Override
    public SignatureSubpackets setPreferredHashAlgorithms(Set<HashAlgorithm> algorithms) {
        return this.setPreferredHashAlgorithms(true, (Set)algorithms);
    }

    @Override
    public SignatureSubpackets setPreferredHashAlgorithms(boolean isCritical, Set<HashAlgorithm> algorithms) {
        int[] ids = new int[algorithms.size()];
        Iterator<HashAlgorithm> iterator = algorithms.iterator();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = iterator.next().getAlgorithmId();
        }
        return this.setPreferredHashAlgorithms(new PreferredAlgorithms(21, isCritical, ids));
    }

    @Override
    public SignatureSubpackets setPreferredHashAlgorithms(@Nullable PreferredAlgorithms algorithms) {
        if (algorithms == null) {
            this.preferredHashAlgorithms = null;
            return this;
        }
        if (algorithms.getType() != 21) {
            throw new IllegalArgumentException("Invalid preferred hash algorithms type.");
        }
        this.preferredHashAlgorithms = algorithms;
        return this;
    }

    public PreferredAlgorithms getPreferredHashAlgorithmsSubpacket() {
        return this.preferredHashAlgorithms;
    }

    @Override
    public SignatureSubpackets addNotationData(boolean isCritical, @Nonnull String notationName, @Nonnull String notationValue) {
        return this.addNotationData(isCritical, true, notationName, notationValue);
    }

    @Override
    public SignatureSubpackets addNotationData(boolean isCritical, boolean isHumanReadable, @Nonnull String notationName, @Nonnull String notationValue) {
        return this.addNotationData(new NotationData(isCritical, isHumanReadable, notationName, notationValue));
    }

    @Override
    public SignatureSubpackets addNotationData(@Nonnull NotationData notationData) {
        this.notationDataList.add(notationData);
        return this;
    }

    @Override
    public SignatureSubpackets clearNotationData() {
        this.notationDataList.clear();
        return this;
    }

    public List<NotationData> getNotationDataSubpackets() {
        return new ArrayList<NotationData>(this.notationDataList);
    }

    @Override
    public SignatureSubpackets addIntendedRecipientFingerprint(@Nonnull PGPPublicKey recipient) {
        return this.addIntendedRecipientFingerprint(false, recipient);
    }

    @Override
    public SignatureSubpackets addIntendedRecipientFingerprint(boolean isCritical, @Nonnull PGPPublicKey recipient) {
        return this.addIntendedRecipientFingerprint(new IntendedRecipientFingerprint(isCritical, recipient.getVersion(), recipient.getFingerprint()));
    }

    @Override
    public SignatureSubpackets addIntendedRecipientFingerprint(IntendedRecipientFingerprint intendedRecipientFingerprint) {
        this.intendedRecipientFingerprintList.add(intendedRecipientFingerprint);
        return this;
    }

    @Override
    public SignatureSubpackets clearIntendedRecipientFingerprints() {
        this.intendedRecipientFingerprintList.clear();
        return this;
    }

    public List<IntendedRecipientFingerprint> getIntendedRecipientFingerprintSubpackets() {
        return new ArrayList<IntendedRecipientFingerprint>(this.intendedRecipientFingerprintList);
    }

    @Override
    public SignatureSubpackets setExportable(boolean isCritical, boolean isExportable) {
        return this.setExportable(new Exportable(isCritical, isExportable));
    }

    @Override
    public SignatureSubpackets setExportable(@Nullable Exportable exportable) {
        this.exportable = exportable;
        return this;
    }

    public Exportable getExportableSubpacket() {
        return this.exportable;
    }

    @Override
    public SignatureSubpackets setRevocable(boolean isCritical, boolean isRevocable) {
        return this.setRevocable(new Revocable(isCritical, isRevocable));
    }

    @Override
    public SignatureSubpackets setRevocable(@Nullable Revocable revocable) {
        this.revocable = revocable;
        return this;
    }

    public Revocable getRevocableSubpacket() {
        return this.revocable;
    }

    @Override
    public SignatureSubpackets addRevocationKey(@Nonnull PGPPublicKey revocationKey) {
        return this.addRevocationKey(true, revocationKey);
    }

    @Override
    public SignatureSubpackets addRevocationKey(boolean isCritical, @Nonnull PGPPublicKey revocationKey) {
        return this.addRevocationKey(isCritical, false, revocationKey);
    }

    @Override
    public SignatureSubpackets addRevocationKey(boolean isCritical, boolean isSensitive, @Nonnull PGPPublicKey revocationKey) {
        byte clazz = -128;
        clazz = (byte)(clazz | (isSensitive ? 64 : 0));
        return this.addRevocationKey(new RevocationKey(isCritical, clazz, revocationKey.getAlgorithm(), revocationKey.getFingerprint()));
    }

    @Override
    public SignatureSubpackets addRevocationKey(@Nonnull RevocationKey revocationKey) {
        this.revocationKeyList.add(revocationKey);
        return this;
    }

    @Override
    public SignatureSubpackets clearRevocationKeys() {
        this.revocationKeyList.clear();
        return this;
    }

    public List<RevocationKey> getRevocationKeySubpackets() {
        return new ArrayList<RevocationKey>(this.revocationKeyList);
    }

    @Override
    public SignatureSubpackets setRevocationReason(RevocationAttributes revocationAttributes) {
        return this.setRevocationReason(true, revocationAttributes);
    }

    @Override
    public SignatureSubpackets setRevocationReason(boolean isCritical, RevocationAttributes revocationAttributes) {
        return this.setRevocationReason(isCritical, revocationAttributes.getReason(), revocationAttributes.getDescription());
    }

    @Override
    public SignatureSubpackets setRevocationReason(boolean isCritical, RevocationAttributes.Reason reason, @Nonnull String description) {
        return this.setRevocationReason(new RevocationReason(isCritical, reason.code(), description));
    }

    @Override
    public SignatureSubpackets setRevocationReason(@Nullable RevocationReason reason) {
        this.revocationReason = reason;
        return this;
    }

    public RevocationReason getRevocationReasonSubpacket() {
        return this.revocationReason;
    }

    @Override
    public SignatureSubpackets setSignatureTarget(@Nonnull PublicKeyAlgorithm keyAlgorithm, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull byte[] hashData) {
        return this.setSignatureTarget(true, keyAlgorithm, hashAlgorithm, hashData);
    }

    @Override
    public SignatureSubpackets setSignatureTarget(boolean isCritical, @Nonnull PublicKeyAlgorithm keyAlgorithm, @Nonnull HashAlgorithm hashAlgorithm, @Nonnull byte[] hashData) {
        return this.setSignatureTarget(new SignatureTarget(isCritical, keyAlgorithm.getAlgorithmId(), hashAlgorithm.getAlgorithmId(), hashData));
    }

    @Override
    public SignatureSubpackets setSignatureTarget(@Nullable SignatureTarget signatureTarget) {
        this.signatureTarget = signatureTarget;
        return this;
    }

    public SignatureTarget getSignatureTargetSubpacket() {
        return this.signatureTarget;
    }

    @Override
    public SignatureSubpackets setFeatures(Feature ... features) {
        return this.setFeatures(true, features);
    }

    @Override
    public SignatureSubpackets setFeatures(boolean isCritical, Feature ... features) {
        byte bitmask = Feature.toBitmask(features);
        return this.setFeatures(new Features(isCritical, bitmask));
    }

    @Override
    public SignatureSubpackets setFeatures(@Nullable Features features) {
        this.features = features;
        return this;
    }

    public Features getFeaturesSubpacket() {
        return this.features;
    }

    @Override
    public SignatureSubpackets setTrust(int depth, int amount) {
        return this.setTrust(true, depth, amount);
    }

    @Override
    public SignatureSubpackets setTrust(boolean isCritical, int depth, int amount) {
        return this.setTrust(new TrustSignature(isCritical, depth, amount));
    }

    @Override
    public SignatureSubpackets setTrust(@Nullable TrustSignature trust) {
        this.trust = trust;
        return this;
    }

    public TrustSignature getTrustSubpacket() {
        return this.trust;
    }

    @Override
    public SignatureSubpackets addEmbeddedSignature(@Nonnull PGPSignature signature) throws IOException {
        return this.addEmbeddedSignature(true, signature);
    }

    @Override
    public SignatureSubpackets addEmbeddedSignature(boolean isCritical, @Nonnull PGPSignature signature) throws IOException {
        byte[] sig = signature.getEncoded();
        byte[] data = sig.length - 1 > 256 ? new byte[sig.length - 3] : new byte[sig.length - 2];
        System.arraycopy(sig, sig.length - data.length, data, 0, data.length);
        return this.addEmbeddedSignature(new EmbeddedSignature(isCritical, false, data));
    }

    @Override
    public SignatureSubpackets addEmbeddedSignature(@Nonnull EmbeddedSignature embeddedSignature) {
        this.embeddedSignatureList.add(embeddedSignature);
        return this;
    }

    @Override
    public SignatureSubpackets clearEmbeddedSignatures() {
        this.embeddedSignatureList.clear();
        return this;
    }

    public List<EmbeddedSignature> getEmbeddedSignatureSubpackets() {
        return new ArrayList<EmbeddedSignature>(this.embeddedSignatureList);
    }

    public SignatureSubpackets addResidualSubpacket(SignatureSubpacket subpacket) {
        this.residualSubpackets.add(subpacket);
        return this;
    }

    public List<SignatureSubpacket> getResidualSubpackets() {
        return new ArrayList<SignatureSubpacket>(this.residualSubpackets);
    }
}

