/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.example;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public class DecryptOrVerify {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: AA21 9149 3B35 E679 8876  DE43 B0D7 8185 F639 B6C9\nComment: Signora <signora@pgpainless.org>\n\nlFgEYVGUbRYJKwYBBAHaRw8BAQdAki59UUbUouvfd+4hoSAQ79He7cdmTyYTu3Su\n9Ww0isQAAQCvyi79y6YNzxdQpN8HLPmBd+zq6o/RNK4cBeN+RJrxiBHbtCBTaWdu\nb3JhIDxzaWdub3JhQHBncGFpbmxlc3Mub3JnPoh4BBMWCgAgBQJhUZRtAhsBBRYC\nAwEABRUKCQgLBAsJCAcCHgECGQEACgkQsNeBhfY5tskOqgEA3fDHE1n081xiseTl\naXV1A/6aXvsnxVo+Lj35Mn7CarwBAO4PVjHvvUydTla3D5JHhZ0p4P5hSG7kPPrB\nd3nmbH0InF0EYVGUbRIKKwYBBAGXVQEFAQEHQFzDN2Tuaxim9YFRRXeRZyDC42KF\n9DSohUXEJ/TrM7MlAwEIBwAA/3h1IaQBIGlNZ6TSsuuryW8KtwdxI4Sd1JDzsVML\n2SGQEFKIdQQYFgoAHQUCYVGUbQIbDAUWAgMBAAUVCgkICwQLCQgHAh4BAAoJELDX\ngYX2ObbJBzwBAM4RYBuRsRTmEFTrc7FyAqqSrCVpyLkrnYqPTZriySX0AP9K+N1d\nLIDRkHW7EbK2ITRu6nemFu00+H1bInTCUVxtAZxYBGFRlG0WCSsGAQQB2kcPAQEH\nQOzydmmSnNw/NoWi0b0pODLNbT2VUFNFurxBoWj8T2oLAAD+Nbk5mZVQ91pDV6Bp\nSAjCP9/e7odHtipsdlG9lszzC98RcIjVBBgWCgB9BQJhUZRtAhsCBRYCAwEABRUK\nCQgLBAsJCAcCHgFfIAQZFgoABgUCYVGUbQAKCRBaxbg/GlrWhx43AP40HxpvHNL5\nm953hWBxZvzIpt98E8+bfR4rCyHY6A5rzQEA8BUI6oqsEPKlGiETYntk7fFhOIyJ\nbRH+a/LsdaxjpQwACgkQsNeBhfY5tskKHQEA+aanF6ZnSatjDdiKEehYmbqr4BTc\nUDnu37YkbgLlqPIBAJrPT5XS9oVa5xMsK+c3shnmPVQuK9r/AGwlligJprYH\n=JHMt\n-----END PGP PRIVATE KEY BLOCK-----\n";
    private static final String INBAND_SIGNED = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nowGbwMvMyCUWdXSHvVTUtXbG0yJJDCDgkZqTk6+jEJ5flJOiyNVRysIoxsXAxsqU\nGDiVjUGRUwCmQUyRRWnOn9Z/PIseF3Yz6cCEL05nZDj1OClo75WVTjNmJPemW6qV\n6ki//1K1++2s0qTP+0N11O4z/BVLDDdxnmQryS+5VXjBX7/0Hxnm/eqeX6Zum35r\nM8e7ufwA\n=RDiy\n-----END PGP MESSAGE-----";
    private static final String CLEARTEXT_SIGNED = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA512\n\nHello, World!\n\n-----BEGIN PGP SIGNATURE-----\nVersion: PGPainless\n\niHUEARYKAAYFAmFR1WIAIQkQWsW4Pxpa1ocWIQQinPyF/gyi43GLAixaxbg/GlrW\nh7qwAP9Vq0PfDdGpM+n4wfR162XBvvVU8KNl+vJI3u7Ghlj0zwEA1VMgwNnCRb9b\nQUibivG5Slahz8l7PWnGkxbB2naQxgw=\n=oNIK\n-----END PGP SIGNATURE-----";
    private static PGPSecretKeyRing secretKey;
    private static PGPPublicKeyRing certificate;

    @BeforeAll
    public static void prepare() throws IOException {
        secretKey = PGPainless.readKeyRing().secretKeyRing(KEY);
        certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
    }

    @Test
    public void verifySignatures() throws PGPException, IOException {
        ConsumerOptions options = new ConsumerOptions().addVerificationCert(certificate);
        for (String signed : new String[]{INBAND_SIGNED, CLEARTEXT_SIGNED}) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(signed.getBytes(StandardCharsets.UTF_8));
            DecryptionStream verificationStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(options);
            Streams.pipeAll((InputStream)verificationStream, (OutputStream)out);
            verificationStream.close();
            OpenPgpMetadata metadata = verificationStream.getResult();
            Assertions.assertTrue((boolean)metadata.isVerified());
            Assertions.assertArrayEquals((byte[])"Hello, World!\n".getBytes(StandardCharsets.UTF_8), (byte[])out.toByteArray());
        }
    }

    @Test
    public void createVerifyCleartextSignedMessage() throws PGPException, IOException {
        for (String msg : new String[]{"Hello World!", "- Hello - World -", "Hello, World!\n", "Hello\nWorld!"}) {
            ByteArrayInputStream in = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKey, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setCleartextSigned());
            Streams.pipeAll((InputStream)in, (OutputStream)signingStream);
            signingStream.close();
            ByteArrayInputStream signedIn = new ByteArrayInputStream(out.toByteArray());
            DecryptionStream verificationStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)signedIn).withOptions(new ConsumerOptions().addVerificationCert(certificate));
            ByteArrayOutputStream plain = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)verificationStream, (OutputStream)plain);
            verificationStream.close();
            OpenPgpMetadata metadata = verificationStream.getResult();
            Assertions.assertTrue((boolean)metadata.isVerified());
            Assertions.assertArrayEquals((byte[])msg.getBytes(StandardCharsets.UTF_8), (byte[])plain.toByteArray());
        }
    }
}

