/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.policy;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.policy.Policy;

public class PolicyTest {
    private static Policy policy;

    @BeforeAll
    public static void setup() {
        policy = new Policy();
        policy.setCompressionAlgorithmPolicy(new Policy.CompressionAlgorithmPolicy(CompressionAlgorithm.UNCOMPRESSED, Arrays.asList(CompressionAlgorithm.ZIP, CompressionAlgorithm.ZLIB, CompressionAlgorithm.UNCOMPRESSED)));
        policy.setSymmetricKeyEncryptionAlgorithmPolicy(new Policy.SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, Arrays.asList(SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128)));
        policy.setSymmetricKeyDecryptionAlgorithmPolicy(new Policy.SymmetricKeyAlgorithmPolicy(SymmetricKeyAlgorithm.AES_256, Arrays.asList(SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128, SymmetricKeyAlgorithm.BLOWFISH)));
        policy.setSignatureHashAlgorithmPolicy(new Policy.HashAlgorithmPolicy(HashAlgorithm.SHA512, Arrays.asList(HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256)));
        policy.setRevocationSignatureHashAlgorithmPolicy(new Policy.HashAlgorithmPolicy(HashAlgorithm.SHA512, Arrays.asList(HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224, HashAlgorithm.SHA1)));
        policy.setPublicKeyAlgorithmPolicy(Policy.PublicKeyAlgorithmPolicy.defaultPublicKeyAlgorithmPolicy());
    }

    @Test
    public void testAcceptableCompressionAlgorithm() {
        Assertions.assertTrue((boolean)policy.getCompressionAlgorithmPolicy().isAcceptable(CompressionAlgorithm.ZIP));
        Assertions.assertTrue((boolean)policy.getCompressionAlgorithmPolicy().isAcceptable(CompressionAlgorithm.ZIP.getAlgorithmId()));
    }

    @Test
    public void testUnacceptableCompressionAlgorithm() {
        Assertions.assertFalse((boolean)policy.getCompressionAlgorithmPolicy().isAcceptable(CompressionAlgorithm.BZIP2));
        Assertions.assertFalse((boolean)policy.getCompressionAlgorithmPolicy().isAcceptable(CompressionAlgorithm.BZIP2.getAlgorithmId()));
    }

    @Test
    public void testDefaultCompressionAlgorithm() {
        Assertions.assertEquals((Object)CompressionAlgorithm.UNCOMPRESSED, (Object)policy.getCompressionAlgorithmPolicy().defaultCompressionAlgorithm());
    }

    @Test
    public void testAcceptableSymmetricKeyEncryptionAlgorithm() {
        Assertions.assertTrue((boolean)policy.getSymmetricKeyEncryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.AES_256));
        Assertions.assertTrue((boolean)policy.getSymmetricKeyEncryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.AES_256.getAlgorithmId()));
    }

    @Test
    public void testUnAcceptableSymmetricKeyEncryptionAlgorithm() {
        Assertions.assertFalse((boolean)policy.getSymmetricKeyEncryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.BLOWFISH));
        Assertions.assertFalse((boolean)policy.getSymmetricKeyEncryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.BLOWFISH.getAlgorithmId()));
    }

    @Test
    public void testDefaultSymmetricKeyEncryptionAlgorithm() {
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)policy.getSymmetricKeyEncryptionAlgorithmPolicy().getDefaultSymmetricKeyAlgorithm());
    }

    @Test
    public void testAcceptableSymmetricKeyDecryptionAlgorithm() {
        Assertions.assertTrue((boolean)policy.getSymmetricKeyDecryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.BLOWFISH));
        Assertions.assertTrue((boolean)policy.getSymmetricKeyDecryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.BLOWFISH.getAlgorithmId()));
    }

    @Test
    public void testUnAcceptableSymmetricKeyDecryptionAlgorithm() {
        Assertions.assertFalse((boolean)policy.getSymmetricKeyDecryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.CAMELLIA_128));
        Assertions.assertFalse((boolean)policy.getSymmetricKeyDecryptionAlgorithmPolicy().isAcceptable(SymmetricKeyAlgorithm.CAMELLIA_128.getAlgorithmId()));
    }

    @Test
    public void testAcceptableSignatureHashAlgorithm() {
        Assertions.assertTrue((boolean)policy.getSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.SHA512));
        Assertions.assertTrue((boolean)policy.getSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.SHA512.getAlgorithmId()));
    }

    @Test
    public void testUnacceptableSignatureHashAlgorithm() {
        Assertions.assertFalse((boolean)policy.getSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.SHA1));
        Assertions.assertFalse((boolean)policy.getSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.SHA1.getAlgorithmId()));
    }

    @Test
    public void testDefaultSignatureHashAlgorithm() {
        Assertions.assertEquals((Object)HashAlgorithm.SHA512, (Object)policy.getSignatureHashAlgorithmPolicy().defaultHashAlgorithm());
    }

    @Test
    public void testAcceptableRevocationSignatureHashAlgorithm() {
        Assertions.assertTrue((boolean)policy.getRevocationSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.SHA384));
        Assertions.assertTrue((boolean)policy.getRevocationSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.SHA384.getAlgorithmId()));
    }

    @Test
    public void testUnacceptableRevocationSignatureHashAlgorithm() {
        Assertions.assertFalse((boolean)policy.getRevocationSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.RIPEMD160));
        Assertions.assertFalse((boolean)policy.getRevocationSignatureHashAlgorithmPolicy().isAcceptable(HashAlgorithm.RIPEMD160.getAlgorithmId()));
    }

    @Test
    public void testDefaultRevocationSignatureHashAlgorithm() {
        Assertions.assertEquals((Object)HashAlgorithm.SHA512, (Object)policy.getRevocationSignatureHashAlgorithmPolicy().defaultHashAlgorithm());
    }

    @Test
    public void testAcceptablePublicKeyAlgorithm() {
        Assertions.assertTrue((boolean)policy.getPublicKeyAlgorithmPolicy().isAcceptable(PublicKeyAlgorithm.ECDSA, 256));
        Assertions.assertTrue((boolean)policy.getPublicKeyAlgorithmPolicy().isAcceptable(PublicKeyAlgorithm.ECDSA.getAlgorithmId(), 256));
        Assertions.assertTrue((boolean)policy.getPublicKeyAlgorithmPolicy().isAcceptable(PublicKeyAlgorithm.RSA_GENERAL, 3072));
        Assertions.assertTrue((boolean)policy.getPublicKeyAlgorithmPolicy().isAcceptable(PublicKeyAlgorithm.RSA_GENERAL.getAlgorithmId(), 3072));
    }

    @Test
    public void testUnacceptablePublicKeyAlgorithm() {
        Assertions.assertFalse((boolean)policy.getPublicKeyAlgorithmPolicy().isAcceptable(PublicKeyAlgorithm.RSA_GENERAL, 1024));
        Assertions.assertFalse((boolean)policy.getPublicKeyAlgorithmPolicy().isAcceptable(PublicKeyAlgorithm.RSA_GENERAL.getAlgorithmId(), 1024));
    }

    @Test
    public void testNotationRegistry() {
        Assertions.assertFalse((boolean)policy.getNotationRegistry().isKnownNotation("notation@pgpainless.org"));
        policy.getNotationRegistry().addKnownNotation("notation@pgpainless.org");
        Assertions.assertTrue((boolean)policy.getNotationRegistry().isKnownNotation("notation@pgpainless.org"));
    }
}

