/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.userid;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.selection.userid.SelectUserId;

public class SelectUserIdTest {
    @Test
    public void testSelectUserIds() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("<alice@wonderland.lit>");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)UserId.newBuilder().withName("Alice Liddell").noComment().withEmail("crazy@the-rabbit.hole").build(), SecretKeyRingProtector.unprotectedKeys()).done();
        List validEmail = SelectUserId.and((SelectUserId[])new SelectUserId[]{SelectUserId.validUserId((PGPKeyRing)secretKeys), SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit")}).selectUserIds((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Collections.singletonList("<alice@wonderland.lit>"), (Object)validEmail);
        List startsWithAlice = SelectUserId.startsWith((CharSequence)"Alice").selectUserIds((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Collections.singletonList("Alice Liddell <crazy@the-rabbit.hole>"), (Object)startsWithAlice);
        List exactMatch = SelectUserId.or((SelectUserId[])new SelectUserId[]{SelectUserId.exactMatch((CharSequence)"<alice@wonderland.lit>"), SelectUserId.startsWith((CharSequence)"Not Found")}).selectUserIds((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Collections.singletonList("<alice@wonderland.lit>"), (Object)exactMatch);
    }

    @Test
    public void testContainsSubstring() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("wine drinker");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"this is not a quine", SecretKeyRingProtector.unprotectedKeys()).addUserId((CharSequence)"this is not a crime", SecretKeyRingProtector.unprotectedKeys()).done();
        List containSubstring = SelectUserId.containsSubstring((CharSequence)"ine").selectUserIds((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Arrays.asList("wine drinker", "this is not a quine"), (Object)containSubstring);
    }

    @Test
    public void testContainsEmailAddress() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("Alice <alice@wonderland.lit>");
        Assertions.assertEquals((Object)"Alice <alice@wonderland.lit>", (Object)SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit").firstMatch((PGPKeyRing)secretKeys));
        Assertions.assertEquals((Object)"Alice <alice@wonderland.lit>", (Object)SelectUserId.containsEmailAddress((CharSequence)"<alice@wonderland.lit>").firstMatch((PGPKeyRing)secretKeys));
        Assertions.assertNull((Object)SelectUserId.containsEmailAddress((CharSequence)"mad@hatter.lit").firstMatch((PGPKeyRing)secretKeys));
    }

    @Test
    public void testAndOrNot() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("Alice <alice@wonderland.lit>");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"Alice <another@email.address>", SecretKeyRingProtector.unprotectedKeys()).addUserId((CharSequence)"<crazy@the-rabbit.hole>", SecretKeyRingProtector.unprotectedKeys()).addUserId((CharSequence)"Crazy Girl <alice@wonderland.lit>", SecretKeyRingProtector.unprotectedKeys()).done();
        List or = SelectUserId.or((SelectUserId[])new SelectUserId[]{SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit"), SelectUserId.startsWith((CharSequence)"Alice")}).selectUserIds((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Arrays.asList("Alice <alice@wonderland.lit>", "Alice <another@email.address>", "Crazy Girl <alice@wonderland.lit>"), (Object)or);
        List and = SelectUserId.and((SelectUserId[])new SelectUserId[]{SelectUserId.containsEmailAddress((CharSequence)"alice@wonderland.lit"), SelectUserId.startsWith((CharSequence)"Alice")}).selectUserIds((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Collections.singletonList("Alice <alice@wonderland.lit>"), (Object)and);
        List not = SelectUserId.not((SelectUserId)SelectUserId.startsWith((CharSequence)"Alice")).selectUserIds((PGPKeyRing)secretKeys);
        Assertions.assertEquals(Arrays.asList("<crazy@the-rabbit.hole>", "Crazy Girl <alice@wonderland.lit>"), (Object)not);
    }

    @Test
    public void testFirstMatch() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().simpleEcKeyRing("First UserID");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"Second UserID", SecretKeyRingProtector.unprotectedKeys()).done();
        Assertions.assertEquals((Object)"First UserID", (Object)SelectUserId.validUserId((PGPKeyRing)secretKeys).firstMatch((PGPKeyRing)secretKeys));
        Assertions.assertEquals((Object)"Second UserID", (Object)SelectUserId.containsSubstring((CharSequence)"Second").firstMatch(PGPainless.inspectKeyRing((PGPKeyRing)secretKeys).getUserIds()));
    }

    @Test
    public void testByEmail() {
        SelectUserId containsEmailAddress = SelectUserId.containsEmailAddress((CharSequence)"alice@pgpainless.org");
        Assertions.assertTrue((boolean)containsEmailAddress.accept("<alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)containsEmailAddress.accept("Alice <alice@pgpainless.org>"));
        SelectUserId byEmail = SelectUserId.byEmail((CharSequence)"alice@pgpainless.org");
        Assertions.assertTrue((boolean)byEmail.accept("alice@pgpainless.org"));
        Assertions.assertTrue((boolean)byEmail.accept("<alice@pgpainless.org>"));
        Assertions.assertTrue((boolean)byEmail.accept("Alice <alice@pgpainless.org>"));
    }
}

