/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum StreamEncoding {
    BINARY('b'),
    TEXT('t'),
    UTF8('u'),
    MIME('m'),
    LOCAL('l');

    private final char code;
    private static final Map<Character, StreamEncoding> MAP;

    private StreamEncoding(char code) {
        this.code = code;
    }

    public char getCode() {
        return this.code;
    }

    public static StreamEncoding fromCode(int code) {
        return MAP.get(Character.valueOf((char)code));
    }

    static {
        MAP = new ConcurrentHashMap<Character, StreamEncoding>();
        for (StreamEncoding f : StreamEncoding.values()) {
            MAP.put(Character.valueOf(f.code), f);
        }
        MAP.put(Character.valueOf('1'), LOCAL);
    }
}

