/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPCanonicalizedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.pgpainless.algorithm.StreamEncoding;

public final class StreamGeneratorWrapper {
    private final StreamEncoding encoding;
    private final PGPLiteralDataGenerator literalDataGenerator;
    private final PGPCanonicalizedDataGenerator canonicalizedDataGenerator;

    public static StreamGeneratorWrapper forStreamEncoding(@Nonnull StreamEncoding encoding) {
        if (encoding == StreamEncoding.BINARY) {
            return new StreamGeneratorWrapper(encoding, new PGPLiteralDataGenerator());
        }
        return new StreamGeneratorWrapper(encoding, new PGPCanonicalizedDataGenerator());
    }

    private StreamGeneratorWrapper(@Nonnull StreamEncoding encoding, @Nonnull PGPLiteralDataGenerator literalDataGenerator) {
        if (encoding != StreamEncoding.BINARY) {
            throw new IllegalArgumentException("PGPLiteralDataGenerator can only be used with BINARY encoding.");
        }
        this.encoding = encoding;
        this.literalDataGenerator = literalDataGenerator;
        this.canonicalizedDataGenerator = null;
    }

    private StreamGeneratorWrapper(@Nonnull StreamEncoding encoding, @Nonnull PGPCanonicalizedDataGenerator canonicalizedDataGenerator) {
        if (encoding != StreamEncoding.TEXT && encoding != StreamEncoding.UTF8) {
            throw new IllegalArgumentException("PGPCanonicalizedDataGenerator can only be used with TEXT or UTF8 encoding.");
        }
        this.encoding = encoding;
        this.canonicalizedDataGenerator = canonicalizedDataGenerator;
        this.literalDataGenerator = null;
    }

    public OutputStream open(OutputStream outputStream, String filename, Date modificationDate, byte[] buffer) throws IOException {
        if (this.literalDataGenerator != null) {
            return this.literalDataGenerator.open(outputStream, this.encoding.getCode(), filename, modificationDate, buffer);
        }
        return this.canonicalizedDataGenerator.open(outputStream, this.encoding.getCode(), filename, modificationDate, buffer);
    }

    public void close() throws IOException {
        if (this.literalDataGenerator != null) {
            this.literalDataGenerator.close();
        }
        if (this.canonicalizedDataGenerator != null) {
            this.canonicalizedDataGenerator.close();
        }
    }
}

