/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.cleartext_signatures.InMemoryMultiPassStrategy;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.consumer.CertificateValidator;
import org.pgpainless.signature.consumer.SignatureVerifier;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.TestUtils;

public class CleartextSignatureVerificationTest {
    public static final byte[] MESSAGE_BODY = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.".getBytes(StandardCharsets.UTF_8);
    public static final byte[] MESSAGE_SIGNED = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA512\n\nAh, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.\n-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----".getBytes(StandardCharsets.UTF_8);
    public static final byte[] SIGNATURE = "-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----".getBytes(StandardCharsets.UTF_8);
    public static final String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final Random random = new Random();

    @Test
    public void cleartextSignVerification_InMemoryMultiPassStrategy() throws IOException, PGPException {
        PGPPublicKeyRing signingKeys = TestKeys.getEmilPublicKeyRing();
        ConsumerOptions options = new ConsumerOptions().addVerificationCert(signingKeys);
        InMemoryMultiPassStrategy multiPassStrategy = MultiPassStrategy.keepMessageInMemory();
        options.setMultiPassStrategy((MultiPassStrategy)multiPassStrategy);
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(MESSAGE_SIGNED)).withOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        OpenPgpMetadata result = decryptionStream.getResult();
        Assertions.assertTrue((boolean)result.isVerified());
        PGPSignature signature = (PGPSignature)result.getVerifiedSignatures().values().iterator().next();
        Assertions.assertEquals((long)signature.getKeyID(), (long)signingKeys.getPublicKey().getKeyID());
        Assertions.assertArrayEquals((byte[])MESSAGE_BODY, (byte[])out.toByteArray());
    }

    @Test
    public void cleartextSignVerification_FileBasedMultiPassStrategy() throws IOException, PGPException {
        PGPPublicKeyRing signingKeys = TestKeys.getEmilPublicKeyRing();
        ConsumerOptions options = new ConsumerOptions().addVerificationCert(signingKeys);
        File tempDir = TestUtils.createTempDirectory();
        File file = new File(tempDir, "file");
        MultiPassStrategy multiPassStrategy = MultiPassStrategy.writeMessageToFile((File)file);
        options.setMultiPassStrategy(multiPassStrategy);
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(MESSAGE_SIGNED)).withOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        OpenPgpMetadata result = decryptionStream.getResult();
        Assertions.assertTrue((boolean)result.isVerified());
        PGPSignature signature = (PGPSignature)result.getVerifiedSignatures().values().iterator().next();
        Assertions.assertEquals((long)signature.getKeyID(), (long)signingKeys.getPublicKey().getKeyID());
        FileInputStream fileIn = new FileInputStream(file);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)fileIn, (OutputStream)bytes);
        fileIn.close();
        Assertions.assertArrayEquals((byte[])MESSAGE_BODY, (byte[])bytes.toByteArray());
    }

    @Test
    public void verifySignatureDetached() throws IOException, PGPException {
        PGPPublicKeyRing signingKeys = TestKeys.getEmilPublicKeyRing();
        PGPSignature signature = (PGPSignature)SignatureUtils.readSignatures((byte[])SIGNATURE).get(0);
        PGPPublicKey signingKey = signingKeys.getPublicKey(signature.getKeyID());
        SignatureVerifier.initializeSignatureAndUpdateWithSignedData((PGPSignature)signature, (InputStream)new ByteArrayInputStream(MESSAGE_BODY), (PGPPublicKey)signingKey);
        CertificateValidator.validateCertificateAndVerifyInitializedSignature((PGPSignature)signature, (PGPPublicKeyRing)signingKeys, (Policy)PGPainless.getPolicy());
    }

    public static void main(String[] args) throws IOException {
        PGPPublicKeyRing keys = TestKeys.getEmilPublicKeyRing();
        System.out.println(ArmorUtils.toAsciiArmoredString((PGPPublicKeyRing)keys));
        System.out.println(new String(MESSAGE_SIGNED));
        System.out.println(new String(MESSAGE_BODY));
        System.out.println(new String(SIGNATURE));
    }

    @Test
    public void testOutputOfSigVerification() throws IOException, PGPException {
        PGPSignature signature = (PGPSignature)SignatureUtils.readSignatures((byte[])SIGNATURE).get(0);
        ConsumerOptions options = new ConsumerOptions().addVerificationCert(TestKeys.getEmilPublicKeyRing()).addVerificationOfDetachedSignature(signature);
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)new ByteArrayInputStream(MESSAGE_BODY)).withOptions(options);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
        OpenPgpMetadata metadata = decryptionStream.getResult();
        Assertions.assertEquals((int)1, (int)metadata.getVerifiedSignatures().size());
    }

    @Test
    public void getDecoderStreamMistakensPlaintextForBase64RegressionTest() throws PGPException, IOException {
        String message = "Foo\nBar";
        ByteArrayInputStream msgIn = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
        PGPSecretKeyRing secretKey = TestKeys.getEmilSecretKeyRing();
        ByteArrayOutputStream signedOut = new ByteArrayOutputStream();
        EncryptionStream signingStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)signedOut).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKey, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setCleartextSigned());
        Streams.pipeAll((InputStream)msgIn, (OutputStream)signingStream);
        signingStream.close();
        String signed = signedOut.toString();
        ByteArrayInputStream signedIn = new ByteArrayInputStream(signed.getBytes(StandardCharsets.UTF_8));
        DecryptionStream verificationStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)signedIn).withOptions(new ConsumerOptions().addVerificationCert(TestKeys.getEmilPublicKeyRing()));
        ByteArrayOutputStream msgOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verificationStream, (OutputStream)msgOut);
        verificationStream.close();
        OpenPgpMetadata metadata = verificationStream.getResult();
        Assertions.assertTrue((boolean)metadata.isVerified());
    }

    @Test
    public void testDecryptionOfVeryLongClearsignedMessage() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        String message = this.randomString(28, 4000);
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("Alice", null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.sign((SigningOptions)SigningOptions.get().addDetachedSignature(SecretKeyRingProtector.unprotectedKeys(), secretKeys, DocumentSignatureType.CANONICAL_TEXT_DOCUMENT)).setCleartextSigned());
        Streams.pipeAll((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), (OutputStream)encryptionStream);
        encryptionStream.close();
        String cleartextSigned = out.toString();
        ByteArrayInputStream in = new ByteArrayInputStream(cleartextSigned.getBytes(StandardCharsets.UTF_8));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)in).withOptions(new ConsumerOptions().addVerificationCert(PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys)));
        out = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)out);
        decryptionStream.close();
    }

    private String randomString(int maxWordLen, int wordCount) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < wordCount; ++i) {
            sb.append(this.randomWord(maxWordLen)).append(' ');
            int n = random.nextInt(12);
            if (n != 11) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private String randomWord(int maxWordLen) {
        int len = random.nextInt(maxWordLen);
        char[] word = new char[len];
        for (int i = 0; i < word.length; ++i) {
            word[i] = alphabet.charAt(random.nextInt(alphabet.length()));
        }
        return new String(word);
    }
}

