/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV5Fingerprint;

public class OpenPgpV5FingerprintTest {
    @Test
    public void testFingerprintFormatting() {
        String pretty = "76543210 ABCDEFAB 01AB23CD 1C0FFEE1  1EEFF0C1 DC32BA10 BAFEDCBA 01234567";
        String fp = pretty.replace(" ", "");
        OpenPgpV5Fingerprint fingerprint = new OpenPgpV5Fingerprint(fp);
        Assertions.assertEquals((Object)fp, (Object)fingerprint.toString());
        Assertions.assertEquals((Object)pretty, (Object)fingerprint.prettyPrint());
        long id = fingerprint.getKeyId();
        Assertions.assertEquals((Object)"76543210abcdefab", (Object)Long.toHexString(id));
    }

    @Test
    public void testParse() {
        String prettyPrint = "76543210 ABCDEFAB 01AB23CD 1C0FFEE1  1EEFF0C1 DC32BA10 BAFEDCBA 01234567";
        OpenPgpFingerprint parsed = OpenPgpFingerprint.parse((String)prettyPrint);
        Assertions.assertTrue((boolean)(parsed instanceof OpenPgpV5Fingerprint));
        OpenPgpV5Fingerprint v5fp = (OpenPgpV5Fingerprint)parsed;
        Assertions.assertEquals((Object)prettyPrint, (Object)v5fp.prettyPrint());
    }
}

