/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;

public class ChangePrimaryUserIdAndExpirationDatesTest {
    @Test
    public void generateA_primaryB_revokeA_cantSecondaryA() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InterruptedException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("A", null);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertFalse((boolean)info.isHardRevoked("A"));
        Assertions.assertFalse((boolean)info.isHardRevoked("B"));
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("B", info);
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addPrimaryUserId((CharSequence)"B", protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("A", info);
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revokeUserId((CharSequence)"A", protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isHardRevoked("A"));
        Assertions.assertFalse((boolean)info.isHardRevoked("B"));
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("A", info);
        Thread.sleep(1000L);
        PGPSecretKeyRing finalSecretKeys = secretKeys;
        Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.modifyKeyRing((PGPSecretKeyRing)finalSecretKeys).addUserId((CharSequence)"A", protector));
    }

    @Test
    public void generateA_primaryExpire_isExpired() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InterruptedException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("A", null);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(new Date(), protector).done();
        Thread.sleep(1000L);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertFalse((boolean)info.isUserIdValid("A"));
    }

    @Test
    public void generateA_primaryB_primaryExpire_bIsStillPrimary() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InterruptedException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("A", null);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addPrimaryUserId((CharSequence)"B", protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("A", info);
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(new Date(new Date().getTime() + 1000L), protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotPrimaryUserId("A", info);
        Thread.sleep(2000L);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        Assertions.assertFalse((boolean)info.isUserIdValid("A"));
        Assertions.assertFalse((boolean)info.isUserIdValid("B"));
    }

    @Test
    public void generateA_expire_certify() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InterruptedException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("A", null);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(new Date(new Date().getTime() + 1000L), protector).done();
        Thread.sleep(2000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(new Date(new Date().getTime() + 2000L), protector).done();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
    }

    @Test
    public void generateA_expire_primaryB_expire_isPrimaryB() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InterruptedException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().modernKeyRing("A", null);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(new Date(), protector).done();
        Thread.sleep(2000L);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("A", info);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addPrimaryUserId((CharSequence)"B", protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsNotValid("A", info);
        Thread.sleep(1000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(new Date(new Date().getTime() + 10000L), protector).done();
        Thread.sleep(1000L);
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).addUserId((CharSequence)"A", protector).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("B", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsValid("A", info);
        ChangePrimaryUserIdAndExpirationDatesTest.assertIsPrimaryUserId("B", info);
    }

    private static void assertIsPrimaryUserId(String userId, KeyRingInfo info) {
        Assertions.assertEquals((Object)userId, (Object)info.getPrimaryUserId());
    }

    private static void assertIsNotPrimaryUserId(String userId, KeyRingInfo info) {
        PGPSignature signature = info.getLatestUserIdCertification(userId);
        if (signature == null) {
            return;
        }
        Assertions.assertFalse((boolean)signature.getHashedSubPackets().isPrimaryUserID());
    }

    private static void assertIsValid(String userId, KeyRingInfo info) {
        Assertions.assertTrue((boolean)info.isUserIdValid(userId));
    }

    private static void assertIsNotValid(String userId, KeyRingInfo info) {
        Assertions.assertFalse((boolean)info.isUserIdValid(userId));
    }
}

